/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.actions;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.modules.websvc.api.support.AddOperationCookie;
import org.netbeans.modules.websvc.api.support.java.SourceUtils;
import org.netbeans.modules.websvc.core.JaxWsUtils;
import org.netbeans.modules.websvc.core.WebServiceActionProvider;
import org.netbeans.spi.editor.codegen.CodeGenerator;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class SetSoapVersionActionGenerator
implements CodeGenerator {
    private FileObject targetSource;

    SetSoapVersionActionGenerator(FileObject targetSource) {
        this.targetSource = targetSource;
    }

    public String getDisplayName() {
        String name = "LBL_SetSoap12";
        if (this.targetSource != null && JaxWsUtils.isSoap12(this.targetSource)) {
            name = "LBL_SetSoap11";
        }
        return NbBundle.getMessage(SetSoapVersionActionGenerator.class, (String)name);
    }

    public void invoke() {
        JaxWsUtils.setSOAP12Binding(this.targetSource, !JaxWsUtils.isSoap12(this.targetSource));
    }

    public static class Factory
    implements CodeGenerator.Factory {
        public List<? extends CodeGenerator> create(Lookup context) {
            CompilationController controller = (CompilationController)context.lookup(CompilationController.class);
            ArrayList<SetSoapVersionActionGenerator> ret = new ArrayList<SetSoapVersionActionGenerator>();
            if (controller != null) {
                try {
                    AddOperationCookie addOperationCookie;
                    controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    FileObject targetSource = controller.getFileObject();
                    if (targetSource != null && (addOperationCookie = WebServiceActionProvider.getAddOperationAction(targetSource)) != null && this.isEnabledInEditor(context)) {
                        ret.add(new SetSoapVersionActionGenerator(targetSource));
                    }
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
            return ret;
        }

        private boolean isEnabledInEditor(Lookup nodeLookup) {
            TypeElement classEl;
            CompilationController controller = (CompilationController)nodeLookup.lookup(CompilationController.class);
            if (controller != null && (classEl = SourceUtils.getPublicTopLevelElement((CompilationController)controller)) != null) {
                return this.isJaxWsImplementationClass(classEl, controller);
            }
            return false;
        }

        private boolean isJaxWsImplementationClass(TypeElement classEl, CompilationController controller) {
            TypeElement wsElement = controller.getElements().getTypeElement("javax.jws.WebService");
            if (wsElement != null) {
                List<? extends AnnotationMirror> annotations = classEl.getAnnotationMirrors();
                for (AnnotationMirror annotationMirror : annotations) {
                    if (!controller.getTypes().isSameType(wsElement.asType(), annotationMirror.getAnnotationType())) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

