/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.netbeans.api.debugger.jpda.DeadlockDetector;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.ThreadsCollector;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.openide.util.WeakListeners;

public class ThreadsCollectorImpl
extends ThreadsCollector {
    private JPDADebuggerImpl debugger;
    private PropertyChangeListener changesInThreadsListener;
    private final Map<JPDAThread, ThreadStateListener> threadStateListeners = new WeakHashMap<JPDAThread, ThreadStateListener>();
    private final List<JPDAThread> threads = new ArrayList<JPDAThread>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThreadsCollectorImpl(JPDADebuggerImpl debugger) {
        this.debugger = debugger;
        List<JPDAThread> allThreads = debugger.getAllThreads();
        List<JPDAThread> list = this.threads;
        synchronized (list) {
            this.threads.addAll(allThreads);
        }
        this.changesInThreadsListener = new ChangesInThreadsListener();
        debugger.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.changesInThreadsListener, (Object)((Object)debugger)));
        for (JPDAThread thread : allThreads) {
            this.watchThread(thread);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<JPDAThread> getAllThreads() {
        List<JPDAThread> list = this.threads;
        synchronized (list) {
            return Collections.unmodifiableList(new ArrayList<JPDAThread>(this.threads));
        }
    }

    public DeadlockDetector getDeadlockDetector() {
        return this.debugger.getDeadlockDetector();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void watchThread(JPDAThread thread) {
        Map<JPDAThread, ThreadStateListener> map = this.threadStateListeners;
        synchronized (map) {
            if (!this.threadStateListeners.containsKey(thread)) {
                this.threadStateListeners.put(thread, new ThreadStateListener(thread));
            }
        }
    }

    public boolean isSomeThreadRunning() {
        for (JPDAThread thread : this.getAllThreads()) {
            if (thread.isSuspended() || ((JPDAThreadImpl)thread).isMethodInvoking()) continue;
            return true;
        }
        return false;
    }

    public boolean isSomeThreadSuspended() {
        for (JPDAThread thread : this.getAllThreads()) {
            if (!thread.isSuspended() && !((JPDAThreadImpl)thread).isMethodInvoking()) continue;
            return true;
        }
        return false;
    }

    private class ChangesInThreadsListener
    implements PropertyChangeListener {
        private ChangesInThreadsListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String propertyName = evt.getPropertyName();
            if ("threadStarted".equals(propertyName)) {
                JPDAThread thread = (JPDAThread)evt.getNewValue();
                ThreadsCollectorImpl.this.watchThread(thread);
                List list = ThreadsCollectorImpl.this.threads;
                synchronized (list) {
                    if (!ThreadsCollectorImpl.this.threads.contains(thread)) {
                        ThreadsCollectorImpl.this.threads.add(thread);
                    }
                }
                ThreadsCollectorImpl.this.firePropertyChange("threadStarted", evt.getOldValue(), evt.getNewValue());
            } else if ("threadDied".equals(propertyName)) {
                JPDAThread thread = (JPDAThread)evt.getOldValue();
                List list = ThreadsCollectorImpl.this.threads;
                synchronized (list) {
                    ThreadsCollectorImpl.this.threads.remove(thread);
                }
                ThreadsCollectorImpl.this.firePropertyChange("threadDied", evt.getOldValue(), evt.getNewValue());
            } else if ("threadGroupAdded".equals(propertyName)) {
                ThreadsCollectorImpl.this.firePropertyChange("threadGroupAdded", evt.getOldValue(), evt.getNewValue());
            }
        }
    }

    private class ThreadStateListener
    implements PropertyChangeListener {
        public ThreadStateListener(JPDAThread thread) {
            ((JPDAThreadImpl)thread).addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)thread));
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("suspended".equals(evt.getPropertyName())) {
                if ("methodInvoke".equals(evt.getPropagationId())) {
                    return;
                }
                JPDAThread thread = (JPDAThread)evt.getSource();
                if (thread.isSuspended()) {
                    ThreadsCollectorImpl.this.firePropertyChange("threadSuspended", null, thread);
                } else {
                    ThreadsCollectorImpl.this.firePropertyChange("threadResumed", null, thread);
                }
            }
        }
    }
}

