/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class RepositoryObject
extends ExplicitlySetBmcModel {
    @JsonProperty(value="type")
    private final Type type;
    @JsonProperty(value="sizeInBytes")
    private final Long sizeInBytes;
    @JsonProperty(value="sha")
    private final String sha;
    @JsonProperty(value="isBinary")
    private final Boolean isBinary;

    @Deprecated
    @ConstructorProperties(value={"type", "sizeInBytes", "sha", "isBinary"})
    public RepositoryObject(Type type, Long sizeInBytes, String sha, Boolean isBinary) {
        this.type = type;
        this.sizeInBytes = sizeInBytes;
        this.sha = sha;
        this.isBinary = isBinary;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Type getType() {
        return this.type;
    }

    public Long getSizeInBytes() {
        return this.sizeInBytes;
    }

    public String getSha() {
        return this.sha;
    }

    public Boolean getIsBinary() {
        return this.isBinary;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("RepositoryObject(");
        sb.append("super=").append(super.toString());
        sb.append("type=").append(String.valueOf((Object)this.type));
        sb.append(", sizeInBytes=").append(String.valueOf(this.sizeInBytes));
        sb.append(", sha=").append(String.valueOf(this.sha));
        sb.append(", isBinary=").append(String.valueOf(this.isBinary));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RepositoryObject)) {
            return false;
        }
        RepositoryObject other = (RepositoryObject)((Object)o);
        return Objects.equals((Object)this.type, (Object)other.type) && Objects.equals(this.sizeInBytes, other.sizeInBytes) && Objects.equals(this.sha, other.sha) && Objects.equals(this.isBinary, other.isBinary) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.type == null ? 43 : this.type.hashCode());
        result = result * 59 + (this.sizeInBytes == null ? 43 : this.sizeInBytes.hashCode());
        result = result * 59 + (this.sha == null ? 43 : this.sha.hashCode());
        result = result * 59 + (this.isBinary == null ? 43 : this.isBinary.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Type implements BmcEnum
    {
        Blob("BLOB"),
        Tree("TREE"),
        Commit("COMMIT"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Type> map;

        private Type(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Type create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Type', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Type.class);
            map = new HashMap<String, Type>();
            for (Type v : Type.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="type")
        private Type type;
        @JsonProperty(value="sizeInBytes")
        private Long sizeInBytes;
        @JsonProperty(value="sha")
        private String sha;
        @JsonProperty(value="isBinary")
        private Boolean isBinary;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder type(Type type) {
            this.type = type;
            this.__explicitlySet__.add("type");
            return this;
        }

        public Builder sizeInBytes(Long sizeInBytes) {
            this.sizeInBytes = sizeInBytes;
            this.__explicitlySet__.add("sizeInBytes");
            return this;
        }

        public Builder sha(String sha) {
            this.sha = sha;
            this.__explicitlySet__.add("sha");
            return this;
        }

        public Builder isBinary(Boolean isBinary) {
            this.isBinary = isBinary;
            this.__explicitlySet__.add("isBinary");
            return this;
        }

        public RepositoryObject build() {
            RepositoryObject model = new RepositoryObject(this.type, this.sizeInBytes, this.sha, this.isBinary);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(RepositoryObject model) {
            if (model.wasPropertyExplicitlySet("type")) {
                this.type(model.getType());
            }
            if (model.wasPropertyExplicitlySet("sizeInBytes")) {
                this.sizeInBytes(model.getSizeInBytes());
            }
            if (model.wasPropertyExplicitlySet("sha")) {
                this.sha(model.getSha());
            }
            if (model.wasPropertyExplicitlySet("isBinary")) {
                this.isBinary(model.getIsBinary());
            }
            return this;
        }
    }
}

