/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.editor.parser.processors;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.xml.lexer.XMLTokenId;
import org.netbeans.modules.javafx2.editor.ErrorMark;
import org.netbeans.modules.javafx2.editor.ErrorReporter;
import org.netbeans.modules.javafx2.editor.completion.model.FxModel;
import org.netbeans.modules.javafx2.editor.completion.model.FxNewInstance;
import org.netbeans.modules.javafx2.editor.completion.model.FxNode;
import org.netbeans.modules.javafx2.editor.completion.model.FxNodeVisitor;
import org.netbeans.modules.javafx2.editor.completion.model.FxTreeUtilities;
import org.netbeans.modules.javafx2.editor.completion.model.ImportDecl;
import org.netbeans.modules.javafx2.editor.parser.processors.Bundle;
import org.openide.util.Parameters;

public final class ImportProcessor
extends FxNodeVisitor.ModelTraversal {
    private Map<String, String> importedNames = new HashMap<String, String>();
    private Map<String, Object> packageNames = new HashMap<String, Object>();
    private Set<String> allPackages = new HashSet<String>();
    private CompilationInfo info;
    private ErrorReporter errors;
    private TokenHierarchy<?> hierarchy;
    private ImportDecl current;
    private FxTreeUtilities nodes;

    public ImportProcessor(TokenHierarchy<?> h, ErrorReporter errors, FxTreeUtilities nodes) {
        Parameters.notNull((CharSequence)"h", h);
        this.hierarchy = h;
        this.errors = errors;
        this.nodes = nodes;
    }

    public void load(CompilationInfo info, FxModel source) {
        Parameters.notNull((CharSequence)"info", (Object)info);
        this.info = info;
        try {
            this.handleWildcard("java.lang", false);
            source.accept(this);
        }
        finally {
            this.info = null;
        }
    }

    public Set<String> resolveTypeName(CompilationInfo info, String anyName) {
        int dot = anyName.indexOf(46);
        if (dot == -1) {
            return this.resolveName(anyName);
        }
        TypeElement el = info.getElements().getTypeElement(anyName);
        if (el != null) {
            return Collections.singleton(el.getQualifiedName().toString());
        }
        String firstPart = anyName.substring(0, dot);
        Set<String> resolved = this.resolveName(firstPart);
        if (resolved == null) {
            return null;
        }
        if (resolved.size() == 1) {
            String resolvedClass = resolved.iterator().next();
            String joined = resolvedClass + anyName.substring(dot);
            el = info.getElements().getTypeElement(joined);
            if (el != null) {
                return Collections.singleton(el.getQualifiedName().toString());
            }
            return null;
        }
        HashSet<String> result = new HashSet<String>();
        for (String prefix : resolved) {
            String joined = prefix + anyName.substring(dot);
            el = info.getElements().getTypeElement(joined);
            if (el == null) continue;
            result.add(el.getQualifiedName().toString());
        }
        return result;
    }

    public Set<String> resolveName(String simpleName) {
        String res = this.importedNames.get(simpleName);
        if (res != null) {
            return Collections.singleton(res);
        }
        Object o = this.packageNames.get(simpleName);
        if (o instanceof String) {
            String n = (String)o;
            return Collections.singleton(n + "." + simpleName);
        }
        if (o == null) {
            return null;
        }
        Set packs = (Set)o;
        HashSet<String> result = new HashSet<String>();
        for (String pn : packs) {
            result.add(pn + "." + simpleName);
        }
        return Collections.unmodifiableSet(result);
    }

    public Set<String> getImportedPackages() {
        return Collections.unmodifiableSet(this.allPackages);
    }

    @Override
    public void visitImport(ImportDecl decl) {
        this.current = decl;
        if (!decl.isWildcard()) {
            this.handleSingleImport(decl.getImportedName());
        } else {
            this.handleWildcard(decl.getImportedName(), true);
        }
    }

    private void handleWildcard(String packName, boolean add) {
        PackageElement el = this.info.getElements().getPackageElement(packName);
        if (el == null) {
            if (this.current == null) {
                return;
            }
            int[] offsets = this.findPiContentOffsets(this.current);
            this.addError(new ErrorMark(offsets[0], offsets[1] - offsets[0], "import-package-not-exists", Bundle.ERR_importPackageNotExists(packName), packName));
            return;
        }
        if (add) {
            this.allPackages.add(packName);
        }
        List<TypeElement> types = ElementFilter.typesIn(el.getEnclosedElements());
        for (TypeElement t : types) {
            this.addType(t.getSimpleName().toString(), packName);
        }
    }

    private void addType(String sn, String pack) {
        Collection<String> packs;
        Object o = this.packageNames.get(sn);
        if (o == null) {
            this.packageNames.put(sn, pack);
            return;
        }
        if (o instanceof String) {
            packs = new HashSet<String>();
            packs.add((String)o);
            this.packageNames.put(sn, packs);
        } else if (o instanceof Collection) {
            packs = (Collection)o;
        } else {
            throw new IllegalStateException(sn);
        }
        packs.add(pack);
    }

    private void addError(ErrorMark mark) {
        if (this.errors == null) {
            return;
        }
        this.errors.addError(mark);
    }

    private void handleSingleImport(String name) {
        int dotIndex;
        TypeElement tel = this.info.getElements().getTypeElement(name);
        if (tel == null) {
            int[] offsets = this.findPiContentOffsets(this.current);
            this.addError(new ErrorMark(offsets[0], offsets[1] - offsets[0], "import-identifier-not-exists", Bundle.ERR_importIdentifierNotExists(name), name));
        }
        String simpleName = (dotIndex = name.lastIndexOf(46)) == -1 ? name : name.substring(dotIndex + 1);
        this.importedNames.put(simpleName, name);
    }

    private int[] findPiContentOffsets(FxNode node) {
        TokenSequence seq = this.hierarchy.tokenSequence();
        int start = -1;
        int end = -1;
        int s = this.nodes.positions(node).getStart();
        seq.move(s);
        boolean cont = true;
        block4: while (cont && seq.moveNext()) {
            Token token = seq.token();
            switch ((XMLTokenId)token.id()) {
                case PI_TARGET: 
                case PI_START: 
                case WS: {
                    continue block4;
                }
                case PI_CONTENT: {
                    if (start == -1) {
                        start = seq.offset();
                    }
                    end = seq.offset() + token.length();
                    continue block4;
                }
            }
            cont = false;
        }
        return new int[]{start, end};
    }

    @Override
    public void visitInstance(FxNewInstance decl) {
    }
}

