/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.retriever.catalog.impl;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Logger;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.xml.resolver.apps.resolver;
import org.netbeans.modules.xml.retriever.catalog.CatalogAttribute;
import org.netbeans.modules.xml.retriever.catalog.CatalogElement;
import org.netbeans.modules.xml.retriever.catalog.CatalogEntry;
import org.netbeans.modules.xml.retriever.catalog.impl.CatalogEntryImpl;
import org.netbeans.modules.xml.retriever.catalog.impl.CatalogFileWrapper;
import org.netbeans.modules.xml.xam.Model;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class CatalogFileWrapperDOMImpl
implements EntityResolver,
CatalogFileWrapper,
DocumentListener {
    PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private org.w3c.dom.Document catDoc = null;
    private Element catalog = null;
    private boolean isItMyOwnEvent = false;
    public static Document backendCatalogSwingDocument = null;
    private static final Logger logger = Logger.getLogger(CatalogFileWrapperDOMImpl.class.getName());
    private Model.State currentStateOfCatalog = null;
    public static boolean TEST_ENVIRONMENT = false;
    private FileObject backendCatalogFileObj = null;
    boolean rawFileSaveStrategy = false;
    SaveCookie saveCookie = null;
    static WeakHashMap<FileObject, CatalogFileWrapper> fo2wrapMap = new WeakHashMap();

    private CatalogFileWrapperDOMImpl(FileObject backendCatalogFileObj, boolean rawFileSaveStrategy) throws IOException {
        this.rawFileSaveStrategy = rawFileSaveStrategy;
        this.backendCatalogFileObj = backendCatalogFileObj;
        assert (backendCatalogFileObj != null);
    }

    private synchronized void bootstrap() {
        try {
            backendCatalogSwingDocument = this.getDocument(this.backendCatalogFileObj);
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
        assert (this.backendCatalogFileObj != null);
        try {
            this.sync();
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
        if (this.currentStateOfCatalog == Model.State.NOT_WELL_FORMED) {
            throw new IllegalStateException("Catalog File Not wellformed");
        }
    }

    private synchronized void tearDown() {
        backendCatalogSwingDocument = null;
        this.catalog = null;
        this.catDoc = null;
    }

    public static synchronized CatalogFileWrapper getInstance(FileObject backendCatalogFileObj, boolean rawFileSaveStrategy) throws IOException {
        CatalogFileWrapper result = fo2wrapMap.get(backendCatalogFileObj);
        if (result == null && (result = new CatalogFileWrapperDOMImpl(backendCatalogFileObj, rawFileSaveStrategy)) != null) {
            fo2wrapMap.put(backendCatalogFileObj, result);
            return result;
        }
        return result;
    }

    public static synchronized CatalogFileWrapper getInstance(FileObject backendCatalogFileObj) throws IOException {
        return CatalogFileWrapperDOMImpl.getInstance(backendCatalogFileObj, false);
    }

    @Override
    public synchronized void cleanInstance() {
    }

    private Document getDocument(FileObject backendCatalogFileObj) throws IOException {
        logger.finer("ENTER FileObject " + backendCatalogFileObj.toString());
        DataObject dobj = DataObject.find((FileObject)backendCatalogFileObj);
        EditorCookie thisDocumentEditorCookie = (EditorCookie)dobj.getCookie(EditorCookie.class);
        StyledDocument sd = thisDocumentEditorCookie.openDocument();
        logger.finer("RETURN");
        return sd;
    }

    private boolean shouldParse(String docContent) {
        return docContent != null && docContent.toLowerCase().indexOf("catalog") != -1;
    }

    @Override
    public List<CatalogEntry> getSystems() {
        return this.getEntriesByTagName(CatalogElement.system, CatalogAttribute.systemId, CatalogAttribute.uri);
    }

    @Override
    public void setSystem(int index, CatalogEntry catEnt) throws IOException {
        this.setEntryInCatalogFile(index, catEnt, CatalogAttribute.systemId, CatalogAttribute.uri);
    }

    @Override
    public void deleteSystem(int index) throws IOException {
        this.deleteEntryFromCatalogFile(index, CatalogElement.system);
    }

    @Override
    public void addSystem(CatalogEntry catEnt) throws IOException {
        this.addEntryToCatFile(catEnt, CatalogAttribute.systemId, CatalogAttribute.uri);
    }

    @Override
    public List<CatalogEntry> getDelegateSystems() {
        return this.getEntriesByTagName(CatalogElement.delegateSystem, CatalogAttribute.systemIdStartString, CatalogAttribute.catalog);
    }

    @Override
    public void setDelegateSystem(int index, CatalogEntry catEnt) throws IOException {
        this.setEntryInCatalogFile(index, catEnt, CatalogAttribute.systemIdStartString, CatalogAttribute.catalog);
    }

    @Override
    public void deleteDelegateSystem(int index) throws IOException {
        this.deleteEntryFromCatalogFile(index, CatalogElement.delegateSystem);
    }

    @Override
    public void addDelegateSystem(CatalogEntry catEnt) throws IOException {
        this.addEntryToCatFile(catEnt, CatalogAttribute.systemIdStartString, CatalogAttribute.catalog);
    }

    @Override
    public List<CatalogEntry> getRewriteSystems() {
        return this.getEntriesByTagName(CatalogElement.rewriteSystem, CatalogAttribute.systemIdStartString, CatalogAttribute.rewritePrefix);
    }

    @Override
    public void setRewriteSystem(int index, CatalogEntry catEnt) throws IOException {
        this.setEntryInCatalogFile(index, catEnt, CatalogAttribute.systemIdStartString, CatalogAttribute.rewritePrefix);
    }

    @Override
    public void deleteRewriteSystem(int index) throws IOException {
        this.deleteEntryFromCatalogFile(index, CatalogElement.rewriteSystem);
    }

    @Override
    public void addRewriteSystem(CatalogEntry catEnt) throws IOException {
        this.addEntryToCatFile(catEnt, CatalogAttribute.systemIdStartString, CatalogAttribute.rewritePrefix);
    }

    private void initCatFile() throws IOException {
        logger.finer("ENTER");
        NodeList nl = this.catDoc.getElementsByTagName(CatalogElement.catalog.toString());
        if (nl.getLength() <= 0) {
            this.catalog = this.catDoc.createElement(CatalogElement.catalog.toString());
            this.catalog.setAttribute(CatalogAttribute.prefer.toString(), "system");
            this.catalog.setAttribute(CatalogAttribute.xmlns.toString(), "urn:oasis:names:tc:entity:xmlns:xml:catalog");
            this.catDoc.appendChild(this.catalog);
            this.flush();
        } else {
            this.catalog = (Element)nl.item(0);
        }
        logger.finer("RETURN");
    }

    private List<CatalogEntry> getEntriesByTagName(CatalogElement tagName, CatalogAttribute mappingEntityKey, CatalogAttribute mappedEntityKey) {
        this.bootstrap();
        Object[] obj = new Object[]{tagName.toString(), mappingEntityKey.toString(), mappedEntityKey.toString()};
        logger.entering("CatalogModelWrapperDOMImpl", "getEntriesByTagName", obj);
        NodeList nl = this.catalog.getElementsByTagName(tagName.toString());
        int len = nl.getLength();
        if (len < 1) {
            return null;
        }
        ArrayList<CatalogEntry> result = new ArrayList<CatalogEntry>(nl.getLength());
        for (int i = 0; i < len; ++i) {
            String mappingEntity = "";
            String mappedEntity = "";
            Element elm = (Element)nl.item(i);
            mappingEntity = elm.getAttribute(mappingEntityKey.toString());
            mappedEntity = elm.getAttribute(mappedEntityKey.toString());
            String[] strArry = new String[]{mappingEntityKey.toString(), mappedEntityKey.toString()};
            HashMap<String, String> extraAttrs = this.getOtherAttributes(elm, strArry);
            CatalogEntryImpl catEnt = extraAttrs != null ? new CatalogEntryImpl(tagName, mappingEntity, mappedEntity, extraAttrs) : new CatalogEntryImpl(tagName, mappingEntity, mappedEntity);
            result.add(catEnt);
        }
        logger.exiting("CatalogModelWrapperDOMImpl", "getEntriesByTagName", result);
        this.tearDown();
        return result;
    }

    private void addEntryToCatFile(CatalogEntry catEnt, CatalogAttribute mappingEntityKey, CatalogAttribute mappedEntityKey) throws IOException {
        HashMap<String, String> extraAttribMap;
        this.bootstrap();
        Element elm = this.catDoc.createElement(catEnt.getEntryType().toString());
        if (mappedEntityKey != null) {
            elm.setAttribute(mappedEntityKey.toString(), catEnt.getTarget());
        }
        if (mappingEntityKey != null) {
            elm.setAttribute(mappingEntityKey.toString(), catEnt.getSource());
        }
        if ((extraAttribMap = catEnt.getExtraAttributeMap()) != null) {
            this.addOtherAttributesToElement(elm, extraAttribMap);
        }
        this.catalog.appendChild(elm);
        this.flush();
        logger.exiting(this.toString(), "addEntryToCatFile");
        this.tearDown();
    }

    private void setEntryInCatalogFile(int index, CatalogEntry catEnt, CatalogAttribute mappingEntityKey, CatalogAttribute mappedEntityKey) throws IOException {
        NodeList nl;
        int len;
        this.bootstrap();
        Object[] obj = new Object[]{index, catEnt.toString(), mappingEntityKey.toString(), mappedEntityKey.toString()};
        logger.entering("CatalogModelWrapperDOMImpl", "setEntryInCatalogFile", obj);
        Element elm = this.catDoc.createElement(catEnt.getEntryType().toString());
        elm.setAttribute(mappedEntityKey.toString(), catEnt.getTarget());
        elm.setAttribute(mappingEntityKey.toString(), catEnt.getSource());
        HashMap<String, String> extraAttribMap = catEnt.getExtraAttributeMap();
        if (extraAttribMap != null) {
            this.addOtherAttributesToElement(elm, extraAttribMap);
        }
        if (index >= (len = (nl = this.catalog.getElementsByTagName(catEnt.getEntryType().toString())).getLength()) || index < 0) {
            throw new IndexOutOfBoundsException("Error: Catalog entry does not exists");
        }
        Node oldNode = nl.item(index);
        this.catalog.replaceChild(elm, oldNode);
        this.flush();
        logger.exiting(this.toString(), "setEntryInCatalogFile");
        this.tearDown();
    }

    private void deleteEntryFromCatalogFile(int index, CatalogElement tagName) throws IOException {
        logger.entering(this.toString(), "deleteEntryFromCatalogFile");
        this.bootstrap();
        NodeList nl = this.catalog.getElementsByTagName(tagName.toString());
        int len = nl.getLength();
        if (index >= len || index < 0) {
            throw new IndexOutOfBoundsException("Error: Catalog entry does not exists");
        }
        Node oldNode = nl.item(index);
        this.catalog.removeChild(oldNode);
        this.flush();
        logger.exiting(this.toString(), "deleteEntryFromCatalogFile");
        this.tearDown();
    }

    private void addOtherAttributesToElement(Element elm, HashMap<String, String> extraAttribMap) {
        if (extraAttribMap == null) {
            return;
        }
        Set<String> keys = extraAttribMap.keySet();
        if (keys == null) {
            return;
        }
        for (String key : keys) {
            String value = extraAttribMap.get(key);
            if (value == null) continue;
            elm.setAttribute(key, value);
        }
    }

    private HashMap<String, String> getOtherAttributes(Element elm, String[] strArry) {
        HashMap<String, String> result = new HashMap<String, String>();
        NamedNodeMap attrs = elm.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            String key = attrs.item(i).getNodeName();
            boolean isMainAttrib = false;
            for (String str : strArry) {
                if (!str.equals(key)) continue;
                isMainAttrib = true;
                break;
            }
            if (isMainAttrib) continue;
            String value = attrs.item(i).getNodeValue();
            if (key == null || value == null) continue;
            result.put(key, value);
        }
        if (result.isEmpty()) {
            return null;
        }
        return result;
    }

    public synchronized void sync() throws IOException {
        logger.finer("ENTER");
        DocumentBuilderFactory dBuilderFact = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = null;
        try {
            dBuilder = dBuilderFact.newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            this.assignStateAndFirePropChangeEvent(Model.State.NOT_WELL_FORMED);
            throw new IOException(ex.getMessage());
        }
        String docContent = null;
        try {
            docContent = backendCatalogSwingDocument.getText(0, backendCatalogSwingDocument.getLength());
        }
        catch (BadLocationException ex) {
            this.assignStateAndFirePropChangeEvent(Model.State.NOT_WELL_FORMED);
            throw new IOException(ex.getMessage());
        }
        logger.finer("Trying to sync this data to model:" + docContent);
        if (this.shouldParse(docContent)) {
            ByteArrayInputStream catIS = new ByteArrayInputStream(docContent.getBytes());
            try {
                this.catDoc = dBuilder.parse(catIS);
                logger.finer("Just synced this data :" + docContent);
            }
            catch (SAXException ex) {
                this.assignStateAndFirePropChangeEvent(Model.State.NOT_WELL_FORMED);
                throw new IOException(ex.getMessage());
            }
        } else {
            this.catDoc = dBuilder.newDocument();
        }
        if (this.catDoc == null) {
            this.assignStateAndFirePropChangeEvent(Model.State.NOT_WELL_FORMED);
            throw new IllegalStateException("Catalog File Not wellformed");
        }
        this.assignStateAndFirePropChangeEvent(Model.State.VALID);
        this.initCatFile();
        logger.finer("RETURN");
    }

    private void assignStateAndFirePropChangeEvent(Model.State currentStateOfCatalog) {
        Model.State prevState = this.currentStateOfCatalog;
        this.currentStateOfCatalog = currentStateOfCatalog;
        this.pcs.firePropertyChange("CatalogWraperObject", prevState, currentStateOfCatalog);
    }

    public boolean isValidState() {
        return this.currentStateOfCatalog == Model.State.VALID;
    }

    public synchronized void flush() throws IOException {
        logger.finer("ENTER");
        this.isItMyOwnEvent = true;
        try {
            TransformerFactory trFactory = TransformerFactory.newInstance();
            Transformer transformer = trFactory.newTransformer();
            DOMSource domSource = new DOMSource(this.catDoc);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            StreamResult streamResult = new StreamResult(baos);
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(domSource, streamResult);
            String fileContent = new String(baos.toByteArray());
            String prevContent = backendCatalogSwingDocument.getText(0, backendCatalogSwingDocument.getLength());
            if (fileContent.equals(prevContent)) {
                this.isItMyOwnEvent = false;
                return;
            }
            backendCatalogSwingDocument.remove(0, backendCatalogSwingDocument.getLength());
            backendCatalogSwingDocument.insertString(0, fileContent, null);
            logger.finer("Just Flushed this data :" + backendCatalogSwingDocument.getText(0, backendCatalogSwingDocument.getLength()));
            this.save(fileContent, prevContent);
        }
        catch (Exception ex) {
            throw new IOException(ex.getMessage());
        }
        finally {
            this.isItMyOwnEvent = false;
        }
        logger.finer("RETURN");
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        logger.entering("CatalogModelWrapperDOMImpl", "insertUpdate", this.isItMyOwnEvent);
        if (!this.isItMyOwnEvent) {
            try {
                this.sync();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return;
        }
    }

    void showStackTrace() {
        try {
            throw new Exception();
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.showStackTrace();
        logger.entering("CatalogModelWrapperDOMImpl", "removeUpdate", this.isItMyOwnEvent);
        this.insertUpdate(e);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        logger.entering("CatalogModelWrapperDOMImpl", "changedUpdate", this.isItMyOwnEvent);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(l);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(l);
    }

    public InputStream getCatalogAsStream() throws IOException {
        try {
            String docContent = backendCatalogSwingDocument.getText(0, backendCatalogSwingDocument.getLength());
            ByteArrayInputStream bis = new ByteArrayInputStream(docContent.getBytes());
            logger.finer("In getCatalogAsStream gona return:" + docContent);
            return bis;
        }
        catch (BadLocationException ex) {
            throw new IOException(ex.getMessage());
        }
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        logger.finest("ENTRY PublicID:" + publicId + " SystemID:" + systemId);
        InputSource isrc = new InputSource();
        InputStreamReader isr = new InputStreamReader(resolver.class.getResourceAsStream("/org/apache/xml/resolver/etc/catalog.dtd"));
        isrc.setCharacterStream(isr);
        if (systemId != null && systemId.equals("urn:oasis:names:tc:entity:xmlns:xml:catalog")) {
            logger.finest("RETURN the DTD");
            return isrc;
        }
        if (publicId != null && publicId.equals("urn:oasis:names:tc:entity:xmlns:xml:catalog")) {
            logger.finest("RETURN the DTD");
            return isrc;
        }
        logger.finest("RETURN null");
        return null;
    }

    private void save(String fileContent, String previousFileContent) {
        if (TEST_ENVIRONMENT) {
            this.saveByRawStreamByFile(fileContent, previousFileContent);
        } else {
            this.saveBySaveCookie();
        }
    }

    boolean saveBySaveCookie() {
        try {
            DataObject dobj = DataObject.find((FileObject)this.backendCatalogFileObj);
            SaveCookie saveCookie = (SaveCookie)dobj.getCookie(SaveCookie.class);
            assert (saveCookie != null);
            saveCookie.save();
        }
        catch (IOException ex) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean saveByRawStreamByFO(String fileContent, String previousFileContent) {
        OutputStream os = null;
        FileLock lock = null;
        boolean noException = true;
        try {
            lock = this.backendCatalogFileObj.lock();
            os = this.backendCatalogFileObj.getOutputStream(lock);
            os.write(fileContent.getBytes());
            os.flush();
            os.close();
            lock.releaseLock();
            os = null;
            return (boolean)os;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            noException = false;
            return noException;
        }
        finally {
            if (lock != null) {
                lock.releaseLock();
            }
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException iOException) {}
            }
            return noException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean saveByRawStreamByFile(String fileContent, String previousFileContent) {
        OutputStream os = null;
        try {
            File catFile = FileUtil.toFile((FileObject)this.backendCatalogFileObj);
            os = new FileOutputStream(catFile);
            os.write(fileContent.getBytes());
            os.flush();
            os.close();
            os = null;
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                    return false;
                }
                catch (IOException iOException) {}
            }
        }
        return true;
    }

    void saveByDocumentEditorCookie() {
        try {
            DataObject dobj = DataObject.find((FileObject)this.backendCatalogFileObj);
            EditorCookie thisDocumentEditorCookie = (EditorCookie)dobj.getCookie(EditorCookie.class);
            thisDocumentEditorCookie.saveDocument();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private boolean unsuccessfulSave(String fileContent, String previousFileContent) {
        try {
            if (backendCatalogSwingDocument.getText(0, backendCatalogSwingDocument.getLength()).length() != fileContent.length()) {
                return true;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public void close() {
    }

    @Override
    public Model.State getCatalogState() {
        this.bootstrap();
        this.tearDown();
        return this.currentStateOfCatalog;
    }

    protected void finalize() throws Throwable {
        try {
            DataObject dobj = DataObject.find((FileObject)this.backendCatalogFileObj);
            EditorCookie thisDocumentEditorCookie = (EditorCookie)dobj.getCookie(EditorCookie.class);
            backendCatalogSwingDocument.removeDocumentListener(this);
            thisDocumentEditorCookie.close();
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public void addNextCatalog(CatalogEntry catEnt) throws IOException {
        this.addEntryToCatFile(catEnt, CatalogAttribute.catalog, null);
    }

    @Override
    public void deleteNextCatalog(int index) throws IOException {
        this.deleteEntryFromCatalogFile(index, CatalogElement.nextCatalog);
    }

    @Override
    public List<CatalogEntry> getNextCatalogs() {
        return this.getEntriesByTagName(CatalogElement.nextCatalog, CatalogAttribute.catalog, CatalogAttribute.catalog);
    }
}

