/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.external;

import java.nio.charset.StandardCharsets;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import org.wildfly.security.mechanism._private.ElytronMessages;
import org.wildfly.security.sasl.util.AbstractSaslParticipant;
import org.wildfly.security.sasl.util.SaslWrapper;

final class ExternalSaslClient
implements SaslClient,
SaslWrapper {
    private final byte[] authorizationId;
    private boolean complete;

    ExternalSaslClient(String authorizationId) {
        this.authorizationId = authorizationId == null ? AbstractSaslParticipant.NO_BYTES : authorizationId.getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public String getMechanismName() {
        return "EXTERNAL";
    }

    @Override
    public boolean hasInitialResponse() {
        return true;
    }

    @Override
    public byte[] evaluateChallenge(byte[] challenge) throws SaslException {
        if (challenge.length != 0) {
            throw ElytronMessages.saslExternal.mechInvalidMessageReceived().toSaslException();
        }
        if (this.complete) {
            throw ElytronMessages.saslExternal.mechMessageAfterComplete().toSaslException();
        }
        this.complete = true;
        return this.authorizationId;
    }

    @Override
    public boolean isComplete() {
        return this.complete;
    }

    @Override
    public byte[] unwrap(byte[] incoming, int offset, int len) throws SaslException {
        if (this.complete) {
            throw ElytronMessages.saslExternal.mechNoSecurityLayer();
        }
        throw ElytronMessages.saslExternal.mechAuthenticationNotComplete();
    }

    @Override
    public byte[] wrap(byte[] outgoing, int offset, int len) throws SaslException {
        if (this.complete) {
            throw ElytronMessages.saslExternal.mechNoSecurityLayer();
        }
        throw ElytronMessages.saslExternal.mechAuthenticationNotComplete();
    }

    @Override
    public Object getNegotiatedProperty(String propName) {
        if (this.complete) {
            return null;
        }
        throw ElytronMessages.saslExternal.mechAuthenticationNotComplete();
    }

    @Override
    public void dispose() throws SaslException {
    }
}

