/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.OPTIONS;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.core.UriInfo;
import jakarta.ws.rs.ext.Provider;
import java.net.URI;
import java.util.Comparator;
import org.jboss.logging.Logger;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.AuthorizationService;
import org.keycloak.common.Profile;
import org.keycloak.common.util.KeycloakUriBuilder;
import org.keycloak.events.EventBuilder;
import org.keycloak.http.HttpRequest;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.protocol.LoginProtocol;
import org.keycloak.protocol.LoginProtocolFactory;
import org.keycloak.services.CorsErrorResponseException;
import org.keycloak.services.clientregistration.ClientRegistrationService;
import org.keycloak.services.cors.Cors;
import org.keycloak.services.managers.RealmManager;
import org.keycloak.services.resource.RealmResourceProvider;
import org.keycloak.services.resources.ClientsManagementService;
import org.keycloak.services.resources.IdentityBrokerService;
import org.keycloak.services.resources.LoginActionsService;
import org.keycloak.services.resources.PublicRealmResource;
import org.keycloak.services.resources.account.AccountLoader;
import org.keycloak.services.util.CacheControlUtil;
import org.keycloak.services.util.ResolveRelative;
import org.keycloak.utils.ProfileHelper;
import org.keycloak.wellknown.WellKnownProvider;
import org.keycloak.wellknown.WellKnownProviderFactory;

@Provider
@Path(value="/realms")
public class RealmsResource {
    protected static final Logger logger = Logger.getLogger(RealmsResource.class);
    @Context
    protected KeycloakSession session;

    public static UriBuilder realmBaseUrl(UriInfo uriInfo) {
        UriBuilder baseUriBuilder = uriInfo.getBaseUriBuilder();
        return RealmsResource.realmBaseUrl(baseUriBuilder);
    }

    public static UriBuilder realmBaseUrl(UriBuilder baseUriBuilder) {
        return baseUriBuilder.path(RealmsResource.class).path(RealmsResource.class, "getRealmResource");
    }

    public static UriBuilder accountUrl(UriBuilder base) {
        return base.path(RealmsResource.class).path(RealmsResource.class, "getAccountService");
    }

    public static UriBuilder protocolUrl(UriInfo uriInfo) {
        return uriInfo.getBaseUriBuilder().path(RealmsResource.class).path(RealmsResource.class, "getProtocol");
    }

    public static UriBuilder protocolUrl(UriBuilder builder) {
        return builder.path(RealmsResource.class).path(RealmsResource.class, "getProtocol");
    }

    public static UriBuilder clientRegistrationUrl(UriInfo uriInfo) {
        return uriInfo.getBaseUriBuilder().path(RealmsResource.class).path(RealmsResource.class, "getClientsService");
    }

    public static UriBuilder brokerUrl(UriInfo uriInfo) {
        return uriInfo.getBaseUriBuilder().path(RealmsResource.class).path(RealmsResource.class, "getBrokerService");
    }

    public static UriBuilder wellKnownProviderUrl(UriBuilder builder) {
        return builder.path(RealmsResource.class).path(RealmsResource.class, "getWellKnown");
    }

    @Path(value="{realm}/protocol/{protocol}")
    public Object getProtocol(@PathParam(value="realm") String name, @PathParam(value="protocol") String protocol) {
        this.resolveRealmAndUpdateSession(name);
        LoginProtocolFactory factory = (LoginProtocolFactory)this.session.getKeycloakSessionFactory().getProviderFactory(LoginProtocol.class, protocol);
        if (factory == null) {
            logger.debugf("protocol %s not found", (Object)protocol);
            throw new NotFoundException("Protocol not found");
        }
        EventBuilder event = new EventBuilder(this.session.getContext().getRealm(), this.session, this.session.getContext().getConnection());
        return factory.createProtocolEndpoint(this.session, event);
    }

    @GET
    @Path(value="{realm}/clients/{client_id}/redirect")
    public Response getRedirect(@PathParam(value="realm") String realmName, @PathParam(value="client_id") String clientId) {
        this.resolveRealmAndUpdateSession(realmName);
        RealmModel realm = this.session.getContext().getRealm();
        ClientModel client = realm.getClientByClientId(clientId);
        if (client == null) {
            return null;
        }
        if (client.getRootUrl() == null && client.getBaseUrl() == null) {
            return null;
        }
        URI targetUri = client.getRootUrl() != null && (client.getBaseUrl() == null || client.getBaseUrl().isEmpty()) ? KeycloakUriBuilder.fromUri((String)client.getRootUrl()).build(new Object[0]) : KeycloakUriBuilder.fromUri((String)ResolveRelative.resolveRelativeUri(this.session, client.getRootUrl(), client.getBaseUrl())).build(new Object[0]);
        return Response.seeOther((URI)targetUri).build();
    }

    @Path(value="{realm}/login-actions")
    public LoginActionsService getLoginActionsService(@PathParam(value="realm") String name) {
        this.resolveRealmAndUpdateSession(name);
        EventBuilder event = new EventBuilder(this.session.getContext().getRealm(), this.session, this.session.getContext().getConnection());
        return new LoginActionsService(this.session, event);
    }

    @Path(value="{realm}/clients-registrations")
    public ClientRegistrationService getClientsService(@PathParam(value="realm") String name) {
        this.resolveRealmAndUpdateSession(name);
        EventBuilder event = new EventBuilder(this.session.getContext().getRealm(), this.session, this.session.getContext().getConnection());
        return new ClientRegistrationService(this.session, event);
    }

    @Path(value="{realm}/clients-managements")
    public ClientsManagementService getClientsManagementService(@PathParam(value="realm") String name) {
        this.resolveRealmAndUpdateSession(name);
        EventBuilder event = new EventBuilder(this.session.getContext().getRealm(), this.session, this.session.getContext().getConnection());
        return new ClientsManagementService(this.session, event);
    }

    private void resolveRealmAndUpdateSession(String realmName) {
        RealmsResource.resolveRealmAndUpdateSession(this.session, realmName);
    }

    private static void resolveRealmAndUpdateSession(KeycloakSession session, String realmName) {
        RealmManager realmManager = new RealmManager(session);
        RealmModel realm = realmManager.getRealmByName(realmName);
        if (realm == null) {
            throw new NotFoundException("Realm does not exist");
        }
        session.getContext().setRealm(realm);
    }

    @Path(value="{realm}/account")
    public Object getAccountService(@PathParam(value="realm") String name) {
        this.resolveRealmAndUpdateSession(name);
        EventBuilder event = new EventBuilder(this.session.getContext().getRealm(), this.session, this.session.getContext().getConnection());
        return new AccountLoader(this.session, event);
    }

    @Path(value="{realm}")
    public PublicRealmResource getRealmResource(@PathParam(value="realm") String name) {
        this.resolveRealmAndUpdateSession(name);
        return new PublicRealmResource(this.session);
    }

    @Path(value="{realm}/broker")
    public IdentityBrokerService getBrokerService(@PathParam(value="realm") String name) {
        this.resolveRealmAndUpdateSession(name);
        IdentityBrokerService brokerService = new IdentityBrokerService(this.session);
        brokerService.init();
        return brokerService;
    }

    @OPTIONS
    @Path(value="{realm}/.well-known/{provider}")
    @Produces(value={"application/json"})
    public Response getVersionPreflight(@PathParam(value="realm") String name, @PathParam(value="provider") String providerName) {
        return Cors.builder().allowedMethods(new String[]{"GET"}).preflight().auth().add(Response.ok());
    }

    @GET
    @Path(value="{realm}/.well-known/{alias}")
    @Produces(value={"application/json", "application/jwt"})
    public Response getWellKnown(@PathParam(value="realm") String name, @PathParam(value="alias") String alias) {
        return RealmsResource.getWellKnownResponse(this.session, name, alias, logger);
    }

    public static Response getWellKnownResponse(KeycloakSession session, String name, String alias, Logger logger2) throws NotFoundException {
        RealmsResource.resolveRealmAndUpdateSession(session, name);
        RealmsResource.checkSsl(session, session.getContext().getRealm());
        WellKnownProviderFactory wellKnownProviderFactoryFound = session.getKeycloakSessionFactory().getProviderFactoriesStream(WellKnownProvider.class).map(providerFactory -> (WellKnownProviderFactory)providerFactory).filter(wellKnownProviderFactory -> alias.equals(wellKnownProviderFactory.getAlias())).sorted(Comparator.comparingInt(WellKnownProviderFactory::getPriority)).findFirst().orElseThrow(NotFoundException::new);
        logger2.tracef("Use provider with ID '%s' for well-known alias '%s'", (Object)wellKnownProviderFactoryFound.getId(), (Object)alias);
        WellKnownProvider wellKnown = (WellKnownProvider)session.getProvider(WellKnownProvider.class, wellKnownProviderFactoryFound.getId());
        if (wellKnown != null) {
            Object config = wellKnown.getConfig();
            Response.ResponseBuilder responseBuilder = Response.ok((Object)config).type(config instanceof String ? "application/jwt" : "application/json");
            return Cors.builder().allowAllOrigins().auth().add(responseBuilder.cacheControl(CacheControlUtil.noCache()));
        }
        throw new NotFoundException();
    }

    @Path(value="{realm}/authz")
    public Object getAuthorizationService(@PathParam(value="realm") String name) {
        ProfileHelper.requireFeature(Profile.Feature.AUTHORIZATION);
        this.resolveRealmAndUpdateSession(name);
        AuthorizationProvider authorization = (AuthorizationProvider)this.session.getProvider(AuthorizationProvider.class);
        return new AuthorizationService(authorization);
    }

    @Path(value="{realm}/{extension}")
    public Object resolveRealmExtension(@PathParam(value="realm") String realmName, @PathParam(value="extension") String extension) {
        Object resource;
        this.resolveRealmAndUpdateSession(realmName);
        RealmResourceProvider provider = (RealmResourceProvider)this.session.getProvider(RealmResourceProvider.class, extension);
        if (provider != null && (resource = provider.getResource()) != null) {
            return resource;
        }
        throw new NotFoundException();
    }

    private void checkSsl(RealmModel realm) {
        RealmsResource.checkSsl(this.session, realm);
    }

    private static void checkSsl(KeycloakSession session, RealmModel realm) {
        if (!"https".equals(session.getContext().getUri().getBaseUri().getScheme()) && realm.getSslRequired().isRequired(session.getContext().getConnection())) {
            HttpRequest request = session.getContext().getHttpRequest();
            Cors cors = Cors.builder().auth().allowedMethods(new String[]{request.getHttpMethod()}).auth().exposedHeaders(new String[]{"Access-Control-Allow-Methods"});
            throw new CorsErrorResponseException(cors.allowAllOrigins(), "invalid_request", "HTTPS required", Response.Status.FORBIDDEN);
        }
    }
}

