/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.jackson;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import jakarta.inject.Inject;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import org.jboss.resteasy.reactive.common.providers.serialisers.AbstractJsonMessageBodyReader;
import org.jboss.resteasy.reactive.common.util.EmptyInputStream;

public class JacksonBasicMessageBodyReader
extends AbstractJsonMessageBodyReader {
    protected final ObjectReader defaultReader;

    @Inject
    public JacksonBasicMessageBodyReader(ObjectMapper mapper) {
        this.defaultReader = mapper.reader();
    }

    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        return this.doReadFrom(type, genericType, entityStream);
    }

    protected ObjectReader getEffectiveReader() {
        return this.defaultReader;
    }

    private Object doReadFrom(Class<Object> type, Type genericType, InputStream entityStream) throws IOException {
        if (entityStream instanceof EmptyInputStream) {
            return null;
        }
        ObjectReader reader = this.getEffectiveReader();
        return reader.forType(reader.getTypeFactory().constructType(genericType != null ? genericType : type)).readValue(entityStream);
    }
}

