/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devui.spi;

import io.quarkus.builder.item.MultiBuildItem;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.deployment.util.ArtifactInfoUtil;
import io.quarkus.maven.dependency.ArtifactKey;
import java.lang.invoke.MethodHandle;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public abstract class AbstractDevUIBuildItem
extends MultiBuildItem {
    private final Class<?> callerClass;
    private String extensionIdentifier = null;
    private ArtifactKey artifactKey;
    private final boolean isInternal;
    public static final String DEV_UI = "devui";

    public AbstractDevUIBuildItem() {
        this(null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AbstractDevUIBuildItem(String customIdentifier) {
        this.extensionIdentifier = customIdentifier;
        boolean bl = this.isInternal = customIdentifier == null;
        if (customIdentifier == null) {
            StackWalker stackWalker = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE);
            stackWalker.walk(frames -> frames.collect(Collectors.toList()));
            Optional stackFrame = stackWalker.walk(frames -> frames.filter(frame -> !frame.getDeclaringClass().getPackageName().startsWith("io.quarkus.devui.spi") && !frame.getDeclaringClass().getPackageName().startsWith("io.quarkus.devui.deployment") && !frame.getDeclaringClass().equals(MethodHandle.class)).findFirst());
            if (!stackFrame.isPresent()) throw new RuntimeException("Could not detect extension identifier automatically");
            this.callerClass = ((StackWalker.StackFrame)stackFrame.get()).getDeclaringClass();
            if (this.callerClass != null) return;
            this.extensionIdentifier = DEV_UI;
            return;
        } else {
            this.callerClass = null;
        }
    }

    public ArtifactKey getArtifactKey(CurateOutcomeBuildItem curateOutcomeBuildItem) {
        if (this.artifactKey == null && this.callerClass != null) {
            Map.Entry groupIdAndArtifactId = ArtifactInfoUtil.groupIdAndArtifactId(this.callerClass, (CurateOutcomeBuildItem)curateOutcomeBuildItem);
            this.artifactKey = ArtifactKey.ga((String)((String)groupIdAndArtifactId.getKey()), (String)((String)groupIdAndArtifactId.getValue()));
        }
        return this.artifactKey;
    }

    public String getExtensionPathName(CurateOutcomeBuildItem curateOutcomeBuildItem) {
        if (this.extensionIdentifier == null) {
            ArtifactKey ak = this.getArtifactKey(curateOutcomeBuildItem);
            this.extensionIdentifier = ak.getArtifactId();
        }
        return this.extensionIdentifier;
    }

    public boolean isInternal() {
        return this.isInternal;
    }
}

