/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.model.ast.builder;

import org.hibernate.engine.jdbc.mutation.ParameterUsage;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.sql.model.MutationOperation;
import org.hibernate.sql.model.MutationTarget;
import org.hibernate.sql.model.MutationType;
import org.hibernate.sql.model.TableMapping;
import org.hibernate.sql.model.ast.ColumnValueBinding;
import org.hibernate.sql.model.ast.ColumnValueBindingList;
import org.hibernate.sql.model.ast.MutatingTableReference;
import org.hibernate.sql.model.ast.RestrictedTableMutation;
import org.hibernate.sql.model.ast.builder.AbstractTableMutationBuilder;
import org.hibernate.sql.model.ast.builder.RestrictedTableMutationBuilder;

public abstract class AbstractRestrictedTableMutationBuilder<O extends MutationOperation, M extends RestrictedTableMutation<O>>
extends AbstractTableMutationBuilder<M>
implements RestrictedTableMutationBuilder<O, M> {
    private final ColumnValueBindingList keyRestrictionBindings = new ColumnValueBindingList(this.getMutatingTable(), this.getParameters(), ParameterUsage.RESTRICT);
    private final ColumnValueBindingList optimisticLockBindings = new ColumnValueBindingList(this.getMutatingTable(), this.getParameters(), ParameterUsage.RESTRICT);

    public AbstractRestrictedTableMutationBuilder(MutationType mutationType, MutationTarget<?> mutationTarget, TableMapping table, SessionFactoryImplementor sessionFactory) {
        super(mutationType, mutationTarget, table, sessionFactory);
    }

    public AbstractRestrictedTableMutationBuilder(MutationType mutationType, MutationTarget<?> mutationTarget, MutatingTableReference tableReference, SessionFactoryImplementor sessionFactory) {
        super(mutationType, mutationTarget, tableReference, sessionFactory);
    }

    @Override
    public ColumnValueBindingList getKeyRestrictionBindings() {
        return this.keyRestrictionBindings;
    }

    @Override
    public ColumnValueBindingList getOptimisticLockBindings() {
        return this.optimisticLockBindings;
    }

    @Override
    public void addNonKeyRestriction(ColumnValueBinding valueBinding) {
        this.optimisticLockBindings.addRestriction(valueBinding);
    }

    @Override
    public void addKeyRestrictionBinding(SelectableMapping selectableMapping) {
        this.keyRestrictionBindings.addRestriction(selectableMapping);
    }

    @Override
    public void addNullOptimisticLockRestriction(SelectableMapping column) {
        this.optimisticLockBindings.addNullRestriction(column);
    }

    @Override
    public void addOptimisticLockRestriction(SelectableMapping selectableMapping) {
        this.optimisticLockBindings.addRestriction(selectableMapping);
    }

    @Override
    public void setWhere(String fragment) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addWhereFragment(String fragment) {
        throw new UnsupportedOperationException();
    }
}

