/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.ext4;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.StructConverter;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class Ext4DxEntry
implements StructConverter {
    private int hash;
    private int block;

    public Ext4DxEntry(ByteProvider provider) throws IOException {
        this(new BinaryReader(provider, true));
    }

    public Ext4DxEntry(BinaryReader reader) throws IOException {
        this.hash = reader.readNextInt();
        this.block = reader.readNextInt();
    }

    public int getHash() {
        return this.hash;
    }

    public int getBlock() {
        return this.block;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType structure = new StructureDataType("dx_entry", 0);
        structure.add(DWORD, "hash", null);
        structure.add(DWORD, "block", null);
        return structure;
    }
}

