/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.table.field;

import ghidra.docking.settings.Settings;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.lang.PrototypeModel;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.util.FunctionCallingConventionFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.util.table.field.ProgramLocationTableColumnExtensionPoint;

public class FunctionCallingConventionTableColumn
extends ProgramLocationTableColumnExtensionPoint<Function, String> {
    public String getColumnDescription() {
        return "Function calling convention for the containing function";
    }

    public String getColumnDisplayName(Settings settings) {
        return "Call Conv";
    }

    public String getColumnName() {
        return "Function Calling Convention";
    }

    public String getValue(Function rowObject, Settings settings, Program program, ServiceProvider serviceProvider) throws IllegalArgumentException {
        if (rowObject == null) {
            return null;
        }
        PrototypeModel callingConvention = rowObject.getCallingConvention();
        if (callingConvention == null) {
            return "unknown";
        }
        return callingConvention.getName();
    }

    @Override
    public ProgramLocation getProgramLocation(Function rowObject, Settings settings, Program program, ServiceProvider serviceProvider) {
        if (rowObject == null) {
            return null;
        }
        Address address = rowObject.getEntryPoint();
        String signature = rowObject.getSignature().getPrototypeString();
        return new FunctionCallingConventionFieldLocation(program, address, address, 0, signature);
    }
}

