/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.html;

import ghidra.app.util.ToolTipUtils;
import ghidra.app.util.html.HTMLDataTypeRepresentation;
import ghidra.app.util.html.TextLine;
import ghidra.app.util.html.ValidatableLine;
import ghidra.app.util.html.diff.DataTypeDiff;
import ghidra.app.util.html.diff.DataTypeDiffBuilder;
import ghidra.program.model.data.Array;
import ghidra.program.model.data.BuiltInDataType;
import ghidra.program.model.data.DataType;
import ghidra.util.HTMLUtilities;
import ghidra.util.StringUtilities;
import java.awt.Color;
import org.apache.commons.lang3.StringUtils;

public class ArrayDataTypeHTMLRepresentation
extends HTMLDataTypeRepresentation {
    private ValidatableLine headerContent;
    private String bodyHtml;
    private ValidatableLine footerContent;
    private Array array;
    private String truncatedHtmlData;

    public ArrayDataTypeHTMLRepresentation(Array array) {
        this.array = array;
        this.headerContent = this.buildHeaderContent();
        this.bodyHtml = this.buildBodyHTML(false);
        this.footerContent = this.buildFooterContent();
        this.originalHTMLData = this.buildHTMLText(this.headerContent, this.bodyHtml, this.footerContent, false);
        String trimmedBodyHtml = this.buildBodyHTML(true);
        this.truncatedHtmlData = this.buildHTMLText(this.headerContent, trimmedBodyHtml, this.footerContent, true);
    }

    private ArrayDataTypeHTMLRepresentation(Array array, ValidatableLine headerContent, String bodyHtml, ValidatableLine footerContent) {
        this.array = array;
        this.headerContent = headerContent;
        this.bodyHtml = bodyHtml;
        this.footerContent = footerContent;
        this.originalHTMLData = this.buildHTMLText(headerContent, bodyHtml, footerContent, false);
        String trimmedBodyHtml = this.buildBodyHTML(true);
        this.truncatedHtmlData = this.buildHTMLText(headerContent, trimmedBodyHtml, footerContent, true);
    }

    private DataType getBaseDataType() {
        Array baseDataType = this.array;
        while (baseDataType instanceof Array) {
            Array baseArray = baseDataType;
            baseDataType = baseArray.getDataType();
        }
        return baseDataType;
    }

    private String buildBodyHTML(boolean trim) {
        StringBuilder buffy = new StringBuilder();
        DataType baseDataType = this.getBaseDataType();
        if (baseDataType instanceof BuiltInDataType) {
            String simpleName = baseDataType.getDisplayName();
            buffy.append("<TT>").append(simpleName).append("</TT>");
            buffy.append("<BR>").append("<DIV STYLE='margin-left: 10px;'>");
            String description = baseDataType.getDescription();
            if (!StringUtils.isBlank((CharSequence)description)) {
                String encodedDescription = HTMLUtilities.friendlyEncodeHTML((String)description);
                buffy.append(encodedDescription).append("<BR>");
            }
            ArrayDataTypeHTMLRepresentation.addDataTypeLengthAndAlignment(baseDataType, buffy);
            buffy.append("</DIV>");
        } else {
            HTMLDataTypeRepresentation representation = ToolTipUtils.getHTMLRepresentation(baseDataType);
            String baseHTML = representation.getFullHTMLContentString();
            if (trim) {
                baseHTML = representation.getHTMLContentString();
            }
            buffy.append(baseHTML);
            if (baseHTML.indexOf("Length: ") < 0) {
                ArrayDataTypeHTMLRepresentation.addDataTypeLengthAndAlignment(baseDataType, buffy);
            }
        }
        return buffy.toString();
    }

    private ValidatableLine buildHeaderContent() {
        StringBuilder buffy = new StringBuilder();
        buffy.append(HTMLUtilities.friendlyEncodeHTML((String)this.array.getName()));
        return new TextLine(buffy.toString());
    }

    private ValidatableLine buildFooterContent() {
        int len = this.array.getLength();
        if (this.array.isZeroLength()) {
            return new TextLine("Length: 0 (reported length is " + len + ")");
        }
        return new TextLine("Length: " + len);
    }

    private String buildHTMLText(ValidatableLine header, String body, ValidatableLine info, boolean trim) {
        StringBuilder buffy = new StringBuilder();
        TextLine headerLine = (TextLine)header;
        String headerText = header.getText();
        if (trim) {
            headerText = StringUtilities.trimMiddle((String)headerText, (int)80);
        }
        headerText = ArrayDataTypeHTMLRepresentation.wrapStringInColor(headerText, headerLine.getTextColor());
        buffy.append(headerText);
        buffy.append("<DIV STYLE='margin-left: 10px;'>");
        TextLine infoLine = (TextLine)info;
        String infoText = info.getText();
        infoText = ArrayDataTypeHTMLRepresentation.wrapStringInColor(infoText, infoLine.getTextColor());
        buffy.append(infoText);
        buffy.append("<BR>").append("<BR>").append("</DIV>");
        buffy.append(body);
        return buffy.toString();
    }

    @Override
    public String getHTMLString() {
        return "<html>" + this.truncatedHtmlData + "</html>";
    }

    @Override
    public String getHTMLContentString() {
        return this.truncatedHtmlData;
    }

    @Override
    public HTMLDataTypeRepresentation[] diff(HTMLDataTypeRepresentation otherRepresentation) {
        if (this == otherRepresentation) {
            return new HTMLDataTypeRepresentation[]{this, this};
        }
        if (!(otherRepresentation instanceof ArrayDataTypeHTMLRepresentation)) {
            return this.completelyDifferentDiff(otherRepresentation);
        }
        ArrayDataTypeHTMLRepresentation other = (ArrayDataTypeHTMLRepresentation)otherRepresentation;
        ValidatableLine header = this.headerContent.copy();
        ValidatableLine footer = this.footerContent.copy();
        String body = this.bodyHtml;
        String otherBody = other.bodyHtml;
        Array otherArray = other.array;
        if (!this.array.isEquivalent((DataType)otherArray)) {
            body = ArrayDataTypeHTMLRepresentation.wrapStringInColorUsingDiv(body, DIFF_COLOR);
            otherBody = ArrayDataTypeHTMLRepresentation.wrapStringInColorUsingDiv(otherBody, DIFF_COLOR);
        }
        ValidatableLine otherHeader = other.headerContent.copy();
        ValidatableLine otherFooter = other.footerContent.copy();
        DataTypeDiff headerDiff = DataTypeDiffBuilder.diffHeader(this.getDiffInput(header), this.getDiffInput(otherHeader));
        DataTypeDiff footerDiff = DataTypeDiffBuilder.diffLines(this.getDiffInput(footer), this.getDiffInput(otherFooter));
        return new HTMLDataTypeRepresentation[]{new ArrayDataTypeHTMLRepresentation(this.array, (ValidatableLine)headerDiff.getLeftLines().get(0), body, (ValidatableLine)footerDiff.getLeftLines().get(0)), new ArrayDataTypeHTMLRepresentation(other.array, (ValidatableLine)headerDiff.getRightLines().get(0), otherBody, (ValidatableLine)footerDiff.getRightLines().get(0))};
    }

    protected static String wrapStringInColorUsingDiv(String string, Color color) {
        if (color == null) {
            return string;
        }
        String rgb = HTMLUtilities.toHexString((Color)color);
        return "<DIV STYLE='color: " + rgb + ";'>" + string + "</DIV>";
    }
}

