/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.actions;

import docking.ActionContext;
import docking.KeyBindingPrecedence;
import docking.action.DockingAction;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeNode;
import docking.widgets.tree.support.GTreeDragNDropHandler;
import docking.widgets.tree.support.GTreeNodeTransferable;
import docking.widgets.tree.support.GTreeTransferHandler;
import ghidra.app.plugin.core.datamgr.DataTypeManagerPlugin;
import ghidra.app.plugin.core.datamgr.DataTypesActionContext;
import ghidra.app.plugin.core.datamgr.tree.ArchiveNode;
import ghidra.app.plugin.core.datamgr.tree.ArchiveRootNode;
import ghidra.app.plugin.core.datamgr.tree.CategoryNode;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.KeyStroke;
import javax.swing.tree.TreePath;

public class CopyAction
extends DockingAction {
    private Clipboard clipboard;

    public CopyAction(DataTypeManagerPlugin plugin) {
        super("Copy", plugin.getName());
        this.clipboard = plugin.getClipboard();
        String group = "Edit";
        this.setPopupMenuData(new MenuData(new String[]{"Copy"}, group));
        this.setKeyBindingData(new KeyBindingData(KeyStroke.getKeyStroke(67, 128), KeyBindingPrecedence.ActionMapLevel));
        this.setEnabled(true);
    }

    public boolean isEnabledForContext(ActionContext context) {
        if (!(context instanceof DataTypesActionContext)) {
            return false;
        }
        GTree gtree = (GTree)context.getContextObject();
        TreePath[] selectionPaths = gtree.getSelectionPaths();
        if (selectionPaths == null || selectionPaths.length == 0) {
            return false;
        }
        return !this.containsInvalidNodes(selectionPaths);
    }

    private boolean containsInvalidNodes(TreePath[] selectionPaths) {
        for (TreePath path : selectionPaths) {
            GTreeNode node = (GTreeNode)path.getLastPathComponent();
            if (node instanceof ArchiveRootNode) {
                return true;
            }
            if (node instanceof ArchiveNode) {
                return true;
            }
            if (!(node instanceof CategoryNode)) continue;
            CategoryNode categoryNode = (CategoryNode)node;
            return !categoryNode.isEnabled();
        }
        return false;
    }

    public void actionPerformed(ActionContext context) {
        GTree gTree = (GTree)context.getContextObject();
        TreePath[] paths = gTree.getSelectionPaths();
        ArrayList<GTreeNode> nodeList = this.createList(paths);
        this.setClipboardContents(gTree, this.clipboard, nodeList);
    }

    private ArrayList<GTreeNode> createList(TreePath[] paths) {
        ArrayList<GTreeNode> list = new ArrayList<GTreeNode>();
        if (paths != null) {
            for (TreePath element : paths) {
                GTreeNode node = (GTreeNode)element.getLastPathComponent();
                list.add(node);
            }
        }
        return list;
    }

    private void setClipboardContents(GTree gTree, Clipboard clipboard, List<GTreeNode> list) {
        GTreeDragNDropHandler dragNDropHandler = gTree.getDragNDropHandler();
        GTreeNodeTransferable contents = new GTreeNodeTransferable((GTreeTransferHandler)dragNDropHandler, list);
        clipboard.setContents((Transferable)contents, new ClipboardOwner(this){

            @Override
            public void lostOwnership(Clipboard currentClipboard, Transferable transferable) {
            }
        });
    }
}

