/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.tree.support;

import docking.widgets.tree.GTreeNode;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;

public class BreadthFirstIterator
implements Iterator<GTreeNode> {
    private Queue<GTreeNode> nodeQueue = new LinkedList<GTreeNode>();
    private GTreeNode lastNode;

    public BreadthFirstIterator(GTreeNode node) {
        this.nodeQueue.add(node);
    }

    @Override
    public boolean hasNext() {
        return !this.nodeQueue.isEmpty();
    }

    @Override
    public GTreeNode next() {
        this.lastNode = this.nodeQueue.poll();
        if (this.lastNode != null && this.lastNode.isAutoExpandPermitted()) {
            List<GTreeNode> children = this.lastNode.getChildren();
            this.nodeQueue.addAll(children);
        }
        return this.lastNode;
    }

    @Override
    public void remove() {
        GTreeNode parent = this.lastNode.getParent();
        if (parent == null) {
            throw new IllegalArgumentException("Can't delete root node!");
        }
        parent.removeNode(this.lastNode);
        this.nodeQueue.removeAll(this.lastNode.getChildren());
    }
}

