/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.layout.algorithms.eiglsperger;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jgrapht.Graph;
import org.jungrapht.visualization.layout.algorithms.eiglsperger.HorizontalCompactionDeprecated;
import org.jungrapht.visualization.layout.algorithms.eiglsperger.HorizontalCoordinateAssignment;
import org.jungrapht.visualization.layout.algorithms.eiglsperger.VerticalAlignmentDeprecated;
import org.jungrapht.visualization.layout.algorithms.sugiyama.AverageMedian;
import org.jungrapht.visualization.layout.algorithms.sugiyama.LE;
import org.jungrapht.visualization.layout.algorithms.sugiyama.LV;
import org.jungrapht.visualization.layout.model.Point;

public class SelectiveEiglspergerHorizontalCoordinateAssignment<V, E>
extends HorizontalCoordinateAssignment<V, E> {
    boolean doUpLeft;
    boolean doDownLeft;
    boolean doUpRight;
    boolean doDownRight;

    public SelectiveEiglspergerHorizontalCoordinateAssignment(LV<V>[][] layers, Graph<LV<V>, LE<V, E>> svGraph, Graph<LV<V>, Integer> compactionGraph, Set<LE<V, E>> markedSegments, int horizontalOffset, int verticalOffset, boolean doUpLeft, boolean doUpRight, boolean doDownLeft, boolean doDownRight) {
        super(layers, svGraph, compactionGraph, markedSegments, horizontalOffset, verticalOffset);
        this.doUpLeft = doUpLeft;
        this.doDownLeft = doDownLeft;
        this.doUpRight = doUpRight;
        this.doDownRight = doDownRight;
    }

    @Override
    public void horizontalCoordinateAssignment() {
        HorizontalCompactionDeprecated upLeftCompaction = null;
        HorizontalCompactionDeprecated upRightCompaction = null;
        HorizontalCompactionDeprecated downLeftCompaction = null;
        HorizontalCompactionDeprecated downRightCompaction = null;
        if (this.doUpLeft) {
            VerticalAlignmentDeprecated.LeftmostUpper upLeft = new VerticalAlignmentDeprecated.LeftmostUpper(this.layers, this.svGraph, this.markedSegments);
            upLeft.align();
            upLeftCompaction = new HorizontalCompactionDeprecated(this.layers, upLeft.getRootMap(), upLeft.getAlignMap(), this.horizontalOffset, this.verticalOffset);
            upLeftCompaction.horizontalCompaction();
        }
        if (this.doUpRight) {
            VerticalAlignmentDeprecated.RightmostUpper upRight = new VerticalAlignmentDeprecated.RightmostUpper(this.layers, this.svGraph, this.markedSegments);
            upRight.align();
            upRightCompaction = new HorizontalCompactionDeprecated(this.layers, upRight.getRootMap(), upRight.getAlignMap(), this.horizontalOffset, this.verticalOffset);
            upRightCompaction.horizontalCompaction();
        }
        if (this.doDownLeft) {
            VerticalAlignmentDeprecated.LeftmostLower downLeft = new VerticalAlignmentDeprecated.LeftmostLower(this.layers, this.svGraph, this.markedSegments);
            downLeft.align();
            downLeftCompaction = new HorizontalCompactionDeprecated(this.layers, downLeft.getRootMap(), downLeft.getAlignMap(), this.horizontalOffset, this.verticalOffset);
            downLeftCompaction.horizontalCompaction();
        }
        if (this.doDownRight) {
            VerticalAlignmentDeprecated.RightmostLower downRight = new VerticalAlignmentDeprecated.RightmostLower(this.layers, this.svGraph, this.markedSegments);
            downRight.align();
            downRightCompaction = new HorizontalCompactionDeprecated(this.layers, downRight.getRootMap(), downRight.getAlignMap(), this.horizontalOffset, this.verticalOffset);
            downRightCompaction.horizontalCompaction();
        }
        for (int i = 0; i < this.layers.length; ++i) {
            for (int j = 0; j < this.layers[i].length; ++j) {
                LV v = this.layers[i][j];
                ArrayList<Point> points = new ArrayList<Point>();
                if (this.doUpLeft) {
                    points.add(upLeftCompaction.getPoint(v).add(this.horizontalOffset, this.verticalOffset));
                }
                if (this.doUpRight) {
                    points.add(upRightCompaction.getPoint(v).add(this.horizontalOffset, this.verticalOffset));
                }
                if (this.doDownLeft) {
                    points.add(downLeftCompaction.getPoint(v).add(this.horizontalOffset, this.verticalOffset));
                }
                if (this.doDownRight) {
                    points.add(downRightCompaction.getPoint(v).add(this.horizontalOffset, this.verticalOffset));
                }
                Point balancedPoint = AverageMedian.averageMedianPoint(points.toArray(new Point[0]));
                v.setPoint(balancedPoint);
            }
        }
    }

    static <V, E> List<LV<V>> getUpperNeighbors(Graph<LV<V>, LE<V, E>> graph, LV<V> v) {
        return graph.incomingEdgesOf(v).stream().map(arg_0 -> graph.getEdgeSource(arg_0)).collect(Collectors.toList());
    }
}

