/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.task.gui;

import docking.util.AnimatedIcon;
import docking.widgets.EmptyBorderButton;
import docking.widgets.label.GDHtmlLabel;
import docking.widgets.label.GIconLabel;
import generic.theme.Gui;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import ghidra.util.layout.VerticalLayout;
import ghidra.util.task.CancelledListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.lang.reflect.InvocationTargetException;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import resources.Icons;
import resources.ResourceManager;

public class GProgressBar
extends JPanel {
    private static final NumberFormat PERCENT_FORMAT = NumberFormat.getPercentInstance();
    private static final String MESSAGE_FONT_ID = "font.task.progress.label.message";
    private volatile long lastProgress = -1L;
    private volatile long progress;
    private volatile long scaleFactor = 1L;
    private volatile long lastMax = -1L;
    private volatile long max;
    private volatile String lastMessage = null;
    private volatile String message;
    private volatile boolean paintProgressValue = true;
    private boolean showingIcon = true;
    private JProgressBar progressBar;
    private JLabel messageLabel;
    private JLabel imageLabel;
    private JPanel progressPanel;
    private JPanel activeProgressPanel;
    private JPanel eastButtonPanel;
    private Timer updateTimer;
    private EmptyBorderButton cancelButton;
    private CancelledListener cancelledListener;

    public GProgressBar(CancelledListener cancelledListener, boolean includeTextField, boolean includeCancelButton, boolean includeAnimatedIcon) {
        super(new BorderLayout(5, 1));
        this.cancelledListener = cancelledListener;
        this.buildProgressPanel(includeTextField, includeCancelButton, includeAnimatedIcon);
        this.updateTimer = new Timer(250, e -> this.update());
        this.updateTimer.setRepeats(false);
    }

    public void setBackgroundColor(Color bg) {
        this.setBackground(bg);
        this.progressPanel.setBackground(bg);
        this.messageLabel.setBackground(bg);
        this.activeProgressPanel.setBackground(bg);
        if (this.eastButtonPanel != null) {
            this.eastButtonPanel.setBackground(bg);
        }
    }

    public void initialize(long maximum) {
        this.progress = 0L;
        this.max = maximum;
        this.message = null;
        this.update();
    }

    public void setProgress(long progress) {
        if (progress == this.progress) {
            return;
        }
        this.progress = progress;
        if (progress > this.max) {
            progress = this.max;
        }
        this.startUpdateTimer();
    }

    public void setMaximum(long max) {
        if (this.max == max) {
            return;
        }
        this.max = max;
        if (this.progress > this.max) {
            this.progress = max;
        }
        this.startUpdateTimer();
    }

    public void incrementProgress(long incrementAmount) {
        this.setProgress(this.progress + incrementAmount);
    }

    public long getProgress() {
        return this.progress;
    }

    public long getMax() {
        return this.max;
    }

    public synchronized void setMessage(String message) {
        if (message == this.message) {
            return;
        }
        this.message = message;
        this.startUpdateTimer();
    }

    public String getMessage() {
        return this.message;
    }

    public void setIndeterminate(boolean indeterminate) {
        SystemUtilities.runSwingNow(() -> {
            this.progressBar.setIndeterminate(indeterminate);
            this.progressBar.setStringPainted(!indeterminate);
        });
    }

    public void showProgressIcon(boolean showIcon) {
        if (showIcon == this.showingIcon) {
            return;
        }
        Runnable r = () -> {
            if (showIcon) {
                this.activeProgressPanel.add((Component)this.imageLabel, "East");
            } else {
                this.activeProgressPanel.remove(this.imageLabel);
            }
            this.showingIcon = showIcon;
        };
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(r);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException e) {
                Msg.showError((Object)this, null, (String)"Error in Progress icon", (Object)"error", (Throwable)e);
            }
        }
    }

    public void setShowProgressValue(boolean showProgressValue) {
        this.paintProgressValue = showProgressValue;
        this.startUpdateTimer();
    }

    public void cancel() {
        if (this.cancelledListener != null) {
            this.cancelledListener.cancelled();
        }
    }

    public void setCancelledListener(CancelledListener listener) {
        this.cancelledListener = listener;
    }

    private void buildProgressPanel(boolean includeTextField, boolean includeCancelButton, boolean includeAnimatedIcon) {
        this.messageLabel = new GDHtmlLabel("               "){

            public void invalidate() {
            }
        };
        Gui.registerFont((Component)this.messageLabel, (String)MESSAGE_FONT_ID);
        Dimension d = this.messageLabel.getPreferredSize();
        d.width = 180;
        this.messageLabel.setPreferredSize(d);
        this.progressBar = new JProgressBar(){

            @Override
            public String getToolTipText() {
                if (this.isStringPainted()) {
                    return this.getString();
                }
                return GProgressBar.this.createProgressString();
            }
        };
        this.progressBar.setStringPainted(true);
        this.progressBar.setValue(59);
        ToolTipManager.sharedInstance().registerComponent(this.progressBar);
        this.progressPanel = new JPanel((LayoutManager)new VerticalLayout(0));
        this.progressPanel.add(this.progressBar);
        if (includeTextField) {
            this.progressPanel.add(this.messageLabel);
            this.progressBar.setPreferredSize(new Dimension(180, 12));
        } else {
            this.progressBar.setBorderPainted(true);
            Dimension size = this.progressBar.getPreferredSize();
            this.progressPanel.setBorder(BorderFactory.createEmptyBorder((this.imageLabel.getPreferredSize().height - size.height) / 2, 0, 0, 8));
        }
        this.activeProgressPanel = new JPanel(new BorderLayout());
        this.activeProgressPanel.add((Component)this.progressPanel, "Center");
        if (includeAnimatedIcon) {
            this.createAnimatedIcon();
            this.activeProgressPanel.add((Component)this.imageLabel, "East");
        }
        Icon icon = Icons.STOP_ICON;
        this.cancelButton = new EmptyBorderButton(icon);
        this.cancelButton.setName("CANCEL_TASK");
        this.cancelButton.setPreferredSize(new Dimension(icon.getIconWidth(), icon.getIconHeight()));
        this.cancelButton.addActionListener(e -> this.cancel());
        this.cancelButton.setFocusable(false);
        this.cancelButton.setRolloverEnabled(true);
        this.add((Component)this.activeProgressPanel, "Center");
        if (includeCancelButton) {
            this.eastButtonPanel = new JPanel();
            this.eastButtonPanel.setLayout(new BoxLayout(this.eastButtonPanel, 1));
            this.eastButtonPanel.add((Component)this.cancelButton);
            this.eastButtonPanel.add(Box.createVerticalGlue());
            this.add((Component)this.eastButtonPanel, "East");
        }
    }

    private synchronized void startUpdateTimer() {
        if (!this.updateTimer.isRunning()) {
            this.updateTimer.start();
        }
    }

    private synchronized void update() {
        if (this.message != this.lastMessage) {
            this.messageLabel.setText(this.message == null ? "" : this.message);
            this.lastMessage = this.message;
        }
        if (this.max != this.lastMax) {
            this.setMaxValueInProgressBar(this.max);
            this.lastMax = this.max;
        }
        if (this.progress != this.lastProgress) {
            this.setValueInProgressBar(this.progress);
            this.lastProgress = this.progress;
        }
    }

    private void setValueInProgressBar(long value) {
        this.progressBar.setValue((int)(value / this.scaleFactor));
        if (this.progressBar.isIndeterminate()) {
            return;
        }
        this.progressBar.setString(this.createProgressString());
    }

    private void setMaxValueInProgressBar(long max) {
        this.scaleFactor = this.computeScaleFactor(max);
        this.progressBar.setMaximum((int)(max / this.scaleFactor));
        if (this.progressBar.isIndeterminate()) {
            return;
        }
        this.progressBar.setString(this.createProgressString());
    }

    private long computeScaleFactor(long value) {
        long scale = 1L;
        while (value > Integer.MAX_VALUE) {
            value /= 10L;
            scale *= 10L;
        }
        return scale;
    }

    private String createProgressString() {
        long currentProgress = this.progress;
        if (currentProgress <= 0L) {
            return "0%";
        }
        long maximum = this.max;
        if (currentProgress >= maximum) {
            return "100%";
        }
        float percent = (float)currentProgress / (float)maximum;
        String formattedPercent = PERCENT_FORMAT.format(percent);
        if (!this.paintProgressValue) {
            return formattedPercent;
        }
        return formattedPercent + " (" + currentProgress + " of " + maximum + ")";
    }

    private void createAnimatedIcon() {
        String[] filenames = new String[]{"images/hourglass24_01.png", "images/hourglass24_02.png", "images/hourglass24_02.png", "images/hourglass24_03.png", "images/hourglass24_03.png", "images/hourglass24_04.png", "images/hourglass24_04.png", "images/hourglass24_05.png", "images/hourglass24_05.png", "images/hourglass24_06.png", "images/hourglass24_06.png", "images/hourglass24_07.png", "images/hourglass24_07.png", "images/hourglass24_08.png", "images/hourglass24_08.png", "images/hourglass24_09.png", "images/hourglass24_10.png", "images/hourglass24_11.png"};
        this.imageLabel = new GIconLabel((Icon)new AnimatedIcon(ResourceManager.loadImages((String[])filenames), 150, 0));
    }
}

