/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis;

import ghidra.app.plugin.core.analysis.ConstantPropagationAnalyzer;
import ghidra.app.plugin.core.analysis.ConstantPropagationContextEvaluator;
import ghidra.app.plugin.core.clear.ClearFlowAndRepairCmd;
import ghidra.app.services.AnalysisPriority;
import ghidra.framework.options.Options;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.Processor;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Program;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.model.symbol.FlowType;
import ghidra.program.model.symbol.Reference;
import ghidra.program.util.ContextEvaluator;
import ghidra.program.util.SymbolicPropogator;
import ghidra.program.util.VarnodeContext;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;

public class SparcAnalyzer
extends ConstantPropagationAnalyzer {
    private static final String PROCESSOR_NAME = "Sparc";
    protected static final String O7_CALLRETURN_NAME = "Call/Return o7 check";
    protected static final String O7_CALLRETURN_DESCRIPTION = "Turn on check for setting of o7 return link register in delay slot of all calls";
    protected static final boolean EO7_CALLRETURN_DEFAULT_VALUE = true;
    protected boolean o7CallReturnAnalysis = true;

    public SparcAnalyzer() {
        super(PROCESSOR_NAME);
        this.setPriority(AnalysisPriority.FUNCTION_ANALYSIS.after());
    }

    public boolean canAnalyze(Program program) {
        Processor processor = program.getLanguage().getProcessor();
        return processor.equals((Object)Processor.findOrPossiblyCreateProcessor((String)PROCESSOR_NAME));
    }

    public AddressSetView flowConstants(Program program, Address flowStart, AddressSetView flowSet, SymbolicPropogator symEval, TaskMonitor monitor) throws CancelledException {
        final Register linkReg = program.getRegister("o7");
        ConstantPropagationContextEvaluator eval = new ConstantPropagationContextEvaluator(monitor, this.trustWriteMemOption){

            public boolean evaluateContext(VarnodeContext context, Instruction instr) {
                FlowType ftype = instr.getFlowType();
                if (SparcAnalyzer.this.o7CallReturnAnalysis && ftype.isCall()) {
                    PcodeOp[] pcode;
                    Address fallAddr = instr.getFallThrough();
                    if (fallAddr == null) {
                        return false;
                    }
                    Instruction delayInstr = instr.getProgram().getListing().getInstructionAfter(instr.getMaxAddress());
                    if (delayInstr == null) {
                        return false;
                    }
                    for (PcodeOp pcodeOp : pcode = delayInstr.getPcode()) {
                        Varnode input;
                        Varnode output = pcodeOp.getOutput();
                        if (output == null || !output.equals((Object)context.getRegisterVarnode(linkReg)) || (input = pcodeOp.getInput(0)).isConstant()) continue;
                        instr.setFallThrough(null);
                        Instruction fallInstr = instr.getProgram().getListing().getInstructionAt(fallAddr);
                        if (fallInstr == null) {
                            return false;
                        }
                        if (fallInstr.getReferenceIteratorTo().hasNext()) {
                            return false;
                        }
                        ClearFlowAndRepairCmd cmd = new ClearFlowAndRepairCmd(fallAddr, false, false, true);
                        cmd.applyTo(instr.getProgram(), this.monitor);
                        break;
                    }
                }
                return false;
            }

            public boolean evaluateDestination(VarnodeContext context, Instruction instruction) {
                FlowType flowType = instruction.getFlowType();
                if (!flowType.isJump()) {
                    return false;
                }
                Reference[] refs = instruction.getReferencesFrom();
                if (refs.length <= 0 || refs.length == 1 && refs[0].getReferenceType().isData()) {
                    this.destSet.addRange(instruction.getMinAddress(), instruction.getMinAddress());
                }
                return false;
            }
        };
        eval.setTrustWritableMemory(this.trustWriteMemOption).setMinSpeculativeOffset(this.minSpeculativeRefAddress).setMaxSpeculativeOffset(this.maxSpeculativeRefAddress).setMinStoreLoadOffset(this.minStoreLoadRefAddress).setCreateComplexDataFromPointers(this.createComplexDataFromPointers);
        AddressSet resultSet = symEval.flowConstants(flowStart, flowSet, (ContextEvaluator)eval, true, monitor);
        return resultSet;
    }

    public void registerOptions(Options options, Program program) {
        super.registerOptions(options, program);
        options.registerOption(O7_CALLRETURN_NAME, (Object)this.o7CallReturnAnalysis, null, O7_CALLRETURN_DESCRIPTION);
    }

    public void optionsChanged(Options options, Program program) {
        super.optionsChanged(options, program);
        this.o7CallReturnAnalysis = options.getBoolean(O7_CALLRETURN_NAME, this.o7CallReturnAnalysis);
    }
}

