/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.utils;

import ghidra.app.services.ProgramManager;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.Project;
import ghidra.framework.model.ProjectData;
import ghidra.framework.protocol.ghidra.GhidraURL;
import ghidra.program.model.listing.Program;
import java.net.URL;

public final class ProgramURLUtils
extends Enum<ProgramURLUtils> {
    private static final /* synthetic */ ProgramURLUtils[] $VALUES;

    public static ProgramURLUtils[] values() {
        return (ProgramURLUtils[])$VALUES.clone();
    }

    public static ProgramURLUtils valueOf(String name) {
        return Enum.valueOf(ProgramURLUtils.class, name);
    }

    public static URL getUrlFromProgram(Program program) {
        DomainFile file = program.getDomainFile();
        URL sharedUrl = file.getSharedProjectURL(null);
        if (sharedUrl != null) {
            return sharedUrl;
        }
        return file.getLocalProjectURL(null);
    }

    public static boolean isProjectDataURL(ProjectData data, URL url) {
        URL projectURL = GhidraURL.getProjectURL((URL)url);
        URL sharedURL = data.getRootFolder().getSharedProjectURL();
        if (sharedURL != null && GhidraURL.getProjectURL((URL)sharedURL).equals(projectURL)) {
            return true;
        }
        URL localURL = data.getRootFolder().getLocalProjectURL();
        return localURL != null && GhidraURL.getProjectURL((URL)localURL).equals(projectURL);
    }

    public static DomainFile getDomainFileFromOpenProject(Project project, URL url) {
        if (ProgramURLUtils.isProjectDataURL(project.getProjectData(), url)) {
            return project.getProjectData().getFile(GhidraURL.getProjectPathname((URL)url));
        }
        for (ProjectData data : project.getViewedProjectData()) {
            if (!ProgramURLUtils.isProjectDataURL(data, url)) continue;
            return data.getFile(GhidraURL.getProjectPathname((URL)url));
        }
        return null;
    }

    public static Program openDomainFileFromOpenProject(ProgramManager programManager, Project project, URL url, int state) {
        DomainFile file = ProgramURLUtils.getDomainFileFromOpenProject(project, url);
        if (file == null) {
            return null;
        }
        return programManager.openProgram(file, -1, state);
    }

    private static /* synthetic */ ProgramURLUtils[] $values() {
        return new ProgramURLUtils[0];
    }

    static {
        $VALUES = ProgramURLUtils.$values();
    }
}

