/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.DelimiterState;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbDebugInfo;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbLog;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractMsType;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;

public class PdbReaderMetrics {
    private static Set<Integer> dataTypesSeen = new HashSet<Integer>();
    private static Set<Integer> knownPrimitives;
    private static Set<Integer> symbolTypesSeen;
    private AbstractPdb pdb;
    private Set<PdbAnomaly> pdbAnomalies = new TreeSet<PdbAnomaly>();
    private int numSegments = -1;
    private Set<Integer> unknownPrimitives = new HashSet<Integer>();
    private Set<Integer> newDataTypes = new HashSet<Integer>();
    private Set<Integer> newSymbolTypes = new HashSet<Integer>();

    public PdbReaderMetrics(AbstractPdb pdb) {
        Objects.requireNonNull(pdb, "pdb cannot be null");
        this.pdb = pdb;
    }

    public void witnessIpiDetection(boolean ipiStreamHasNoName, boolean hasIdStream) {
        if (ipiStreamHasNoName && !hasIdStream) {
            this.pdbAnomalies.add(PdbAnomaly.UNINDICATED_EXISTING_IPI);
        }
    }

    public void witnessedSectionSegmentNumber(int segment) {
        PdbDebugInfo debugInfo = this.pdb.getDebugInfo();
        if (debugInfo == null) {
            return;
        }
        if (this.numSegments == -1) {
            this.numSegments = debugInfo.getSegmentMapList().size();
        }
        if (segment < 0 || segment > this.numSegments) {
            PdbLog.message("segment " + segment + " out of range [0," + this.numSegments + ")");
        } else if (segment == this.numSegments) {
            this.pdbAnomalies.add(PdbAnomaly.MAX_SEGMENT_AS_BASE);
        }
    }

    public void witnessRecordNumber(RecordNumber recordNumber) {
        switch (recordNumber.getCategory()) {
            case TYPE: {
                if (recordNumber.getNumber() >= 0) break;
                this.witnessDataRecordNumberHighBitSet();
                recordNumber = this.pdb.fixupTypeIndex(recordNumber, AbstractMsType.class);
                break;
            }
            case ITEM: {
                if (recordNumber.getNumber() >= 0) break;
                this.witnessItemRecordNumberHighBitSet();
                recordNumber = this.pdb.fixupTypeIndex(recordNumber, AbstractMsType.class);
                break;
            }
        }
        switch (recordNumber.getCategory()) {
            case TYPE: {
                if (recordNumber.getNumber() >= this.pdb.getTypeProgramInterface().getTypeIndexMin()) break;
                this.witnessPrimitive(recordNumber.getNumber());
                break;
            }
            case ITEM: {
                if (recordNumber.getNumber() >= this.pdb.getItemProgramInterface().getTypeIndexMin()) break;
                break;
            }
        }
    }

    private void witnessDataRecordNumberHighBitSet() {
        this.pdbAnomalies.add(PdbAnomaly.DATA_RECORD_NUMBER_HIGH_BIT);
    }

    private void witnessItemRecordNumberHighBitSet() {
        this.pdbAnomalies.add(PdbAnomaly.ITEM_RECORD_NUMBER_HIGH_BIT);
    }

    public void witnessDataTypeId(int dataTypeId) {
        if (!dataTypesSeen.contains(dataTypeId)) {
            this.newDataTypes.add(dataTypeId);
        }
    }

    public void witnessSymbolTypeId(int symbolTypeId) {
        if (!symbolTypesSeen.contains(symbolTypeId)) {
            this.newSymbolTypes.add(symbolTypeId);
        }
    }

    public void witnessPrimitive(int recNum) {
        if (!knownPrimitives.contains(recNum)) {
            this.unknownPrimitives.add(recNum);
        }
    }

    public String getPostProcessingReport() {
        String symbolTypesReport;
        String dataTypesReport;
        String unknownPrimitivesReport;
        StringBuilder builder = new StringBuilder();
        builder.append("===Begin PdbReaderMetrics Report===\n");
        String anomaliesReport = this.reportAnomalies();
        if (!anomaliesReport.isEmpty()) {
            builder.append(anomaliesReport);
            builder.append("\n");
        }
        if (!(unknownPrimitivesReport = this.getUnknownPrimitivesLog()).isEmpty()) {
            builder.append(unknownPrimitivesReport);
            builder.append("\n");
        }
        if (!(dataTypesReport = this.getNewDataTypesLog()).isEmpty()) {
            builder.append(dataTypesReport);
            builder.append("\n");
        }
        if (!(symbolTypesReport = this.getNewSymbolTypesLog()).isEmpty()) {
            builder.append(symbolTypesReport);
            builder.append("\n");
        }
        builder.append("====End PdbReaderMetrics Report====\n");
        return builder.toString();
    }

    private String getUnknownPrimitivesLog() {
        StringBuilder builder = new StringBuilder();
        DelimiterState ds = new DelimiterState("Unknown Primitive Record Numbers Seen: ", ",");
        TreeSet<Integer> sortedSet = new TreeSet<Integer>(this.unknownPrimitives);
        for (Integer val : sortedSet) {
            builder.append(ds.out(true, String.format("0X%04X", val)));
        }
        return builder.toString();
    }

    private String getNewDataTypesLog() {
        StringBuilder builder = new StringBuilder();
        DelimiterState ds = new DelimiterState("New Type/Item IDs Seen: ", ",");
        TreeSet<Integer> sortedSet = new TreeSet<Integer>(this.newDataTypes);
        for (Integer val : sortedSet) {
            builder.append(ds.out(true, String.format("0X%04X", val)));
        }
        return builder.toString();
    }

    private String getNewSymbolTypesLog() {
        StringBuilder builder = new StringBuilder();
        DelimiterState ds = new DelimiterState("New Symbol IDs Seen: ", ",");
        TreeSet<Integer> sortedSet = new TreeSet<Integer>(this.newSymbolTypes);
        for (Integer val : sortedSet) {
            builder.append(ds.out(true, String.format("0X%04X", val)));
        }
        return builder.toString();
    }

    private String reportAnomalies() {
        StringBuilder builder = new StringBuilder();
        if (this.pdbAnomalies.size() > 0) {
            builder.append("PDB Anomalies: ");
            builder.append(this.pdbAnomalies);
            builder.append("\n");
        }
        return builder.toString();
    }

    static {
        dataTypesSeen.add(1);
        dataTypesSeen.add(2);
        dataTypesSeen.add(3);
        dataTypesSeen.add(4);
        dataTypesSeen.add(5);
        dataTypesSeen.add(6);
        dataTypesSeen.add(7);
        dataTypesSeen.add(8);
        dataTypesSeen.add(9);
        dataTypesSeen.add(10);
        dataTypesSeen.add(14);
        dataTypesSeen.add(513);
        dataTypesSeen.add(516);
        dataTypesSeen.add(518);
        dataTypesSeen.add(519);
        dataTypesSeen.add(1024);
        dataTypesSeen.add(1027);
        dataTypesSeen.add(1030);
        dataTypesSeen.add(1031);
        dataTypesSeen.add(1032);
        dataTypesSeen.add(1033);
        dataTypesSeen.add(1034);
        dataTypesSeen.add(1036);
        dataTypesSeen.add(4097);
        dataTypesSeen.add(4098);
        dataTypesSeen.add(4099);
        dataTypesSeen.add(4100);
        dataTypesSeen.add(4101);
        dataTypesSeen.add(4102);
        dataTypesSeen.add(4103);
        dataTypesSeen.add(4104);
        dataTypesSeen.add(4105);
        dataTypesSeen.add(4609);
        dataTypesSeen.add(4611);
        dataTypesSeen.add(4613);
        dataTypesSeen.add(4614);
        dataTypesSeen.add(5120);
        dataTypesSeen.add(5121);
        dataTypesSeen.add(5122);
        dataTypesSeen.add(5124);
        dataTypesSeen.add(5125);
        dataTypesSeen.add(5126);
        dataTypesSeen.add(5127);
        dataTypesSeen.add(5128);
        dataTypesSeen.add(5129);
        dataTypesSeen.add(5131);
        dataTypesSeen.add(5378);
        dataTypesSeen.add(5379);
        dataTypesSeen.add(5380);
        dataTypesSeen.add(5381);
        dataTypesSeen.add(5382);
        dataTypesSeen.add(5383);
        dataTypesSeen.add(5389);
        dataTypesSeen.add(5390);
        dataTypesSeen.add(5391);
        dataTypesSeen.add(5392);
        dataTypesSeen.add(5393);
        dataTypesSeen.add(5405);
        dataTypesSeen.add(5633);
        dataTypesSeen.add(5634);
        dataTypesSeen.add(5635);
        dataTypesSeen.add(5636);
        dataTypesSeen.add(5637);
        dataTypesSeen.add(5638);
        dataTypesSeen.add(5639);
        knownPrimitives = new HashSet<Integer>();
        knownPrimitives.add(0);
        knownPrimitives.add(1);
        knownPrimitives.add(2);
        knownPrimitives.add(3);
        knownPrimitives.add(259);
        knownPrimitives.add(515);
        knownPrimitives.add(771);
        knownPrimitives.add(1027);
        knownPrimitives.add(1283);
        knownPrimitives.add(1539);
        knownPrimitives.add(1795);
        knownPrimitives.add(4);
        knownPrimitives.add(5);
        knownPrimitives.add(6);
        knownPrimitives.add(7);
        knownPrimitives.add(8);
        knownPrimitives.add(1032);
        knownPrimitives.add(1544);
        knownPrimitives.add(1800);
        knownPrimitives.add(96);
        knownPrimitives.add(97);
        knownPrimitives.add(98);
        knownPrimitives.add(16);
        knownPrimitives.add(272);
        knownPrimitives.add(528);
        knownPrimitives.add(784);
        knownPrimitives.add(1040);
        knownPrimitives.add(1296);
        knownPrimitives.add(1552);
        knownPrimitives.add(1808);
        knownPrimitives.add(32);
        knownPrimitives.add(288);
        knownPrimitives.add(544);
        knownPrimitives.add(800);
        knownPrimitives.add(1056);
        knownPrimitives.add(1312);
        knownPrimitives.add(1568);
        knownPrimitives.add(1824);
        knownPrimitives.add(112);
        knownPrimitives.add(368);
        knownPrimitives.add(624);
        knownPrimitives.add(880);
        knownPrimitives.add(1136);
        knownPrimitives.add(1392);
        knownPrimitives.add(1648);
        knownPrimitives.add(1904);
        knownPrimitives.add(113);
        knownPrimitives.add(369);
        knownPrimitives.add(625);
        knownPrimitives.add(881);
        knownPrimitives.add(1137);
        knownPrimitives.add(1393);
        knownPrimitives.add(1649);
        knownPrimitives.add(1905);
        knownPrimitives.add(122);
        knownPrimitives.add(378);
        knownPrimitives.add(634);
        knownPrimitives.add(890);
        knownPrimitives.add(1146);
        knownPrimitives.add(1402);
        knownPrimitives.add(1658);
        knownPrimitives.add(1914);
        knownPrimitives.add(123);
        knownPrimitives.add(379);
        knownPrimitives.add(635);
        knownPrimitives.add(891);
        knownPrimitives.add(1147);
        knownPrimitives.add(1403);
        knownPrimitives.add(1659);
        knownPrimitives.add(1915);
        knownPrimitives.add(104);
        knownPrimitives.add(360);
        knownPrimitives.add(616);
        knownPrimitives.add(872);
        knownPrimitives.add(1128);
        knownPrimitives.add(1384);
        knownPrimitives.add(1640);
        knownPrimitives.add(1896);
        knownPrimitives.add(105);
        knownPrimitives.add(361);
        knownPrimitives.add(617);
        knownPrimitives.add(873);
        knownPrimitives.add(1129);
        knownPrimitives.add(1385);
        knownPrimitives.add(1641);
        knownPrimitives.add(1897);
        knownPrimitives.add(17);
        knownPrimitives.add(273);
        knownPrimitives.add(529);
        knownPrimitives.add(785);
        knownPrimitives.add(1041);
        knownPrimitives.add(1297);
        knownPrimitives.add(1553);
        knownPrimitives.add(1809);
        knownPrimitives.add(33);
        knownPrimitives.add(289);
        knownPrimitives.add(545);
        knownPrimitives.add(801);
        knownPrimitives.add(1057);
        knownPrimitives.add(1313);
        knownPrimitives.add(1569);
        knownPrimitives.add(1825);
        knownPrimitives.add(114);
        knownPrimitives.add(370);
        knownPrimitives.add(626);
        knownPrimitives.add(882);
        knownPrimitives.add(1138);
        knownPrimitives.add(1394);
        knownPrimitives.add(1650);
        knownPrimitives.add(1906);
        knownPrimitives.add(115);
        knownPrimitives.add(371);
        knownPrimitives.add(627);
        knownPrimitives.add(883);
        knownPrimitives.add(1139);
        knownPrimitives.add(1395);
        knownPrimitives.add(1651);
        knownPrimitives.add(1907);
        knownPrimitives.add(18);
        knownPrimitives.add(274);
        knownPrimitives.add(530);
        knownPrimitives.add(786);
        knownPrimitives.add(1042);
        knownPrimitives.add(1298);
        knownPrimitives.add(1554);
        knownPrimitives.add(1810);
        knownPrimitives.add(34);
        knownPrimitives.add(290);
        knownPrimitives.add(546);
        knownPrimitives.add(802);
        knownPrimitives.add(1058);
        knownPrimitives.add(1314);
        knownPrimitives.add(1570);
        knownPrimitives.add(1826);
        knownPrimitives.add(116);
        knownPrimitives.add(372);
        knownPrimitives.add(628);
        knownPrimitives.add(884);
        knownPrimitives.add(1140);
        knownPrimitives.add(1396);
        knownPrimitives.add(1652);
        knownPrimitives.add(1908);
        knownPrimitives.add(117);
        knownPrimitives.add(373);
        knownPrimitives.add(629);
        knownPrimitives.add(885);
        knownPrimitives.add(1141);
        knownPrimitives.add(1397);
        knownPrimitives.add(1653);
        knownPrimitives.add(1909);
        knownPrimitives.add(19);
        knownPrimitives.add(275);
        knownPrimitives.add(531);
        knownPrimitives.add(787);
        knownPrimitives.add(1043);
        knownPrimitives.add(1299);
        knownPrimitives.add(1555);
        knownPrimitives.add(1811);
        knownPrimitives.add(35);
        knownPrimitives.add(291);
        knownPrimitives.add(547);
        knownPrimitives.add(803);
        knownPrimitives.add(1059);
        knownPrimitives.add(1315);
        knownPrimitives.add(1571);
        knownPrimitives.add(1827);
        knownPrimitives.add(118);
        knownPrimitives.add(374);
        knownPrimitives.add(630);
        knownPrimitives.add(886);
        knownPrimitives.add(1142);
        knownPrimitives.add(1398);
        knownPrimitives.add(1654);
        knownPrimitives.add(1910);
        knownPrimitives.add(119);
        knownPrimitives.add(375);
        knownPrimitives.add(631);
        knownPrimitives.add(887);
        knownPrimitives.add(1143);
        knownPrimitives.add(1399);
        knownPrimitives.add(1655);
        knownPrimitives.add(1911);
        knownPrimitives.add(20);
        knownPrimitives.add(276);
        knownPrimitives.add(532);
        knownPrimitives.add(788);
        knownPrimitives.add(1044);
        knownPrimitives.add(1300);
        knownPrimitives.add(1556);
        knownPrimitives.add(1812);
        knownPrimitives.add(36);
        knownPrimitives.add(292);
        knownPrimitives.add(548);
        knownPrimitives.add(804);
        knownPrimitives.add(1060);
        knownPrimitives.add(1316);
        knownPrimitives.add(1572);
        knownPrimitives.add(1828);
        knownPrimitives.add(120);
        knownPrimitives.add(376);
        knownPrimitives.add(632);
        knownPrimitives.add(888);
        knownPrimitives.add(1144);
        knownPrimitives.add(1400);
        knownPrimitives.add(1656);
        knownPrimitives.add(1912);
        knownPrimitives.add(121);
        knownPrimitives.add(377);
        knownPrimitives.add(633);
        knownPrimitives.add(889);
        knownPrimitives.add(1145);
        knownPrimitives.add(1401);
        knownPrimitives.add(1657);
        knownPrimitives.add(1913);
        knownPrimitives.add(70);
        knownPrimitives.add(326);
        knownPrimitives.add(582);
        knownPrimitives.add(838);
        knownPrimitives.add(1094);
        knownPrimitives.add(1350);
        knownPrimitives.add(1606);
        knownPrimitives.add(1862);
        knownPrimitives.add(64);
        knownPrimitives.add(320);
        knownPrimitives.add(576);
        knownPrimitives.add(832);
        knownPrimitives.add(1088);
        knownPrimitives.add(1344);
        knownPrimitives.add(1600);
        knownPrimitives.add(1856);
        knownPrimitives.add(69);
        knownPrimitives.add(325);
        knownPrimitives.add(581);
        knownPrimitives.add(837);
        knownPrimitives.add(1093);
        knownPrimitives.add(1349);
        knownPrimitives.add(1605);
        knownPrimitives.add(1861);
        knownPrimitives.add(68);
        knownPrimitives.add(324);
        knownPrimitives.add(580);
        knownPrimitives.add(836);
        knownPrimitives.add(1092);
        knownPrimitives.add(1348);
        knownPrimitives.add(1604);
        knownPrimitives.add(1860);
        knownPrimitives.add(65);
        knownPrimitives.add(321);
        knownPrimitives.add(577);
        knownPrimitives.add(833);
        knownPrimitives.add(1089);
        knownPrimitives.add(1345);
        knownPrimitives.add(1601);
        knownPrimitives.add(1857);
        knownPrimitives.add(66);
        knownPrimitives.add(322);
        knownPrimitives.add(578);
        knownPrimitives.add(834);
        knownPrimitives.add(1090);
        knownPrimitives.add(1346);
        knownPrimitives.add(1602);
        knownPrimitives.add(1858);
        knownPrimitives.add(67);
        knownPrimitives.add(323);
        knownPrimitives.add(579);
        knownPrimitives.add(835);
        knownPrimitives.add(1091);
        knownPrimitives.add(1347);
        knownPrimitives.add(1603);
        knownPrimitives.add(1859);
        knownPrimitives.add(80);
        knownPrimitives.add(336);
        knownPrimitives.add(592);
        knownPrimitives.add(848);
        knownPrimitives.add(1104);
        knownPrimitives.add(1360);
        knownPrimitives.add(1616);
        knownPrimitives.add(1872);
        knownPrimitives.add(81);
        knownPrimitives.add(337);
        knownPrimitives.add(593);
        knownPrimitives.add(849);
        knownPrimitives.add(1105);
        knownPrimitives.add(1361);
        knownPrimitives.add(1617);
        knownPrimitives.add(1873);
        knownPrimitives.add(82);
        knownPrimitives.add(338);
        knownPrimitives.add(594);
        knownPrimitives.add(850);
        knownPrimitives.add(1106);
        knownPrimitives.add(1362);
        knownPrimitives.add(1618);
        knownPrimitives.add(1874);
        knownPrimitives.add(83);
        knownPrimitives.add(339);
        knownPrimitives.add(595);
        knownPrimitives.add(851);
        knownPrimitives.add(1107);
        knownPrimitives.add(1363);
        knownPrimitives.add(1619);
        knownPrimitives.add(1875);
        knownPrimitives.add(84);
        knownPrimitives.add(340);
        knownPrimitives.add(596);
        knownPrimitives.add(852);
        knownPrimitives.add(1108);
        knownPrimitives.add(1364);
        knownPrimitives.add(1620);
        knownPrimitives.add(1876);
        knownPrimitives.add(85);
        knownPrimitives.add(341);
        knownPrimitives.add(597);
        knownPrimitives.add(853);
        knownPrimitives.add(1109);
        knownPrimitives.add(1365);
        knownPrimitives.add(1621);
        knownPrimitives.add(1877);
        knownPrimitives.add(86);
        knownPrimitives.add(342);
        knownPrimitives.add(598);
        knownPrimitives.add(854);
        knownPrimitives.add(1110);
        knownPrimitives.add(1366);
        knownPrimitives.add(1622);
        knownPrimitives.add(1878);
        knownPrimitives.add(48);
        knownPrimitives.add(304);
        knownPrimitives.add(560);
        knownPrimitives.add(816);
        knownPrimitives.add(1072);
        knownPrimitives.add(1328);
        knownPrimitives.add(1584);
        knownPrimitives.add(1840);
        knownPrimitives.add(49);
        knownPrimitives.add(305);
        knownPrimitives.add(561);
        knownPrimitives.add(817);
        knownPrimitives.add(1073);
        knownPrimitives.add(1329);
        knownPrimitives.add(1585);
        knownPrimitives.add(1841);
        knownPrimitives.add(50);
        knownPrimitives.add(306);
        knownPrimitives.add(562);
        knownPrimitives.add(818);
        knownPrimitives.add(1074);
        knownPrimitives.add(1330);
        knownPrimitives.add(1586);
        knownPrimitives.add(1842);
        knownPrimitives.add(51);
        knownPrimitives.add(307);
        knownPrimitives.add(563);
        knownPrimitives.add(819);
        knownPrimitives.add(1075);
        knownPrimitives.add(1331);
        knownPrimitives.add(1587);
        knownPrimitives.add(1843);
        knownPrimitives.add(52);
        knownPrimitives.add(308);
        knownPrimitives.add(564);
        knownPrimitives.add(820);
        knownPrimitives.add(1076);
        knownPrimitives.add(1332);
        knownPrimitives.add(1588);
        knownPrimitives.add(1844);
        knownPrimitives.add(496);
        knownPrimitives.add(752);
        knownPrimitives.add(1008);
        knownPrimitives.add(1264);
        knownPrimitives.add(1520);
        knownPrimitives.add(1776);
        knownPrimitives.add(2032);
        symbolTypesSeen = new HashSet<Integer>();
        symbolTypesSeen.add(1);
        symbolTypesSeen.add(3);
        symbolTypesSeen.add(6);
        symbolTypesSeen.add(1028);
        symbolTypesSeen.add(4098);
        symbolTypesSeen.add(4114);
        symbolTypesSeen.add(4353);
        symbolTypesSeen.add(4354);
        symbolTypesSeen.add(4355);
        symbolTypesSeen.add(4357);
        symbolTypesSeen.add(4358);
        symbolTypesSeen.add(4359);
        symbolTypesSeen.add(4360);
        symbolTypesSeen.add(4363);
        symbolTypesSeen.add(4364);
        symbolTypesSeen.add(4365);
        symbolTypesSeen.add(4366);
        symbolTypesSeen.add(4367);
        symbolTypesSeen.add(4368);
        symbolTypesSeen.add(4369);
        symbolTypesSeen.add(4371);
        symbolTypesSeen.add(4372);
        symbolTypesSeen.add(4373);
        symbolTypesSeen.add(4374);
        symbolTypesSeen.add(4384);
        symbolTypesSeen.add(4388);
        symbolTypesSeen.add(4389);
        symbolTypesSeen.add(4391);
        symbolTypesSeen.add(4393);
        symbolTypesSeen.add(4394);
        symbolTypesSeen.add(4396);
        symbolTypesSeen.add(4397);
        symbolTypesSeen.add(4402);
        symbolTypesSeen.add(4406);
        symbolTypesSeen.add(4407);
        symbolTypesSeen.add(4408);
        symbolTypesSeen.add(4409);
        symbolTypesSeen.add(4410);
        symbolTypesSeen.add(4412);
        symbolTypesSeen.add(4413);
        symbolTypesSeen.add(4414);
        symbolTypesSeen.add(4417);
        symbolTypesSeen.add(4418);
        symbolTypesSeen.add(4419);
        symbolTypesSeen.add(4420);
        symbolTypesSeen.add(4421);
        symbolTypesSeen.add(4428);
        symbolTypesSeen.add(4429);
        symbolTypesSeen.add(4430);
        symbolTypesSeen.add(4435);
        symbolTypesSeen.add(4441);
        symbolTypesSeen.add(4442);
        symbolTypesSeen.add(4446);
        symbolTypesSeen.add(4455);
        symbolTypesSeen.add(4456);
    }

    private static enum PdbAnomaly {
        UNKNOWN("???", -1),
        UNINDICATED_EXISTING_IPI("Unindicated IPI Exists", 0),
        DATA_RECORD_NUMBER_HIGH_BIT("Data record number high bit set", 1),
        ITEM_RECORD_NUMBER_HIGH_BIT("Item record number high bit set", 2),
        MAX_SEGMENT_AS_BASE("Max segment refers to segment zero", 3);

        private static final Map<Integer, PdbAnomaly> BY_VALUE;
        public final String description;
        private final int value;

        public String toString() {
            return this.description;
        }

        private PdbAnomaly(String description, int value) {
            this.description = description;
            this.value = value;
        }

        static {
            BY_VALUE = new HashMap<Integer, PdbAnomaly>();
            for (PdbAnomaly val : PdbAnomaly.values()) {
                BY_VALUE.put(val.value, val);
            }
        }
    }
}

