/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table.constrainteditor;

import docking.DisabledComponentLayerFactory;
import docking.widgets.EmptyBorderButton;
import docking.widgets.label.GDHtmlLabel;
import docking.widgets.table.constraint.ColumnConstraint;
import docking.widgets.table.constraint.ColumnData;
import docking.widgets.table.constrainteditor.AbstractColumnConstraintEditor;
import ghidra.util.HTMLUtilities;
import ghidra.util.Msg;
import ghidra.util.layout.ColumnLayout;
import ghidra.util.task.Task;
import ghidra.util.task.TaskBuilder;
import ghidra.util.task.TaskListener;
import ghidra.util.task.TaskMonitor;
import ghidra.util.task.TaskMonitorComponent;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayer;
import javax.swing.JPanel;
import resources.Icons;

public abstract class DataLoadingConstraintEditor<T>
extends AbstractColumnConstraintEditor<T>
implements TaskListener {
    private TaskMonitorComponent taskMonitorComponent;
    private JButton reloadDataButton;
    protected final ColumnData<T> columnDataSource;
    private boolean hasLoaded = false;
    private boolean hasInlineEditorComponent = false;
    private static final String TASK_VIEW = "Task";
    private static final String EDITOR_VIEW = "Editor";
    private JPanel viewPanel;
    private CardLayout viewLayout;
    private JLayer<?> detailEditorDisableLayer = null;
    protected JLabel statusLabel;

    public DataLoadingConstraintEditor(ColumnConstraint<T> delegateConstraint, ColumnData<T> columnDataSource) {
        super(delegateConstraint);
        Objects.requireNonNull(columnDataSource, "columnDataSource must be non-null");
        this.columnDataSource = columnDataSource;
    }

    @Override
    protected Component buildInlineEditorComponent() {
        JPanel editorPanel = new JPanel(new BorderLayout());
        this.statusLabel = new GDHtmlLabel();
        this.statusLabel.setHorizontalAlignment(0);
        this.taskMonitorComponent = new TaskMonitorComponent();
        this.reloadDataButton = new EmptyBorderButton(Icons.REFRESH_ICON);
        this.reloadDataButton.setToolTipText("Reload column data");
        this.reloadDataButton.addActionListener(e -> this.loadData());
        this.viewLayout = new CardLayout();
        this.viewPanel = new JPanel(this.viewLayout);
        this.viewPanel.add((Component)this.taskMonitorComponent, TASK_VIEW);
        Component editorComponent = this.buildDelegateInlineEditor();
        if (editorComponent != null) {
            editorPanel.add(editorComponent, "Center");
            this.viewPanel.add((Component)editorPanel, EDITOR_VIEW);
            this.hasInlineEditorComponent = true;
        }
        JPanel buttonPanel = new JPanel((LayoutManager)new ColumnLayout(2, 2, 1));
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        buttonPanel.add(this.reloadDataButton);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.viewPanel, "Center");
        panel.add((Component)buttonPanel, "East");
        panel.add((Component)this.statusLabel, "South");
        return panel;
    }

    protected Component buildDelegateInlineEditor() {
        return null;
    }

    @Override
    protected Component buildDetailEditorComponent() {
        Component comp = this.buildDelegateDetailEditor();
        if (comp == null) {
            if (!this.hasInlineEditorComponent) {
                throw new IllegalStateException("Constraint must provide an editor component");
            }
            return null;
        }
        JPanel editorWrapper = new JPanel(new BorderLayout());
        editorWrapper.add(comp, "Center");
        if (comp instanceof JComponent) {
            this.detailEditorDisableLayer = DisabledComponentLayerFactory.getDisabledLayer((JComponent)comp);
            editorWrapper.add(this.detailEditorDisableLayer);
        }
        return editorWrapper;
    }

    protected Component buildDelegateDetailEditor() {
        return null;
    }

    public abstract void handleColumnDataValue(T var1);

    public void columnDataLoadComplete() {
        Msg.info((Object)this, (Object)"Load Complete!");
    }

    public void columnDataLoadCancelled() {
        this.reset();
    }

    public void clearColumnData() {
    }

    private void showTaskView() {
        this.viewLayout.show(this.viewPanel, TASK_VIEW);
        if (this.detailEditorDisableLayer != null) {
            this.detailEditorDisableLayer.setEnabled(false);
        }
    }

    private void showEditorView() {
        this.viewLayout.show(this.viewPanel, EDITOR_VIEW);
        if (this.detailEditorDisableLayer != null) {
            this.detailEditorDisableLayer.setEnabled(true);
        }
    }

    private void loadData() {
        this.showTaskView();
        this.clearColumnData();
        this.reloadDataButton.setVisible(false);
        LoadDataTask task = new LoadDataTask();
        task.addTaskListener(this);
        TaskBuilder.withTask(task).launchInBackground(this.taskMonitorComponent);
    }

    @Override
    public void reset() {
        this.hasLoaded = false;
        this.clearColumnData();
        this.resetEditor();
        this.loadData();
    }

    protected abstract void resetEditor();

    @Override
    protected abstract ColumnConstraint<T> getValueFromComponent();

    @Override
    public String getErrorMessage() {
        return "Data load required";
    }

    @Override
    protected void updateEditorComponent() {
        if (!this.hasLoaded) {
            this.loadData();
        }
        this.doUpdateEditorComponent();
    }

    protected abstract void doUpdateEditorComponent();

    public void taskCompleted(Task task) {
        this.reloadDataButton.setVisible(true);
        this.taskMonitorComponent.setMessage("<html>" + HTMLUtilities.bold((String)"Ready"));
        this.hasLoaded = true;
        this.columnDataLoadComplete();
        this.showEditorView();
        this.valueChanged();
    }

    public void taskCancelled(Task task) {
        this.reloadDataButton.setVisible(true);
        this.hasLoaded = false;
        this.columnDataLoadCancelled();
        this.showEditorView();
        this.taskMonitorComponent.reset();
        this.valueChanged();
    }

    private class LoadDataTask
    extends Task {
        public LoadDataTask() {
            super("Load column data", true, true, true, true);
        }

        private long elapsedNanosIn(long elapsedNanos, TimeUnit unit) {
            return unit.convert(elapsedNanos, TimeUnit.NANOSECONDS);
        }

        private String getElapsedTimeString(long elapsedNanos) {
            long hours = this.elapsedNanosIn(elapsedNanos, TimeUnit.HOURS);
            long minutes = this.elapsedNanosIn(elapsedNanos, TimeUnit.MINUTES) - hours * 60L;
            long seconds = this.elapsedNanosIn(elapsedNanos, TimeUnit.SECONDS) - minutes * 60L;
            if (hours != 0L) {
                return String.format("%d:%02d:%02d", hours, minutes, seconds);
            }
            return String.format("%02d:%02d", minutes, seconds);
        }

        public void run(TaskMonitor monitor) {
            long start = System.nanoTime();
            int limit = DataLoadingConstraintEditor.this.columnDataSource.getCount();
            monitor.initialize((long)limit);
            monitor.setIndeterminate(false);
            monitor.setMessage("Loading column data...");
            for (int i = 0; i < limit; ++i) {
                if (monitor.isCancelled()) {
                    return;
                }
                Object val = DataLoadingConstraintEditor.this.columnDataSource.getColumnValue(i);
                DataLoadingConstraintEditor.this.handleColumnDataValue(val);
                long elapsed = System.nanoTime() - start;
                monitor.setMessage("Loading column data... (" + this.getElapsedTimeString(elapsed) + ")");
                monitor.incrementProgress(1L);
            }
        }
    }
}

