/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.base.replace;

import docking.DialogComponentProvider;
import docking.widgets.combobox.GhidraComboBox;
import ghidra.features.base.replace.SearchAndReplaceQuery;
import ghidra.features.base.replace.SearchType;
import ghidra.framework.plugintool.PluginTool;
import ghidra.util.HelpLocation;
import ghidra.util.layout.HorizontalLayout;
import ghidra.util.layout.PairLayout;
import ghidra.util.layout.VerticalLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class SearchAndReplaceDialog
extends DialogComponentProvider {
    private static final int MAX_HISTORY = 20;
    private List<SearchType> allTypes;
    private List<JCheckBox> typeCheckboxes = new ArrayList<JCheckBox>();
    private SearchAndReplaceQuery query;
    private Set<SearchType> selectedTypes = new HashSet<SearchType>();
    private GhidraComboBox<String> searchTextComboBox;
    private GhidraComboBox<String> replaceTextComboBox;
    private JCheckBox regexCheckbox;
    private JCheckBox caseSensitiveCheckbox;
    private JCheckBox wholeWordCheckbox;
    private int searchLimit;

    public SearchAndReplaceDialog(int searchLimit) {
        super("Search And Replace");
        this.searchLimit = searchLimit;
        this.allTypes = new ArrayList<SearchType>(SearchType.getSearchTypes());
        Collections.sort(this.allTypes);
        this.addWorkPanel(this.buildMainPanel());
        this.addOKButton();
        this.addCancelButton();
        this.updateDialogStatus();
        this.setHelpLocation(new HelpLocation("Search", "Search And Replace"));
    }

    public void setSearchLimit(int searchLimit) {
        this.searchLimit = searchLimit;
    }

    public SearchAndReplaceQuery show(PluginTool tool) {
        this.query = null;
        this.searchTextComboBox.getTextField().selectAll();
        this.replaceTextComboBox.setText("");
        this.updateDialogStatus();
        tool.showDialog((DialogComponentProvider)this);
        return this.query;
    }

    public SearchAndReplaceQuery getQuery() {
        return this.query;
    }

    private JComponent buildMainPanel() {
        JPanel panel = new JPanel((LayoutManager)new VerticalLayout(20));
        panel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        panel.add(this.buildPatternsPanel());
        panel.add(this.buildOptionsPanel());
        panel.add(this.buildTypesPanel());
        return panel;
    }

    private JComponent buildTypesPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createTitledBorder("Search For:"));
        panel.add((Component)this.buildInnerTypesPanel(), "Center");
        panel.add(this.buildSelectAllPanel(), "South");
        return panel;
    }

    private JPanel buildInnerTypesPanel() {
        JPanel panel = new JPanel(new GridLayout(0, 3, 10, 5));
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        for (SearchType type : this.allTypes) {
            JCheckBox cb = new JCheckBox(type.getName());
            this.typeCheckboxes.add(cb);
            cb.setToolTipText(type.getDescription());
            cb.addActionListener(e -> this.typeCheckBoxChanged(cb, type));
            panel.add(cb);
        }
        return panel;
    }

    private Component buildSelectAllPanel() {
        JPanel panel = new JPanel(new FlowLayout(1, 30, 10));
        JButton selectAllButton = new JButton("Select All");
        JButton deselectAllButton = new JButton("Deselect All");
        selectAllButton.addActionListener(e -> this.selectAllTypes());
        deselectAllButton.addActionListener(e -> this.deselectAllTypes());
        panel.add(selectAllButton);
        panel.add(deselectAllButton);
        return panel;
    }

    private void selectAllTypes() {
        for (JCheckBox checkBox : this.typeCheckboxes) {
            checkBox.setSelected(true);
        }
        this.selectedTypes.addAll(this.allTypes);
        this.updateDialogStatus();
    }

    private void deselectAllTypes() {
        for (JCheckBox checkBox : this.typeCheckboxes) {
            checkBox.setSelected(false);
        }
        this.selectedTypes.clear();
        this.updateDialogStatus();
    }

    private void typeCheckBoxChanged(JCheckBox cb, SearchType type) {
        if (cb.isSelected()) {
            this.selectedTypes.add(type);
        } else {
            this.selectedTypes.remove(type);
        }
        this.updateDialogStatus();
    }

    private void updateDialogStatus() {
        boolean isValid = this.hasValidInformation();
        this.setOkEnabled(isValid);
    }

    private boolean hasValidInformation() {
        this.clearStatusText();
        String searchText = this.searchTextComboBox.getText().trim();
        if (searchText.isBlank()) {
            this.setStatusText("Please enter search text");
            return false;
        }
        if (this.selectedTypes.isEmpty()) {
            this.setStatusText("Please select at least one \"search for\" item to search!");
            return false;
        }
        return this.createQuery() != null;
    }

    private JComponent buildOptionsPanel() {
        this.regexCheckbox = new JCheckBox("Regular expression");
        this.caseSensitiveCheckbox = new JCheckBox("Case sensitive");
        this.wholeWordCheckbox = new JCheckBox("Whole word");
        this.regexCheckbox.addActionListener(e -> this.regExCheckboxChanged());
        this.regexCheckbox.setToolTipText("Interprets search and replace text as regular expressions");
        this.caseSensitiveCheckbox.setToolTipText("Determines if search text is case sensitive");
        this.wholeWordCheckbox.setToolTipText("Sets if the input pattern must match whole words. For names, this means the entire name. For comments, it means matching entire words.");
        JPanel panel = new JPanel((LayoutManager)new HorizontalLayout(10));
        TitledBorder titleBorder = BorderFactory.createTitledBorder("Options:");
        Border innerBorder = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        panel.setBorder(BorderFactory.createCompoundBorder(titleBorder, innerBorder));
        panel.add(this.regexCheckbox);
        panel.add(this.caseSensitiveCheckbox);
        panel.add(this.wholeWordCheckbox);
        return panel;
    }

    private void regExCheckboxChanged() {
        this.wholeWordCheckbox.setEnabled(!this.regexCheckbox.isSelected());
        this.updateDialogStatus();
    }

    private Component buildPatternsPanel() {
        this.searchTextComboBox = new GhidraComboBox();
        this.searchTextComboBox.setEditable(true);
        this.searchTextComboBox.setToolTipText("Enter the text to search for");
        this.searchTextComboBox.getTextField().getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                SearchAndReplaceDialog.this.updateDialogStatus();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                SearchAndReplaceDialog.this.updateDialogStatus();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                SearchAndReplaceDialog.this.updateDialogStatus();
            }
        });
        this.replaceTextComboBox = new GhidraComboBox();
        this.replaceTextComboBox.setEditable(true);
        this.replaceTextComboBox.setToolTipText("Enter the text to replace matched search text");
        this.searchTextComboBox.addActionListener(e -> this.pressOk());
        this.replaceTextComboBox.addActionListener(e -> this.pressOk());
        JPanel panel = new JPanel((LayoutManager)new PairLayout(10, 10));
        panel.add(new JLabel("Find:", 4));
        panel.add((Component)this.searchTextComboBox);
        panel.add(new JLabel("Replace with:", 4));
        panel.add((Component)this.replaceTextComboBox);
        return panel;
    }

    private void pressOk() {
        if (this.isOKEnabled()) {
            this.okCallback();
        }
    }

    protected void okCallback() {
        this.query = this.createQuery();
        this.updateHistory(this.searchTextComboBox);
        this.updateHistory(this.replaceTextComboBox);
        this.closeDialog();
    }

    private SearchAndReplaceQuery createQuery() {
        String searchText = this.searchTextComboBox.getText().trim();
        String replacePattern = this.replaceTextComboBox.getText().trim();
        boolean isRegEx = this.regexCheckbox.isSelected();
        boolean isCaseSensitive = this.caseSensitiveCheckbox.isSelected();
        boolean isWholeWord = this.wholeWordCheckbox.isSelected();
        Set<SearchType> searchTypes = this.getSelectedSearchTypes();
        try {
            return new SearchAndReplaceQuery(searchText, replacePattern, searchTypes, isRegEx, isCaseSensitive, isWholeWord, this.searchLimit);
        }
        catch (PatternSyntaxException e) {
            return null;
        }
    }

    private Set<SearchType> getSelectedSearchTypes() {
        HashSet<SearchType> set = new HashSet<SearchType>();
        for (SearchType type : this.allTypes) {
            if (!this.selectedTypes.contains(type)) continue;
            set.add(type);
        }
        return set;
    }

    private void updateHistory(GhidraComboBox<String> combo) {
        String value = combo.getText();
        if (value.isBlank()) {
            return;
        }
        DefaultComboBoxModel model = (DefaultComboBoxModel)combo.getModel();
        model.removeElement(value);
        if (model.getSize() > 20) {
            model.removeElementAt(model.getSize() - 1);
        }
        model.insertElementAt(value, 0);
        model.setSelectedItem(value);
    }

    public void setSarchAndReplaceText(String searchText, String replaceText) {
        this.searchTextComboBox.setText(searchText);
        this.replaceTextComboBox.setText(replaceText);
    }

    public void selectSearchType(String searchType) {
        for (JCheckBox checkBox : this.typeCheckboxes) {
            if (!checkBox.getText().equals(searchType)) continue;
            checkBox.setSelected(true);
            break;
        }
        for (SearchType type : this.allTypes) {
            if (!type.getName().equals(searchType)) continue;
            this.selectedTypes.add(type);
            break;
        }
        this.updateDialogStatus();
    }

    public boolean isOkEnabled() {
        return super.isOKEnabled();
    }

    public void selectRegEx(boolean b) {
        this.regexCheckbox.setSelected(b);
        this.updateDialogStatus();
    }
}

