/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.swift.types;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.swift.SwiftTypeMetadataStructure;
import ghidra.app.util.bin.format.swift.types.CaptureTypeRecord;
import ghidra.app.util.bin.format.swift.types.MetadataSourceRecord;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class CaptureDescriptor
extends SwiftTypeMetadataStructure {
    public static final int SIZE = 12;
    private int numCaptureTypes;
    private int numMetadataSources;
    private int numBindings;
    private List<CaptureTypeRecord> captureTypeRecords = new ArrayList<CaptureTypeRecord>();
    private List<MetadataSourceRecord> metadataSourceRecords = new ArrayList<MetadataSourceRecord>();

    public CaptureDescriptor(BinaryReader reader) throws IOException {
        super(reader.getPointerIndex());
        int i;
        this.numCaptureTypes = reader.readNextInt();
        this.numMetadataSources = reader.readNextInt();
        this.numBindings = reader.readNextInt();
        for (i = 0; i < this.numCaptureTypes; ++i) {
            this.captureTypeRecords.add(new CaptureTypeRecord(reader));
        }
        for (i = 0; i < this.numMetadataSources; ++i) {
            this.metadataSourceRecords.add(new MetadataSourceRecord(reader));
        }
    }

    public int getNumCaptureTypes() {
        return this.numCaptureTypes;
    }

    public int getNumMetadataSources() {
        return this.numMetadataSources;
    }

    public int getNumBindings() {
        return this.numBindings;
    }

    public List<CaptureTypeRecord> getCaptureTypeRecords() {
        return this.captureTypeRecords;
    }

    public List<MetadataSourceRecord> getMetadataSourceRecords() {
        return this.metadataSourceRecords;
    }

    @Override
    public String getStructureName() {
        return CaptureDescriptor.class.getSimpleName();
    }

    @Override
    public String getDescription() {
        return "capture descriptor";
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(this.getStructureName(), 0);
        struct.add(DWORD, "NumCaptureTypes", "");
        struct.add(DWORD, "NumMetadataSources", "");
        struct.add(DWORD, "NumBindings", "");
        struct.setCategoryPath(new CategoryPath("/SwiftTypeMetadata"));
        return struct;
    }
}

