/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.omf;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.omf.AbstractOmfRecordFactory;
import ghidra.app.util.bin.format.omf.Omf2or4;
import ghidra.app.util.bin.format.omf.OmfException;
import ghidra.app.util.bin.format.omf.OmfIndex;
import ghidra.app.util.bin.format.omf.OmfRecord;
import ghidra.app.util.bin.format.omf.OmfString;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.ByteDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.data.WordDataType;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;

public class OmfUtils {
    public static final String CATEGORY_PATH = "/OMF";

    public static Omf2or4 readInt2Or4(BinaryReader reader, boolean isBig) throws IOException {
        return isBig ? new Omf2or4(4, reader.readNextInt()) : new Omf2or4(2, reader.readNextUnsignedShort());
    }

    public static OmfIndex readIndex(BinaryReader reader) throws IOException {
        int length;
        int indexWord;
        int firstByte = reader.readNextByte();
        if ((firstByte & 0x80) != 0) {
            indexWord = (firstByte & 0x7F) * 256 + (reader.readNextByte() & 0xFF);
            length = 2;
        } else {
            indexWord = firstByte;
            length = 1;
        }
        return new OmfIndex(length, indexWord);
    }

    public static OmfString readString(BinaryReader reader) throws IOException {
        int count = reader.readNextUnsignedByte();
        return new OmfString(count, reader.readNextAsciiString(count));
    }

    public static final String getRecordName(int type, Class<?> recordTypesClass) {
        for (Field field : recordTypesClass.getDeclaredFields()) {
            int modifiers = field.getModifiers();
            if (!Modifier.isFinal(modifiers) || !Modifier.isStatic(modifiers)) continue;
            try {
                Integer value = (Integer)field.get(null);
                if (type != value) continue;
                return field.getName();
            }
            catch (Exception e) {
                break;
            }
        }
        return "<UNKNOWN>";
    }

    public static DataType toOmfRecordDataType(OmfRecord record, String name) {
        StructureDataType struct = new StructureDataType(name, 0);
        struct.add((DataType)ByteDataType.dataType, "type", null);
        struct.add((DataType)WordDataType.dataType, "length", null);
        struct.add((DataType)new ArrayDataType((DataType)ByteDataType.dataType, record.getRecordLength() - 1, 1), "contents", null);
        struct.add((DataType)ByteDataType.dataType, "checksum", null);
        struct.setCategoryPath(new CategoryPath(CATEGORY_PATH));
        return struct;
    }

    public static List<OmfRecord> readRecords(AbstractOmfRecordFactory factory) throws OmfException, IOException {
        OmfRecord rec;
        ArrayList<OmfRecord> records = new ArrayList<OmfRecord>();
        factory.reset();
        do {
            rec = factory.readNextRecord();
            records.add(rec);
        } while (rec.getRecordType() != factory.getEndRecordType());
        return records;
    }

    public static <T> Stream<T> filterRecords(List<OmfRecord> records, Class<T> classType) {
        return records.stream().filter(classType::isInstance).map(classType::cast);
    }
}

