/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.compositeeditor;

import docking.ActionContext;
import docking.action.KeyBindingData;
import docking.widgets.OptionDialog;
import generic.theme.GIcon;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorTableAction;
import ghidra.app.plugin.core.compositeeditor.StructureEditorModel;
import ghidra.app.plugin.core.compositeeditor.StructureEditorProvider;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.UsrException;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.KeyStroke;

public class UnpackageAction
extends CompositeEditorTableAction {
    private static final Icon ICON = new GIcon("icon.plugin.composite.editor.unpackage");
    public static final String ACTION_NAME = "Unpackage Component";
    private static final String GROUP_NAME = "4_COMPONENT_EDITOR_ACTION";
    private static final String DESCRIPTION = "Replace the selected composite with its components";
    private static final KeyStroke KEY_STROKE = KeyStroke.getKeyStroke(61, 0);
    private static String[] POPUP_PATH = new String[]{"Unpackage Component"};

    public UnpackageAction(StructureEditorProvider provider) {
        super(provider, ACTION_NAME, GROUP_NAME, POPUP_PATH, null, ICON);
        this.setDescription(DESCRIPTION);
        this.setKeyBindingData(new KeyBindingData(KEY_STROKE));
    }

    public void actionPerformed(ActionContext context) {
        if (!this.isEnabledForContext(context)) {
            return;
        }
        int currentRowIndex = this.model.getSelection().getFieldRange(0).getStart().getIndex().intValue();
        int subComps = this.model.getNumSubComponents(currentRowIndex);
        if (subComps > 1000) {
            String question = "Are you sure you want to unpackage " + subComps + " components?";
            String title = "Continue with unpackage?";
            int response = OptionDialog.showYesNoDialog((Component)this.model.getProvider().getComponent(), (String)title, (String)question);
            if (response != 1) {
                return;
            }
        }
        TaskLauncher.launchModal((String)"Unpackaging Component", monitor -> this.doUnpackage(currentRowIndex, monitor));
        this.requestTableFocus();
    }

    private void doUnpackage(int row, TaskMonitor monitor) {
        try {
            ((StructureEditorModel)this.model).unpackage(row, monitor);
        }
        catch (CancelledException cancelledException) {
        }
        catch (UsrException e1) {
            this.model.setStatus(e1.getMessage(), true);
        }
        this.model.fireTableDataChanged();
    }

    public boolean isEnabledForContext(ActionContext context) {
        return !this.hasIncompleteFieldEntry() && this.model.isUnpackageAllowed();
    }
}

