/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.function;

import ghidra.app.services.DataTypeManagerService;
import ghidra.framework.cmd.Command;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.FunctionDefinitionDataType;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionSignature;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;

public class CreateFunctionDefinitionCmd
implements Command<Program> {
    private Address entry;
    private final ServiceProvider serviceProvider;
    private String statusMsg = "";

    public CreateFunctionDefinitionCmd(Address entry, ServiceProvider serviceProvider) {
        this.entry = entry;
        this.serviceProvider = serviceProvider;
    }

    public String getName() {
        return "Create Function Definition";
    }

    public boolean applyTo(Program program) {
        DataTypeManagerService service;
        FunctionSignature sig;
        Listing listing = program.getListing();
        DataTypeManager dtm = listing.getDataTypeManager();
        Function func = listing.getFunctionAt(this.entry);
        if (func == null) {
            return false;
        }
        try {
            sig = func.getSignature(true);
        }
        catch (IllegalArgumentException e) {
            this.statusMsg = func.getName().indexOf(47) >= 0 ? "Datatype names can not contain a '/'" : e.getMessage();
            return false;
        }
        FunctionDefinitionDataType functionDef = new FunctionDefinitionDataType(sig);
        DataType newType = dtm.resolve((DataType)functionDef, null);
        if (this.serviceProvider != null && (service = (DataTypeManagerService)this.serviceProvider.getService(DataTypeManagerService.class)) != null) {
            service.setDataTypeSelected(newType);
        }
        return true;
    }

    public String getStatusMsg() {
        return this.statusMsg;
    }
}

