/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.extension.datatype.finder;

import ghidra.app.decompiler.ClangFieldToken;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.extension.datatype.finder.DecompilerVariable;
import ghidra.program.model.data.Array;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.TypeDef;
import ghidra.util.Msg;
import java.util.List;

public class DecompilerFieldAccess
extends DecompilerVariable {
    DecompilerFieldAccess() {
        super(null);
    }

    DecompilerFieldAccess(ClangFieldToken field, List<DecompilerVariable> casts) {
        super((ClangToken)field);
        this.casts = casts;
    }

    @Override
    public DataType getParentDataType() {
        ClangFieldToken field = (ClangFieldToken)this.variable;
        DataType dt = field.getDataType();
        return dt;
    }

    @Override
    public DataType getDataType() {
        DataTypeComponent subType;
        ClangFieldToken field = (ClangFieldToken)this.variable;
        DataType dt = field.getDataType();
        if (!((dt = this.getBaseType(dt)) instanceof Composite)) {
            Msg.error((Object)this, (Object)"Have a field for a type that is not a Composite type");
            return dt;
        }
        int offset = field.getOffset();
        Composite composite = (Composite)dt;
        if (composite instanceof Structure && (subType = ((Structure)composite).getComponentAt(offset)) != null) {
            return subType.getDataType();
        }
        int n = composite.getNumComponents();
        if (offset >= n) {
            return null;
        }
        DataTypeComponent component = composite.getComponent(offset);
        if (component == null) {
            return null;
        }
        dt = component.getDataType();
        return dt;
    }

    @Override
    public int getOffset() {
        ClangFieldToken field = (ClangFieldToken)this.variable;
        return field.getOffset();
    }

    protected DataType getBaseType(DataType dt) {
        if (dt instanceof Array) {
            return this.getBaseType(((Array)dt).getDataType());
        }
        if (dt instanceof Pointer) {
            DataType baseDataType = ((Pointer)dt).getDataType();
            if (baseDataType != null) {
                return this.getBaseType(baseDataType);
            }
        } else if (dt instanceof TypeDef) {
            return this.getBaseType(((TypeDef)dt).getBaseDataType());
        }
        return dt;
    }
}

