/*
 * Decompiled with CFR 0.152.
 */
package org.python.icu.text;

import org.python.icu.impl.Utility;
import org.python.icu.text.Replaceable;
import org.python.icu.text.UnicodeMatcher;
import org.python.icu.text.UnicodeSet;

class Quantifier
implements UnicodeMatcher {
    private UnicodeMatcher matcher;
    private int minCount;
    private int maxCount;
    public static final int MAX = Integer.MAX_VALUE;

    public Quantifier(UnicodeMatcher theMatcher, int theMinCount, int theMaxCount) {
        if (theMatcher == null || theMinCount < 0 || theMaxCount < 0 || theMinCount > theMaxCount) {
            throw new IllegalArgumentException();
        }
        this.matcher = theMatcher;
        this.minCount = theMinCount;
        this.maxCount = theMaxCount;
    }

    @Override
    public int matches(Replaceable text2, int[] offset, int limit, boolean incremental) {
        int count2;
        int start = offset[0];
        for (count2 = 0; count2 < this.maxCount; ++count2) {
            int pos = offset[0];
            int m = this.matcher.matches(text2, offset, limit, incremental);
            if (m == 2) {
                if (pos != offset[0]) continue;
                break;
            }
            if (!incremental || m != 1) break;
            return 1;
        }
        if (incremental && offset[0] == limit) {
            return 1;
        }
        if (count2 >= this.minCount) {
            return 2;
        }
        offset[0] = start;
        return 0;
    }

    @Override
    public String toPattern(boolean escapeUnprintable) {
        StringBuilder result2 = new StringBuilder();
        result2.append(this.matcher.toPattern(escapeUnprintable));
        if (this.minCount == 0) {
            if (this.maxCount == 1) {
                return result2.append('?').toString();
            }
            if (this.maxCount == Integer.MAX_VALUE) {
                return result2.append('*').toString();
            }
        } else if (this.minCount == 1 && this.maxCount == Integer.MAX_VALUE) {
            return result2.append('+').toString();
        }
        result2.append('{');
        result2.append(Utility.hex(this.minCount, 1));
        result2.append(',');
        if (this.maxCount != Integer.MAX_VALUE) {
            result2.append(Utility.hex(this.maxCount, 1));
        }
        result2.append('}');
        return result2.toString();
    }

    @Override
    public boolean matchesIndexValue(int v) {
        return this.minCount == 0 || this.matcher.matchesIndexValue(v);
    }

    @Override
    public void addMatchSetTo(UnicodeSet toUnionTo) {
        if (this.maxCount > 0) {
            this.matcher.addMatchSetTo(toUnionTo);
        }
    }
}

