/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.security.impl;

import com.google.common.net.InetAddresses;
import jakarta.servlet.ServletRequest;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.net.IPRange;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.security.AccessControl;
import net.shibboleth.shared.servlet.HttpServletSupport;
import org.slf4j.Logger;

public class IPRangeAccessControl
extends AbstractIdentifiableInitializableComponent
implements AccessControl {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(IPRangeAccessControl.class);
    @Nonnull
    private Collection<IPRange> allowedRanges = CollectionSupport.emptyList();

    public void setAllowedRanges(@Nonnull Collection<IPRange> ranges) {
        this.checkSetterPreconditions();
        Constraint.isNotNull(ranges, "IPRange collection cannot be null");
        this.allowedRanges = CollectionSupport.copyToList(ranges);
    }

    @Override
    public boolean checkAccess(@Nonnull ServletRequest request, @Nullable String operation, @Nullable String resource) {
        Constraint.isNotNull(request, "ServletRequest cannot be null");
        String addr = HttpServletSupport.getRemoteAddr(request);
        if (addr != null) {
            this.log.debug("{} Evaluating client address '{}'", (Object)this.getLogPrefix(), (Object)addr);
            try {
                byte[] resolvedAddress = InetAddresses.forString((String)addr).getAddress();
                for (IPRange range : this.allowedRanges) {
                    if (!range.contains(resolvedAddress)) continue;
                    this.log.debug("{} Granted access to client address '{}' (Operation: {}, Resource: {})", new Object[]{this.getLogPrefix(), addr, operation, resource});
                    return true;
                }
            }
            catch (IllegalArgumentException e) {
                this.log.warn("{} Error translating client address", (Object)this.getLogPrefix(), (Object)e);
            }
            this.log.warn("{} Denied request from client address '{}' (Operation: {}, Resource: {})", new Object[]{this.getLogPrefix(), addr, operation, resource});
        } else {
            this.log.warn("{} Denied request from client address 'unknown' (Operation: {}, Resource: {})", new Object[]{this.getLogPrefix(), operation, resource});
        }
        return false;
    }

    @Nonnull
    private String getLogPrefix() {
        return "Policy " + this.ensureId() + ":";
    }
}

