/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.user;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import org.opensearch.security.support.Base64Helper;
import org.opensearch.security.user.CustomAttributesAware;

public class User
implements Serializable,
CustomAttributesAware {
    public static final User ANONYMOUS = new User("opendistro_security_anonymous").withRoles("opendistro_security_anonymous_backendrole");
    public static final User DEFAULT_TRANSPORT_USER = new User("opendistro_security_default_transport_user").withRoles("opendistro_security_default_transport_backendrole");
    private static final long serialVersionUID = -5500938501822658596L;
    private final String name;
    private final ImmutableSet<String> roles;
    private final ImmutableSet<String> securityRoles;
    private final String requestedTenant;
    private final ImmutableMap<String, String> attributes;
    private final boolean isInjected;
    private final transient int estimatedByteSize;
    private volatile transient String serializedBase64;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("name", String.class), new ObjectStreamField("roles", Collections.synchronizedSet(Collections.emptySet()).getClass()), new ObjectStreamField("securityRoles", Collections.synchronizedSet(Collections.emptySet()).getClass()), new ObjectStreamField("requestedTenant", String.class), new ObjectStreamField("attributes", Collections.synchronizedMap(Collections.emptyMap()).getClass()), new ObjectStreamField("isInjected", Boolean.TYPE)};

    public static User fromSerializedBase64(String serializedBase64) {
        User user = (User)Base64Helper.deserializeObject(serializedBase64);
        user.serializedBase64 = serializedBase64;
        return user;
    }

    public User(String name) {
        this(name, (ImmutableSet<String>)ImmutableSet.of(), (ImmutableSet<String>)ImmutableSet.of(), null, (ImmutableMap<String, String>)ImmutableMap.of(), false);
    }

    public User(String name, ImmutableSet<String> roles, ImmutableSet<String> securityRoles, String requestedTenant, ImmutableMap<String, String> attributes, boolean isInjected) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("name must not be null or empty");
        }
        this.name = name;
        this.roles = Objects.requireNonNull(roles);
        this.securityRoles = Objects.requireNonNull(securityRoles);
        this.requestedTenant = requestedTenant;
        this.attributes = Objects.requireNonNull(attributes);
        this.isInjected = isInjected;
        this.estimatedByteSize = this.calcEstimatedByteSize();
    }

    public final String getName() {
        return this.name;
    }

    public ImmutableSet<String> getRoles() {
        return this.roles;
    }

    public User withRoles(String ... roles) {
        return this.withRoles(Arrays.asList(roles));
    }

    public User withRoles(Collection<String> roles) {
        if (roles == null || roles.isEmpty()) {
            return this;
        }
        return new User(this.name, (ImmutableSet<String>)new ImmutableSet.Builder().addAll(this.roles).addAll(roles).build(), this.securityRoles, this.requestedTenant, this.attributes, this.isInjected);
    }

    public User withAttributes(Map<String, String> attributes) {
        if (attributes == null || attributes.isEmpty()) {
            return this;
        }
        return new User(this.name, this.roles, this.securityRoles, this.requestedTenant, (ImmutableMap<String, String>)new ImmutableMap.Builder().putAll(this.attributes).putAll(attributes).build(), this.isInjected);
    }

    public final String getRequestedTenant() {
        return this.requestedTenant;
    }

    public User withRequestedTenant(String requestedTenant) {
        if (Objects.equals(requestedTenant, this.requestedTenant)) {
            return this;
        }
        return new User(this.name, this.roles, this.securityRoles, requestedTenant, this.attributes, this.isInjected);
    }

    public boolean isInjected() {
        return this.isInjected;
    }

    public final String toStringWithAttributes() {
        return "User [name=" + this.name + ", backend_roles=" + String.valueOf(this.roles) + ", requestedTenant=" + this.requestedTenant + ", attributes=" + String.valueOf(this.attributes) + "]";
    }

    public final String toString() {
        return "User [name=" + this.name + ", backend_roles=" + String.valueOf(this.roles) + ", requestedTenant=" + this.requestedTenant + "]";
    }

    public final int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof User)) {
            return false;
        }
        User other = (User)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public ImmutableMap<String, String> getCustomAttributesMap() {
        return this.attributes;
    }

    public User withSecurityRoles(Collection<String> securityRoles) {
        if (securityRoles == null || securityRoles.isEmpty()) {
            return this;
        }
        return new User(this.name, this.roles, (ImmutableSet<String>)new ImmutableSet.Builder().addAll(this.securityRoles).addAll(securityRoles).build(), this.requestedTenant, this.attributes, this.isInjected);
    }

    public ImmutableSet<String> getSecurityRoles() {
        return this.securityRoles;
    }

    public boolean isServiceAccount() {
        ImmutableMap<String, String> userAttributesMap = this.getCustomAttributesMap();
        return userAttributesMap != null && "true".equals(userAttributesMap.get("attr.internal.service"));
    }

    public boolean isPluginUser() {
        return this.name != null && this.name.startsWith("plugin:");
    }

    public String toSerializedBase64() {
        String result = this.serializedBase64;
        if (result == null) {
            this.serializedBase64 = result = Base64Helper.serializeObject(this);
        }
        return result;
    }

    public int estimatedByteSize() {
        return this.estimatedByteSize;
    }

    private int calcEstimatedByteSize() {
        int size = 32;
        size += User.estimateStringSize(this.name);
        size += User.estimateStringSize(this.requestedTenant);
        size += this.roles.stream().mapToInt(User::estimateStringSize).sum() + 32;
        size += this.securityRoles.stream().mapToInt(User::estimateStringSize).sum() + 32;
        return size += this.attributes.entrySet().stream().mapToInt(entry -> User.estimateStringSize((String)entry.getKey()) + User.estimateStringSize((String)entry.getValue())).sum() + 32;
    }

    private static int estimateStringSize(String s) {
        if (s != null) {
            return 40 + s.length() * 2;
        }
        return 0;
    }

    void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Use org.opensearch.security.user.serialized.User");
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        ObjectOutputStream.PutField fields = out.putFields();
        fields.put("name", this.name);
        fields.put("roles", Collections.synchronizedSet(new HashSet<String>((Collection<String>)this.roles)));
        fields.put("securityRoles", Collections.synchronizedSet(new HashSet<String>((Collection<String>)this.securityRoles)));
        fields.put("requestedTenant", this.requestedTenant);
        fields.put("attributes", Collections.synchronizedMap(new HashMap<String, String>((Map<String, String>)this.attributes)));
        fields.put("isInjected", this.isInjected);
        out.writeFields();
    }
}

