/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import org.bouncycastle.crypto.NativeServices;
import org.bouncycastle.crypto.fips.NativeFeatures;
import org.bouncycastle.crypto.fips.NativeLibIdentity;
import org.bouncycastle.crypto.fips.NativeLoader;
import org.bouncycastle.crypto.fips.VariantSelector;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class FipsNativeServices
implements NativeServices {
    public static final String RSA = "RSA";
    private static Set<String> nativeFeatures = null;

    FipsNativeServices() {
    }

    @Override
    public String getStatusMessage() {
        if (NativeLoader.isNativeLibsAvailableForSystem()) {
            if (NativeLoader.isNativeInstalled()) {
                return "READY";
            }
            return NativeLoader.getNativeStatusMessage();
        }
        return "UNSUPPORTED";
    }

    @Override
    public Set<String> getFeatureSet() {
        return FipsNativeServices.getNativeFeatureSet();
    }

    public String getFeatureString() {
        return String.join((CharSequence)" ", this.getFeatureSet());
    }

    @Override
    public String getVariant() {
        return NativeLoader.getSelectedVariant();
    }

    @Override
    public String[][] getVariantSelectionMatrix() {
        try {
            return VariantSelector.getFeatureMatrix();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            return new String[0][];
        }
    }

    @Override
    public boolean hasService(String string) {
        if (nativeFeatures == null) {
            nativeFeatures = FipsNativeServices.getNativeFeatureSet();
        }
        return nativeFeatures.contains(string);
    }

    @Override
    public String getBuildDate() {
        return NativeLibIdentity.getNativeBuiltTimeStamp();
    }

    @Override
    public String getLibraryIdent() {
        String string = NativeLibIdentity.getLibraryIdent();
        if (string == null) {
            return "java";
        }
        return string;
    }

    @Override
    public boolean isEnabled() {
        return NativeLoader.isNativeEnabled();
    }

    @Override
    public boolean isInstalled() {
        return NativeLoader.isNativeInstalled();
    }

    @Override
    public boolean isSupported() {
        return NativeLoader.isNativeLibsAvailableForSystem();
    }

    static synchronized Set<String> getNativeFeatureSet() {
        TreeSet<String> treeSet = new TreeSet<String>();
        if (NativeFeatures.hasHardwareRSA()) {
            treeSet.add(RSA);
        }
        if (NativeFeatures.hasHardwareSeed()) {
            treeSet.add("NRBG");
        }
        if (NativeFeatures.hasHardwareRand()) {
            treeSet.add("DRBG");
        }
        if (NativeFeatures.hasAESHardwareSupport()) {
            treeSet.add("AES/ECB");
        }
        if (NativeFeatures.hasGCMHardwareSupport()) {
            treeSet.add("AES/GCM");
        }
        if (NativeFeatures.hasCBCHardwareSupport()) {
            treeSet.add("AES/CBC");
        }
        if (NativeFeatures.hasCFBHardwareSupport()) {
            treeSet.add("AES/CFB");
        }
        if (NativeFeatures.hasCTRHardwareSupport()) {
            treeSet.add("AES/CTR");
        }
        if (NativeFeatures.hasHardwareSHA()) {
            treeSet.add("SHA2");
        }
        if (treeSet.isEmpty()) {
            treeSet.add("NONE");
        }
        return Collections.unmodifiableSet(treeSet);
    }
}

