/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.materialproviders.model;

import java.util.List;
import java.util.Objects;
import software.amazon.awssdk.services.kms.KmsClient;
import software.amazon.cryptography.materialproviders.model.DiscoveryFilter;

public class CreateAwsKmsMrkDiscoveryKeyringInput {
    private final KmsClient kmsClient;
    private final DiscoveryFilter discoveryFilter;
    private final List<String> grantTokens;
    private final String region;

    protected CreateAwsKmsMrkDiscoveryKeyringInput(BuilderImpl builder) {
        this.kmsClient = builder.kmsClient();
        this.discoveryFilter = builder.discoveryFilter();
        this.grantTokens = builder.grantTokens();
        this.region = builder.region();
    }

    public KmsClient kmsClient() {
        return this.kmsClient;
    }

    public DiscoveryFilter discoveryFilter() {
        return this.discoveryFilter;
    }

    public List<String> grantTokens() {
        return this.grantTokens;
    }

    public String region() {
        return this.region;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected KmsClient kmsClient;
        protected DiscoveryFilter discoveryFilter;
        protected List<String> grantTokens;
        protected String region;

        protected BuilderImpl() {
        }

        protected BuilderImpl(CreateAwsKmsMrkDiscoveryKeyringInput model) {
            this.kmsClient = model.kmsClient();
            this.discoveryFilter = model.discoveryFilter();
            this.grantTokens = model.grantTokens();
            this.region = model.region();
        }

        @Override
        public Builder kmsClient(KmsClient kmsClient) {
            this.kmsClient = kmsClient;
            return this;
        }

        @Override
        public KmsClient kmsClient() {
            return this.kmsClient;
        }

        @Override
        public Builder discoveryFilter(DiscoveryFilter discoveryFilter) {
            this.discoveryFilter = discoveryFilter;
            return this;
        }

        @Override
        public DiscoveryFilter discoveryFilter() {
            return this.discoveryFilter;
        }

        @Override
        public Builder grantTokens(List<String> grantTokens) {
            this.grantTokens = grantTokens;
            return this;
        }

        @Override
        public List<String> grantTokens() {
            return this.grantTokens;
        }

        @Override
        public Builder region(String region) {
            this.region = region;
            return this;
        }

        @Override
        public String region() {
            return this.region;
        }

        @Override
        public CreateAwsKmsMrkDiscoveryKeyringInput build() {
            if (Objects.isNull(this.kmsClient())) {
                throw new IllegalArgumentException("Missing value for required field `kmsClient`");
            }
            if (Objects.isNull(this.region())) {
                throw new IllegalArgumentException("Missing value for required field `region`");
            }
            return new CreateAwsKmsMrkDiscoveryKeyringInput(this);
        }
    }

    public static interface Builder {
        public Builder kmsClient(KmsClient var1);

        public KmsClient kmsClient();

        public Builder discoveryFilter(DiscoveryFilter var1);

        public DiscoveryFilter discoveryFilter();

        public Builder grantTokens(List<String> var1);

        public List<String> grantTokens();

        public Builder region(String var1);

        public String region();

        public CreateAwsKmsMrkDiscoveryKeyringInput build();
    }
}

