/*
 * Decompiled with CFR 0.152.
 */
package StructuredEncryptionFooter_Compile;

import BoundedInts_Compile.uint8;
import StructuredEncryptionFooter_Compile.RecipientTag;
import StructuredEncryptionFooter_Compile.Signature;
import StructuredEncryptionFooter_Compile.__default;
import StructuredEncryptionUtil_Compile.CanonCryptoItem;
import Wrappers_Compile.Option;
import Wrappers_Compile.Outcome;
import Wrappers_Compile.Result;
import dafny.DafnyMap;
import dafny.DafnySequence;
import dafny.Helpers;
import dafny.TypeDescriptor;
import java.util.Objects;
import software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.StructuredDataTerminal;
import software.amazon.cryptography.materialproviders.internaldafny.types.DecryptionMaterials;
import software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey;
import software.amazon.cryptography.primitives.internaldafny.AtomicPrimitivesClient;
import software.amazon.cryptography.primitives.internaldafny.types.DigestAlgorithm;
import software.amazon.cryptography.primitives.internaldafny.types.ECDSASignatureAlgorithm;
import software.amazon.cryptography.primitives.internaldafny.types.ECDSAVerifyInput;
import software.amazon.cryptography.primitives.internaldafny.types.Error;
import software.amazon.cryptography.primitives.internaldafny.types.HMacInput;

public class Footer {
    public DafnySequence<? extends DafnySequence<? extends Byte>> _tags;
    public Option<DafnySequence<? extends Byte>> _sig;
    private static final TypeDescriptor<Footer> _TYPE = TypeDescriptor.referenceWithInitializer(Footer.class, () -> Footer.Default());
    private static final Footer theDefault = Footer.create((DafnySequence<? extends DafnySequence<? extends Byte>>)DafnySequence.empty(RecipientTag._typeDescriptor()), (Option<DafnySequence<? extends Byte>>)Option.Default(Signature._typeDescriptor()));

    public Footer(DafnySequence<? extends DafnySequence<? extends Byte>> tags, Option<DafnySequence<? extends Byte>> sig) {
        this._tags = tags;
        this._sig = sig;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        Footer o = (Footer)other;
        return Objects.equals(this._tags, o._tags) && Objects.equals(this._sig, o._sig);
    }

    public int hashCode() {
        long hash = 5381L;
        hash = (hash << 5) + hash + 0L;
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._tags);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._sig);
        return (int)hash;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("StructuredEncryptionFooter.Footer.Footer");
        s.append("(");
        s.append(Helpers.toString(this._tags));
        s.append(", ");
        s.append(Helpers.toString(this._sig));
        s.append(")");
        return s.toString();
    }

    public static TypeDescriptor<Footer> _typeDescriptor() {
        return _TYPE;
    }

    public static Footer Default() {
        return theDefault;
    }

    public static Footer create(DafnySequence<? extends DafnySequence<? extends Byte>> tags, Option<DafnySequence<? extends Byte>> sig) {
        return new Footer(tags, sig);
    }

    public static Footer create_Footer(DafnySequence<? extends DafnySequence<? extends Byte>> tags, Option<DafnySequence<? extends Byte>> sig) {
        return Footer.create(tags, sig);
    }

    public boolean is_Footer() {
        return true;
    }

    public DafnySequence<? extends DafnySequence<? extends Byte>> dtor_tags() {
        return this._tags;
    }

    public Option<DafnySequence<? extends Byte>> dtor_sig() {
        return this._sig;
    }

    public DafnySequence<? extends Byte> serialize() {
        return DafnySequence.concatenate(__default.SerializeTags(this.dtor_tags()), __default.SerializeSig(this.dtor_sig()));
    }

    public StructuredDataTerminal makeTerminal() {
        return StructuredEncryptionUtil_Compile.__default.ValueToData(this.serialize(), StructuredEncryptionUtil_Compile.__default.BYTES__TYPE__ID());
    }

    public Result<Boolean, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> validate(AtomicPrimitivesClient client, DecryptionMaterials mat, DafnySequence<? extends EncryptedDataKey> edks, DafnySequence<? extends CanonCryptoItem> data, DafnySequence<? extends Byte> header) {
        Result ret = Result.Default((TypeDescriptor)TypeDescriptor.BOOLEAN, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (Object)false);
        Outcome _0_valueOrError0 = Outcome.Default(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor());
        _0_valueOrError0 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), ((long)edks.cardinalityInt() == (long)this.dtor_tags().cardinalityInt() ? 1 : 0) != 0, (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"There are a different number of recipient tags in the stored header than there are in the decryption materials.")));
        if (_0_valueOrError0.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            ret = _0_valueOrError0.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), TypeDescriptor.BOOLEAN);
            return ret;
        }
        Result<DafnySequence<? extends Byte>, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> _1_valueOrError1 = Result.Default((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (Object)DafnySequence.empty((TypeDescriptor)uint8._typeDescriptor()));
        Result<DafnySequence<? extends Byte>, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> _out0 = __default.CanonHash(data, header, (DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>>)mat.dtor_encryptionContext());
        _1_valueOrError1 = _out0;
        if (_1_valueOrError1.IsFailure(DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            ret = _1_valueOrError1.PropagateFailure(DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), TypeDescriptor.BOOLEAN);
            return ret;
        }
        DafnySequence _2_canonicalHash = (DafnySequence)_1_valueOrError1.Extract(DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor());
        HMacInput _3_input = HMacInput.create((DigestAlgorithm)mat.dtor_algorithmSuite().dtor_symmetricSignature().dtor_HMAC(), (DafnySequence)((DafnySequence)mat.dtor_symmetricSigningKey().dtor_value()), (DafnySequence)_2_canonicalHash);
        Result _4_hashR = client.HMac(_3_input);
        Result _5_valueOrError2 = Result.Default((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (Object)DafnySequence.empty((TypeDescriptor)uint8._typeDescriptor()));
        _5_valueOrError2 = _4_hashR.MapFailure(DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor()), Error._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), _6_e_boxed0 -> {
            Error _6_e = _6_e_boxed0;
            return software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error.create_AwsCryptographyPrimitives(_6_e);
        });
        if (_5_valueOrError2.IsFailure(DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            ret = _5_valueOrError2.PropagateFailure(DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), TypeDescriptor.BOOLEAN);
            return ret;
        }
        DafnySequence _7_hash = (DafnySequence)_5_valueOrError2.Extract(DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor());
        Outcome _8_valueOrError3 = Outcome.Default(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor());
        _8_valueOrError3 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), ((long)_7_hash.cardinalityInt() == 48L ? 1 : 0) != 0, (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Bad hash length")));
        if (_8_valueOrError3.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            ret = _8_valueOrError3.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), TypeDescriptor.BOOLEAN);
            return ret;
        }
        boolean _9_foundTag = false;
        long _hi0 = this.dtor_tags().cardinalityInt();
        long _10_i = 0L;
        while (Long.compareUnsigned(_10_i, _hi0) < 0) {
            if (StructuredEncryptionUtil_Compile.__default.ConstantTimeEquals((DafnySequence<? extends Byte>)_7_hash, (DafnySequence<? extends Byte>)((DafnySequence)this.dtor_tags().select(Helpers.unsignedToInt((long)_10_i))))) {
                _9_foundTag = true;
                break;
            }
            ++_10_i;
        }
        Outcome _11_valueOrError4 = Outcome.Default(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor());
        _11_valueOrError4 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (boolean)_9_foundTag, (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Signature of record does not match the signature computed when the record was encrypted.")));
        if (_11_valueOrError4.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            ret = _11_valueOrError4.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), TypeDescriptor.BOOLEAN);
            return ret;
        }
        Outcome _12_valueOrError5 = Outcome.Default(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor());
        _12_valueOrError5 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (this.dtor_sig().is_Some() == mat.dtor_algorithmSuite().dtor_signature().is_ECDSA() ? 1 : 0) != 0, (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Internal error. Signature both does and does not exist.")));
        if (_12_valueOrError5.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            ret = _12_valueOrError5.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), TypeDescriptor.BOOLEAN);
            return ret;
        }
        if (this.dtor_sig().is_Some()) {
            Result _out1;
            ECDSAVerifyInput _13_verInput = ECDSAVerifyInput.create((ECDSASignatureAlgorithm)mat.dtor_algorithmSuite().dtor_signature().dtor_ECDSA().dtor_curve(), (DafnySequence)((DafnySequence)mat.dtor_verificationKey().dtor_value()), (DafnySequence)_2_canonicalHash, (DafnySequence)((DafnySequence)this.dtor_sig().dtor_value()));
            Result _14_verR = _out1 = client.ECDSAVerify(_13_verInput);
            Result _15_valueOrError6 = Result.Default((TypeDescriptor)TypeDescriptor.BOOLEAN, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (Object)false);
            _15_valueOrError6 = _14_verR.MapFailure(TypeDescriptor.BOOLEAN, Error._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), _16_e_boxed0 -> {
                Error _16_e = _16_e_boxed0;
                return software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error.create_AwsCryptographyPrimitives(_16_e);
            });
            if (_15_valueOrError6.IsFailure(TypeDescriptor.BOOLEAN, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
                ret = _15_valueOrError6.PropagateFailure(TypeDescriptor.BOOLEAN, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), TypeDescriptor.BOOLEAN);
                return ret;
            }
            boolean _17_ver = (Boolean)_15_valueOrError6.Extract(TypeDescriptor.BOOLEAN, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor());
            Outcome _18_valueOrError7 = Outcome.Default(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor());
            _18_valueOrError7 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (boolean)_17_ver, (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Signature did not verify")));
            if (_18_valueOrError7.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
                ret = _18_valueOrError7.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), TypeDescriptor.BOOLEAN);
                return ret;
            }
        }
        ret = Result.create_Success((TypeDescriptor)TypeDescriptor.BOOLEAN, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (Object)true);
        return ret;
    }
}

