/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.processor.chunker;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import lombok.Generated;
import org.opensearch.neuralsearch.processor.chunker.Chunker;
import org.opensearch.neuralsearch.processor.chunker.ChunkerParameterParser;

public final class FixedCharLengthChunker
extends Chunker {
    public static final String ALGORITHM_NAME = "fixed_char_length";
    public static final String CHAR_LIMIT_FIELD = "char_limit";
    public static final String OVERLAP_RATE_FIELD = "overlap_rate";
    private static final int DEFAULT_CHAR_LIMIT = 2048;
    private static final double DEFAULT_OVERLAP_RATE = 0.0;
    private static final double OVERLAP_RATE_LOWER_BOUND = 0.0;
    private static final double OVERLAP_RATE_UPPER_BOUND = 0.5;
    private int charLimit;
    private double overlapRate;

    public FixedCharLengthChunker(Map<String, Object> parameters) {
        this.parse(parameters);
    }

    @Override
    public void parse(Map<String, Object> parameters) throws IllegalArgumentException {
        super.parse(parameters);
        this.charLimit = ChunkerParameterParser.parsePositiveIntegerWithDefault(parameters, CHAR_LIMIT_FIELD, 2048);
        double overlapRate = ChunkerParameterParser.parseDoubleWithDefault(parameters, OVERLAP_RATE_FIELD, 0.0);
        this.validateOverlapRate(overlapRate);
        this.overlapRate = overlapRate;
    }

    @Override
    public List<String> chunk(String content, Map<String, Object> runtimeParameters) {
        int runtimeMaxChunkLimit = ChunkerParameterParser.parseInteger(runtimeParameters, MAX_CHUNK_LIMIT_FIELD);
        int chunkStringCount = ChunkerParameterParser.parseInteger(runtimeParameters, CHUNK_STRING_COUNT_FIELD);
        ArrayList<String> chunkResult = new ArrayList<String>();
        int overlapCharNumber = (int)Math.floor((double)this.charLimit * this.overlapRate);
        int chunkInterval = this.charLimit - overlapCharNumber;
        for (int startCharIndex = 0; startCharIndex < content.length(); startCharIndex += chunkInterval) {
            int endPosition;
            if (Chunker.checkRunTimeMaxChunkLimit(chunkResult.size(), runtimeMaxChunkLimit, chunkStringCount)) {
                chunkResult.add(content.substring(startCharIndex));
                break;
            }
            if (startCharIndex + this.charLimit >= content.length()) {
                endPosition = content.length();
                chunkResult.add(content.substring(startCharIndex, endPosition));
                break;
            }
            endPosition = startCharIndex + this.charLimit;
            chunkResult.add(content.substring(startCharIndex, endPosition));
        }
        return chunkResult;
    }

    @Override
    public String getAlgorithmName() {
        return ALGORITHM_NAME;
    }

    @Override
    public void validate(Map<String, Object> parameters) {
        super.validate(parameters);
        ChunkerParameterParser.parsePositiveIntegerWithDefault(parameters, CHAR_LIMIT_FIELD, 2048);
        Double overlapRate = ChunkerParameterParser.parseDoubleWithDefault(parameters, OVERLAP_RATE_FIELD, 0.0);
        this.validateOverlapRate(overlapRate);
    }

    private void validateOverlapRate(Double overlapRate) {
        if (overlapRate < 0.0 || overlapRate > 0.5) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Parameter [%s] must be between %s and %s, but was %s", OVERLAP_RATE_FIELD, 0.0, 0.5, overlapRate));
        }
    }

    @Generated
    public FixedCharLengthChunker() {
    }
}

