/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.highlight;

import java.util.Locale;
import java.util.Map;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.core.common.text.Text;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.neuralsearch.highlight.single.SemanticHighlighterEngine;
import org.opensearch.neuralsearch.highlight.utils.HighlightExtractorUtils;
import org.opensearch.neuralsearch.stats.events.EventStatName;
import org.opensearch.neuralsearch.stats.events.EventStatsManager;
import org.opensearch.neuralsearch.util.NeuralSearchClusterUtil;
import org.opensearch.search.fetch.subphase.highlight.FieldHighlightContext;
import org.opensearch.search.fetch.subphase.highlight.HighlightField;
import org.opensearch.search.fetch.subphase.highlight.Highlighter;
import org.opensearch.search.pipeline.SearchPipelineService;

public class SemanticHighlighter
implements Highlighter {
    @Generated
    private static final Logger log = LogManager.getLogger(SemanticHighlighter.class);
    private SemanticHighlighterEngine semanticHighlighterEngine;

    public void initialize(SemanticHighlighterEngine semanticHighlighterEngine) {
        if (this.semanticHighlighterEngine != null) {
            throw new IllegalStateException("SemanticHighlighterEngine has already been initialized. Multiple initializations are not permitted.");
        }
        this.semanticHighlighterEngine = semanticHighlighterEngine;
    }

    public boolean canHighlight(MappedFieldType fieldType) {
        return true;
    }

    public HighlightField highlight(FieldHighlightContext fieldContext) {
        String[] postTags;
        Map options = fieldContext.field.fieldOptions().options();
        boolean batchInference = this.extractBatchInference(options);
        if (batchInference) {
            if (!this.isSystemProcessorEnabled()) {
                String errorMessage = String.format(Locale.ROOT, "Batch inference for semantic highlighting is disabled. Enable it by adding '%s' to the '%s' cluster setting.", "semantic-highlighter", SearchPipelineService.ENABLED_SYSTEM_GENERATED_FACTORIES_SETTING.getKey());
                log.error("[SEMANTIC_HIGHLIGHT] BATCH MODE ERROR - {}", (Object)errorMessage);
                throw new IllegalArgumentException(errorMessage);
            }
            return null;
        }
        if (this.semanticHighlighterEngine == null) {
            throw new IllegalStateException("SemanticHighlighter has not been initialized. This can happen when the neural-search plugin is not fully initialized on this node. Please ensure the plugin is properly installed and configured.");
        }
        EventStatsManager.increment(EventStatName.SEMANTIC_HIGHLIGHTING_REQUEST_COUNT);
        String fieldText = HighlightExtractorUtils.getFieldText(fieldContext);
        String modelId = HighlightExtractorUtils.getModelId(fieldContext.field.fieldOptions().options());
        String originalQueryText = this.semanticHighlighterEngine.extractOriginalQuery(fieldContext.query, fieldContext.fieldName);
        if (originalQueryText == null || originalQueryText.isEmpty()) {
            log.warn("No query text found for field {}", (Object)fieldContext.fieldName);
            return null;
        }
        String[] preTags = fieldContext.field.fieldOptions().preTags();
        String highlightedResponse = this.semanticHighlighterEngine.getHighlightedSentences(modelId, originalQueryText, fieldText, preTags[0], (postTags = fieldContext.field.fieldOptions().postTags())[0]);
        if (highlightedResponse == null || highlightedResponse.isEmpty()) {
            log.warn("No highlighted text returned for field: {}, returning null", (Object)fieldContext.fieldName);
            return null;
        }
        Text[] fragments = new Text[]{new Text(highlightedResponse)};
        return new HighlightField(fieldContext.fieldName, fragments);
    }

    private boolean extractBatchInference(Map<String, Object> options) {
        return HighlightExtractorUtils.extractBatchInferenceFromOptions(options);
    }

    private boolean isSystemProcessorEnabled() {
        return NeuralSearchClusterUtil.instance().isSystemGeneratedFactoryEnabled("semantic-highlighter");
    }
}

