/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.ml;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.ml.Message;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class GetAllMessagesResponse
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, GetAllMessagesResponse> {
    @Nonnull
    private final List<Message> messages;
    @Nullable
    private final Integer nextToken;
    public static final JsonpDeserializer<GetAllMessagesResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GetAllMessagesResponse::setupGetAllMessagesResponseDeserializer);

    private GetAllMessagesResponse(Builder builder) {
        this.messages = ApiTypeHelper.unmodifiableRequired(builder.messages, (Object)this, "messages");
        this.nextToken = builder.nextToken;
    }

    public static GetAllMessagesResponse of(Function<Builder, ObjectBuilder<GetAllMessagesResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final List<Message> messages() {
        return this.messages;
    }

    @Nullable
    public final Integer nextToken() {
        return this.nextToken;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("messages");
        generator.writeStartArray();
        for (Message item0 : this.messages) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
        if (this.nextToken != null) {
            generator.writeKey("next_token");
            generator.write(this.nextToken.intValue());
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupGetAllMessagesResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::messages, JsonpDeserializer.arrayDeserializer(Message._DESERIALIZER), "messages");
        op.add(Builder::nextToken, JsonpDeserializer.integerDeserializer(), "next_token");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.messages.hashCode();
        result = 31 * result + Objects.hashCode(this.nextToken);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetAllMessagesResponse other = (GetAllMessagesResponse)o;
        return this.messages.equals(other.messages) && Objects.equals(this.nextToken, other.nextToken);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, GetAllMessagesResponse> {
        private List<Message> messages;
        @Nullable
        private Integer nextToken;

        public Builder() {
        }

        private Builder(GetAllMessagesResponse o) {
            this.messages = Builder._listCopy(o.messages);
            this.nextToken = o.nextToken;
        }

        private Builder(Builder o) {
            this.messages = Builder._listCopy(o.messages);
            this.nextToken = o.nextToken;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder messages(List<Message> list) {
            this.messages = Builder._listAddAll(this.messages, list);
            return this;
        }

        @Nonnull
        public final Builder messages(Message value, Message ... values) {
            this.messages = Builder._listAdd(this.messages, value, values);
            return this;
        }

        @Nonnull
        public final Builder messages(Function<Message.Builder, ObjectBuilder<Message>> fn) {
            return this.messages(fn.apply(new Message.Builder()).build(), new Message[0]);
        }

        @Nonnull
        public final Builder nextToken(@Nullable Integer value) {
            this.nextToken = value;
            return this;
        }

        @Override
        @Nonnull
        public GetAllMessagesResponse build() {
            this._checkSingleUse();
            return new GetAllMessagesResponse(this);
        }
    }
}

