/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.transport;

import java.time.Clock;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.unit.TimeValue;

public class BackPressureRouting {
    private static final Logger LOG = LogManager.getLogger(BackPressureRouting.class);
    private final String nodeId;
    private final Clock clock;
    private int maxRetryForUnresponsiveNode;
    private TimeValue mutePeriod;
    private AtomicInteger backpressureCounter;
    private long lastMuteTime;

    public BackPressureRouting(String nodeId, Clock clock, int maxRetryForUnresponsiveNode, TimeValue mutePeriod) {
        this.nodeId = nodeId;
        this.clock = clock;
        this.backpressureCounter = new AtomicInteger(0);
        this.maxRetryForUnresponsiveNode = maxRetryForUnresponsiveNode;
        this.mutePeriod = mutePeriod;
        this.lastMuteTime = 0L;
    }

    public void addPressure() {
        int currentRetry = this.backpressureCounter.incrementAndGet();
        LOG.info("{} has been unresponsive for {} times", (Object)this.nodeId, (Object)currentRetry);
        if (currentRetry > this.maxRetryForUnresponsiveNode) {
            this.mute();
        }
    }

    public boolean isMuted() {
        return this.clock.millis() - this.lastMuteTime <= this.mutePeriod.getMillis();
    }

    private void mute() {
        this.lastMuteTime = this.clock.millis();
    }

    public int getMaxRetryForUnresponsiveNode() {
        return this.maxRetryForUnresponsiveNode;
    }

    public void setMaxRetryForUnresponsiveNode(int maxRetryForUnresponsiveNode) {
        this.maxRetryForUnresponsiveNode = maxRetryForUnresponsiveNode;
    }

    public TimeValue getMutePeriod() {
        return this.mutePeriod;
    }

    public void setMutePeriod(TimeValue mutePeriod) {
        this.mutePeriod = mutePeriod;
    }
}

