/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.ast.expression;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.opensearch.sql.ast.expression.Field;
import org.opensearch.sql.ast.expression.SearchExpression;
import org.opensearch.sql.ast.expression.SearchLiteral;
import org.opensearch.sql.ast.expression.UnresolvedExpression;
import org.opensearch.sql.utils.QueryStringUtils;

public class SearchIn
extends SearchExpression {
    private final Field field;
    private final List<SearchLiteral> values;

    @Override
    public String toQueryString() {
        String fieldName = QueryStringUtils.escapeFieldName(this.field.getField().toString());
        String valueList = this.values.stream().map(SearchLiteral::toQueryString).collect(Collectors.joining(" OR "));
        return fieldName + ":( " + valueList + " )";
    }

    @Override
    public String toAnonymizedString() {
        return "identifier IN ***";
    }

    public List<? extends UnresolvedExpression> getChild() {
        ArrayList<UnresolvedExpression> children = new ArrayList<UnresolvedExpression>();
        children.add(this.field);
        children.addAll(this.values);
        return children;
    }

    @Generated
    public Field getField() {
        return this.field;
    }

    @Generated
    public List<SearchLiteral> getValues() {
        return this.values;
    }

    @Generated
    public SearchIn(Field field, List<SearchLiteral> values) {
        this.field = field;
        this.values = values;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SearchIn)) {
            return false;
        }
        SearchIn other = (SearchIn)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Field this$field = this.getField();
        Field other$field = other.getField();
        if (this$field == null ? other$field != null : !((Object)this$field).equals(other$field)) {
            return false;
        }
        List<SearchLiteral> this$values = this.getValues();
        List<SearchLiteral> other$values = other.getValues();
        return !(this$values == null ? other$values != null : !((Object)this$values).equals(other$values));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SearchIn;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Field $field = this.getField();
        result = result * 59 + ($field == null ? 43 : ((Object)$field).hashCode());
        List<SearchLiteral> $values = this.getValues();
        result = result * 59 + ($values == null ? 43 : ((Object)$values).hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "SearchIn(field=" + String.valueOf(this.getField()) + ", values=" + String.valueOf(this.getValues()) + ")";
    }
}

