/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.threadpool;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ThreadFactory;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.SizeValue;
import org.opensearch.common.util.concurrent.OpenSearchExecutors;
import org.opensearch.common.util.concurrent.OpenSearchThreadPoolExecutor;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.node.Node;
import org.opensearch.threadpool.ExecutorBuilder;
import org.opensearch.threadpool.ThreadPool;

public final class FixedExecutorBuilder
extends ExecutorBuilder<FixedExecutorSettings> {
    private final Setting<Integer> sizeSetting;
    private final Setting<Integer> queueSizeSetting;

    FixedExecutorBuilder(Settings settings, String name, int size, int queueSize) {
        this(settings, name, size, queueSize, false);
    }

    FixedExecutorBuilder(Settings settings, String name, int size, int queueSize, boolean deprecated) {
        this(settings, name, size, queueSize, "thread_pool." + name, deprecated);
    }

    public FixedExecutorBuilder(Settings settings, String name, int size, int queueSize, String prefix) {
        this(settings, name, size, queueSize, prefix, false);
    }

    public FixedExecutorBuilder(Settings settings, String name, int size, int queueSize, String prefix, boolean deprecated) {
        super(name);
        String sizeKey = FixedExecutorBuilder.settingsKey(prefix, "size");
        Setting.Property[] properties = deprecated ? new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Deprecated} : new Setting.Property[]{Setting.Property.NodeScope};
        this.sizeSetting = new Setting<Integer>(sizeKey, s -> Integer.toString(size), s -> Setting.parseInt(s, 1, this.applyHardSizeLimit(settings, name), sizeKey), properties);
        String queueSizeKey = FixedExecutorBuilder.settingsKey(prefix, "queue_size");
        this.queueSizeSetting = Setting.intSetting(queueSizeKey, queueSize, properties);
    }

    @Override
    public List<Setting<?>> getRegisteredSettings() {
        return Arrays.asList(this.sizeSetting, this.queueSizeSetting);
    }

    @Override
    FixedExecutorSettings getSettings(Settings settings) {
        String nodeName = Node.NODE_NAME_SETTING.get(settings);
        int size = this.sizeSetting.get(settings);
        int queueSize = this.queueSizeSetting.get(settings);
        return new FixedExecutorSettings(nodeName, size, queueSize);
    }

    @Override
    ThreadPool.ExecutorHolder build(FixedExecutorSettings settings, ThreadContext threadContext) {
        int size = settings.size;
        int queueSize = settings.queueSize;
        ThreadFactory threadFactory = OpenSearchExecutors.daemonThreadFactory(OpenSearchExecutors.threadName(settings.nodeName, this.name()));
        OpenSearchThreadPoolExecutor executor = OpenSearchExecutors.newFixed(settings.nodeName + "/" + this.name(), size, queueSize, threadFactory, threadContext);
        ThreadPool.Info info = new ThreadPool.Info(this.name(), ThreadPool.ThreadPoolType.FIXED, size, size, null, queueSize < 0 ? null : new SizeValue(queueSize));
        return new ThreadPool.ExecutorHolder(executor, info);
    }

    @Override
    String formatInfo(ThreadPool.Info info) {
        return String.format(Locale.ROOT, "name [%s], size [%d], queue size [%s]", info.getName(), info.getMax(), info.getQueueSize() == null ? "unbounded" : info.getQueueSize());
    }

    static class FixedExecutorSettings
    extends ExecutorBuilder.ExecutorSettings {
        private final int size;
        private final int queueSize;

        FixedExecutorSettings(String nodeName, int size, int queueSize) {
            super(nodeName);
            this.size = size;
            this.queueSize = queueSize;
        }
    }
}

