/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.internal.hppc;

import org.apache.lucene.internal.hppc.BitMixer;
import org.apache.lucene.internal.hppc.FloatArrayList;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.RamUsageEstimator;

public class MaxSizedFloatArrayList
extends FloatArrayList {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(MaxSizedFloatArrayList.class);
    final int maxSize;

    public MaxSizedFloatArrayList(int maxSize) {
        this(maxSize, 4);
    }

    public MaxSizedFloatArrayList(int maxSize, int expectedElements) {
        super(expectedElements);
        assert (expectedElements <= maxSize) : "expectedElements (" + expectedElements + ") must be <= maxSize (" + maxSize + ")";
        this.maxSize = maxSize;
    }

    public MaxSizedFloatArrayList(MaxSizedFloatArrayList list) {
        super(list.size());
        this.maxSize = list.maxSize;
        this.addAll(list);
    }

    @Override
    protected void ensureBufferSpace(int expectedAdditions) {
        if (this.elementsCount + expectedAdditions > this.maxSize) {
            throw new IllegalStateException("Cannot grow beyond maxSize: " + this.maxSize);
        }
        if (this.elementsCount + expectedAdditions > this.buffer.length) {
            this.buffer = ArrayUtil.growInRange(this.buffer, this.elementsCount + expectedAdditions, this.maxSize);
        }
    }

    @Override
    public int hashCode() {
        int h = 1;
        int max = this.elementsCount;
        h = 31 * h + this.maxSize;
        for (int i = 0; i < max; ++i) {
            h = 31 * h + BitMixer.mix(this.buffer[i]);
        }
        return h;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MaxSizedFloatArrayList other = (MaxSizedFloatArrayList)obj;
        return this.maxSize == other.maxSize && super.equals(obj);
    }

    @Override
    public long ramBytesUsed() {
        return BASE_RAM_BYTES_USED + RamUsageEstimator.sizeOf(this.buffer);
    }
}

