/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.join;

import java.io.IOException;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.search.SimpleCollector;

abstract class DocValuesTermsCollector<DV>
extends SimpleCollector {
    protected DV docValues;
    private final Function<DV> docValuesCall;

    public DocValuesTermsCollector(Function<DV> docValuesCall) {
        this.docValuesCall = docValuesCall;
    }

    protected final void doSetNextReader(LeafReaderContext context) throws IOException {
        this.docValues = this.docValuesCall.apply(context.reader());
    }

    static Function<SortedDocValues> sortedDocValues(String field) {
        return ctx -> DocValues.getSorted((LeafReader)ctx, (String)field);
    }

    static Function<SortedSetDocValues> sortedSetDocValues(String field) {
        return ctx -> DocValues.getSortedSet((LeafReader)ctx, (String)field);
    }

    @FunctionalInterface
    static interface Function<R> {
        public R apply(LeafReader var1) throws IOException;
    }
}

