/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.blobstore;

import java.io.Closeable;
import java.util.Collections;
import java.util.Map;
import org.opensearch.cluster.metadata.RepositoryMetadata;
import org.opensearch.common.blobstore.BlobContainer;
import org.opensearch.common.blobstore.BlobPath;

public interface BlobStore
extends Closeable {
    public BlobContainer blobContainer(BlobPath var1);

    default public Map<String, Long> stats() {
        return Collections.emptyMap();
    }

    default public Map<Metric, Map<String, Long>> extendedStats() {
        return Collections.emptyMap();
    }

    default public void reload(RepositoryMetadata repositoryMetadata) {
    }

    default public boolean isBlobMetadataEnabled() {
        return false;
    }

    public static enum Metric {
        GENERIC_STATS("generic_stats"),
        REQUEST_SUCCESS("request_success_total"),
        REQUEST_FAILURE("request_failures_total"),
        REQUEST_LATENCY("request_time_in_millis"),
        RETRY_COUNT("request_retry_count_total");

        private String metricName;

        private Metric(String name) {
            this.metricName = name;
        }

        public String metricName() {
            return this.metricName;
        }
    }
}

