/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commands;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.externalProcessAuthHelper.AuthenticationGate;
import com.intellij.ide.trustedProjects.TrustedProjects;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcsUtil.VcsFileUtil;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitContentRevision;
import git4idea.GitUtil;
import git4idea.branch.GitRebaseParams;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitHandlerInputProcessorUtil;
import git4idea.commands.GitImplBase;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitLineHandlerListener;
import git4idea.commands.GitObjectType;
import git4idea.commands.GitRebaseCommandResult;
import git4idea.commands.GitShallowCloneOptions;
import git4idea.config.GitExecutable;
import git4idea.config.GitExecutableManager;
import git4idea.config.GitVersionSpecialty;
import git4idea.push.GitPushParams;
import git4idea.rebase.GitHandlerRebaseEditorManager;
import git4idea.rebase.GitRebaseEditorHandler;
import git4idea.rebase.GitRebaseResumeMode;
import git4idea.rebase.GitRebaseUtils;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.reset.GitResetMode;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class GitImpl
extends GitImplBase {
    private static final Logger LOG = Logger.getInstance(Git.class);
    public static final List<String> REBASE_CONFIG_PARAMS = Collections.singletonList("%s=%s".formatted("core.commentChar", "\u0001"));

    @Override
    @NotNull
    public GitCommandResult init(@NotNull Project project, @NotNull VirtualFile root, GitLineHandlerListener ... listeners) {
        if (project == null) {
            GitImpl.$$$reportNull$$$0(0);
        }
        if (root == null) {
            GitImpl.$$$reportNull$$$0(1);
        }
        if (listeners == null) {
            GitImpl.$$$reportNull$$$0(2);
        }
        GitLineHandler h = new GitLineHandler(project, root, GitCommand.INIT);
        GitImpl.addListeners(h, listeners);
        h.setSilent(false);
        h.setStdoutSuppressed(false);
        GitCommandResult gitCommandResult = this.runCommand(h);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(3);
        }
        return gitCommandResult;
    }

    @Override
    public Set<FilePath> ignoredFilePaths(@NotNull Project project, @NotNull VirtualFile root, @Nullable Collection<? extends FilePath> paths) throws VcsException {
        if (project == null) {
            GitImpl.$$$reportNull$$$0(4);
        }
        if (root == null) {
            GitImpl.$$$reportNull$$$0(5);
        }
        HashSet<FilePath> ignoredFiles = new HashSet<FilePath>();
        if (paths == null) {
            ignoredFiles.addAll(this.ignoredFilePathsNoChunk(project, root, null));
        } else {
            for (List relativePaths : VcsFileUtil.chunkPaths((VirtualFile)root, paths)) {
                ignoredFiles.addAll(this.ignoredFilePathsNoChunk(project, root, relativePaths));
            }
        }
        return ignoredFiles;
    }

    @Override
    public Set<FilePath> ignoredFilePathsNoChunk(@NotNull Project project, @NotNull VirtualFile root, @Nullable List<String> paths) throws VcsException {
        if (project == null) {
            GitImpl.$$$reportNull$$$0(6);
        }
        if (root == null) {
            GitImpl.$$$reportNull$$$0(7);
        }
        GitLineHandler h = new GitLineHandler(project, root, GitCommand.STATUS);
        h.setSilent(true);
        h.addParameters("--ignored", "--porcelain", "-z");
        if (paths != null) {
            h.addParameters(paths);
        }
        h.endOptions();
        String output2 = this.runCommand(h).getOutputOrThrow(new int[0]);
        return GitImpl.parseFiles(root, output2, "!! ");
    }

    @NotNull
    private static Set<FilePath> parseFiles(@NotNull VirtualFile root, @Nullable String output2, @NotNull String fileStatusPrefix) throws VcsException {
        if (root == null) {
            GitImpl.$$$reportNull$$$0(8);
        }
        if (fileStatusPrefix == null) {
            GitImpl.$$$reportNull$$$0(9);
        }
        if (StringUtil.isEmptyOrSpaces((String)output2)) {
            Set<FilePath> set = Collections.emptySet();
            if (set == null) {
                GitImpl.$$$reportNull$$$0(10);
            }
            return set;
        }
        HashSet<FilePath> files = new HashSet<FilePath>();
        for (String relPath : output2.split("\u0000")) {
            ProgressManager.checkCanceled();
            if (!relPath.startsWith(fileStatusPrefix)) continue;
            String relativePath = relPath.substring(fileStatusPrefix.length());
            files.add(GitContentRevision.createPath(root, relativePath, relativePath.endsWith("/")));
        }
        HashSet<FilePath> hashSet = files;
        if (hashSet == null) {
            GitImpl.$$$reportNull$$$0(11);
        }
        return hashSet;
    }

    @Override
    public @Unmodifiable @NotNull Set<VirtualFile> untrackedFiles(@NotNull Project project, @NotNull VirtualFile root, @Nullable Collection<? extends VirtualFile> files) throws VcsException {
        if (project == null) {
            GitImpl.$$$reportNull$$$0(12);
        }
        if (root == null) {
            GitImpl.$$$reportNull$$$0(13);
        }
        Set set = ContainerUtil.map2SetNotNull(this.untrackedFilePaths(project, root, files != null ? ContainerUtil.mapNotNull(files, VcsUtil::getFilePath) : null), FilePath::getVirtualFile);
        if (set == null) {
            GitImpl.$$$reportNull$$$0(14);
        }
        return set;
    }

    @Override
    public Set<FilePath> untrackedFilePaths(@NotNull Project project, @NotNull VirtualFile root, @Nullable Collection<FilePath> files) throws VcsException {
        if (project == null) {
            GitImpl.$$$reportNull$$$0(15);
        }
        if (root == null) {
            GitImpl.$$$reportNull$$$0(16);
        }
        HashSet<FilePath> untrackedFiles = new HashSet<FilePath>();
        if (files == null) {
            untrackedFiles.addAll(this.untrackedFilePathsNoChunk(project, root, null));
        } else {
            for (List relativePaths : VcsFileUtil.chunkPaths((VirtualFile)root, files)) {
                untrackedFiles.addAll(this.untrackedFilePathsNoChunk(project, root, relativePaths));
            }
        }
        return untrackedFiles;
    }

    @Override
    @NotNull
    public Collection<FilePath> untrackedFilePathsNoChunk(@NotNull Project project, @NotNull VirtualFile root, @Nullable List<String> relativePaths) throws VcsException {
        if (project == null) {
            GitImpl.$$$reportNull$$$0(17);
        }
        if (root == null) {
            GitImpl.$$$reportNull$$$0(18);
        }
        GitLineHandler h = new GitLineHandler(project, root, GitCommand.LS_FILES);
        h.setSilent(true);
        h.addParameters("--exclude-standard", "--others", "-z");
        h.endOptions();
        if (relativePaths != null) {
            h.addParameters(relativePaths);
        }
        String output2 = this.runCommand(h).getOutputOrThrow(new int[0]);
        return GitImpl.parseFiles(root, output2, "");
    }

    @Override
    @NotNull
    public GitCommandResult clone(@Nullable Project project, @NotNull File parentDirectory, @NotNull String url, @NotNull String clonedDirectoryName, @Nullable GitShallowCloneOptions shallowCloneOptions, GitLineHandlerListener ... listeners) {
        if (parentDirectory == null) {
            GitImpl.$$$reportNull$$$0(19);
        }
        if (url == null) {
            GitImpl.$$$reportNull$$$0(20);
        }
        if (clonedDirectoryName == null) {
            GitImpl.$$$reportNull$$$0(21);
        }
        if (listeners == null) {
            GitImpl.$$$reportNull$$$0(22);
        }
        GitCommandResult gitCommandResult = this.runCommand((Computable<? extends GitLineHandler>)((Computable)() -> {
            Integer depth;
            Project defaultProject = ProjectManager.getInstance().getDefaultProject();
            GitExecutable executable = GitExecutableManager.getInstance().getExecutable(defaultProject, parentDirectory.toPath());
            List<String> configParameters = SystemInfo.isWindows ? List.of("core.longpaths=true") : Collections.emptyList();
            GitLineHandler handler = new GitLineHandler(defaultProject, parentDirectory, executable, GitCommand.CLONE, configParameters);
            handler.setSilent(false);
            handler.setStderrSuppressed(false);
            handler.setUrl(url);
            handler.addParameters("--progress");
            if (GitVersionSpecialty.CLONE_RECURSE_SUBMODULES.existsIn(project, handler.getExecutable()) && AdvancedSettings.getBoolean((String)"git.clone.recurse.submodules")) {
                handler.addParameters("--recurse-submodules");
            }
            if (shallowCloneOptions != null && (depth = shallowCloneOptions.getDepth()) != null) {
                handler.addParameters("--depth=" + depth);
            }
            handler.addParameters(url);
            handler.endOptions();
            handler.addParameters(clonedDirectoryName);
            GitImpl.addListeners(handler, listeners);
            return handler;
        }));
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(23);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult config(@NotNull GitRepository repository2, String ... params) {
        if (repository2 == null) {
            GitImpl.$$$reportNull$$$0(24);
        }
        GitLineHandler h = new GitLineHandler(repository2.getProject(), repository2.getRoot(), GitCommand.CONFIG);
        h.addParameters(params);
        GitCommandResult gitCommandResult = this.runCommand(h);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(25);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult diff(@NotNull GitRepository repository2, @NotNull List<String> parameters, @NotNull String range) {
        if (repository2 == null) {
            GitImpl.$$$reportNull$$$0(26);
        }
        if (parameters == null) {
            GitImpl.$$$reportNull$$$0(27);
        }
        if (range == null) {
            GitImpl.$$$reportNull$$$0(28);
        }
        GitLineHandler diff = new GitLineHandler(repository2.getProject(), repository2.getRoot(), GitCommand.DIFF);
        diff.addParameters(parameters);
        diff.addParameters(range);
        diff.setStdoutSuppressed(true);
        diff.setStderrSuppressed(true);
        diff.setSilent(true);
        GitCommandResult gitCommandResult = this.runCommand(diff);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(29);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult checkAttr(@NotNull GitRepository repository2, @NotNull Collection<String> attributes, @NotNull Collection<? extends VirtualFile> files) {
        if (repository2 == null) {
            GitImpl.$$$reportNull$$$0(30);
        }
        if (attributes == null) {
            GitImpl.$$$reportNull$$$0(31);
        }
        if (files == null) {
            GitImpl.$$$reportNull$$$0(32);
        }
        List relativeFilePaths = ContainerUtil.map(files, file -> VcsFileUtil.relativePath((VirtualFile)repository2.getRoot(), (VirtualFile)file));
        GitLineHandler h = new GitLineHandler(repository2.getProject(), repository2.getRoot(), GitCommand.CHECK_ATTR);
        h.addParameters("--stdin");
        h.addParameters(new ArrayList<String>(attributes));
        h.endOptions();
        h.setInputProcessor(GitHandlerInputProcessorUtil.writeLines(relativeFilePaths, h.getCharset()));
        GitCommandResult gitCommandResult = this.runCommand(h);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(33);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult stashSave(@NotNull GitRepository repository2, @NotNull String message) {
        if (repository2 == null) {
            GitImpl.$$$reportNull$$$0(34);
        }
        if (message == null) {
            GitImpl.$$$reportNull$$$0(35);
        }
        GitLineHandler h = new GitLineHandler(repository2.getProject(), repository2.getRoot(), GitCommand.STASH);
        h.addParameters("push");
        h.addParameters("-m");
        h.addParameters(message);
        GitCommandResult gitCommandResult = this.runCommand(h);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(36);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult stashPop(@NotNull GitRepository repository2, GitLineHandlerListener ... listeners) {
        if (repository2 == null) {
            GitImpl.$$$reportNull$$$0(37);
        }
        if (listeners == null) {
            GitImpl.$$$reportNull$$$0(38);
        }
        GitLineHandler handler = new GitLineHandler(repository2.getProject(), repository2.getRoot(), GitCommand.STASH);
        handler.addParameters("pop");
        GitImpl.addListeners(handler, listeners);
        GitCommandResult gitCommandResult = this.runCommand(handler);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(39);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult merge(@NotNull GitRepository repository2, @NotNull String branchToMerge, @Nullable List<String> additionalParams, GitLineHandlerListener ... listeners) {
        if (repository2 == null) {
            GitImpl.$$$reportNull$$$0(40);
        }
        if (branchToMerge == null) {
            GitImpl.$$$reportNull$$$0(41);
        }
        if (listeners == null) {
            GitImpl.$$$reportNull$$$0(42);
        }
        GitLineHandler mergeHandler = new GitLineHandler(repository2.getProject(), repository2.getRoot(), GitCommand.MERGE);
        mergeHandler.setSilent(false);
        mergeHandler.addParameters(branchToMerge);
        if (additionalParams != null) {
            mergeHandler.addParameters(additionalParams);
        }
        GitImpl.addListeners(mergeHandler, listeners);
        GitCommandResult gitCommandResult = this.runCommand(mergeHandler);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(43);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult checkout(@NotNull GitRepository repository2, @NotNull String reference, @Nullable String newBranch, boolean force, boolean detach, GitLineHandlerListener ... listeners) {
        if (repository2 == null) {
            GitImpl.$$$reportNull$$$0(44);
        }
        if (reference == null) {
            GitImpl.$$$reportNull$$$0(45);
        }
        if (listeners == null) {
            GitImpl.$$$reportNull$$$0(46);
        }
        GitCommandResult gitCommandResult = this.checkout(repository2, reference, newBranch, force, detach, false, listeners);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(47);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult checkout(@NotNull GitRepository repository2, @NotNull String reference, @Nullable String newBranch, boolean force, boolean detach, boolean withReset, GitLineHandlerListener ... listeners) {
        if (repository2 == null) {
            GitImpl.$$$reportNull$$$0(48);
        }
        if (reference == null) {
            GitImpl.$$$reportNull$$$0(49);
        }
        if (listeners == null) {
            GitImpl.$$$reportNull$$$0(50);
        }
        GitLineHandler h = new GitLineHandler(repository2.getProject(), repository2.getRoot(), GitCommand.CHECKOUT);
        h.setSilent(false);
        h.setStdoutSuppressed(false);
        if (force) {
            h.addParameters("--force");
        }
        if (newBranch == null) {
            h.addParameters(new String[]{detach ? reference + "^0" : reference});
        } else {
            h.addParameters(withReset ? "-B" : "-b", newBranch, reference);
        }
        h.endOptions();
        GitImpl.addListeners(h, listeners);
        GitCommandResult gitCommandResult = this.runCommand(h);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(51);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult checkoutNewBranch(@NotNull GitRepository repository2, @NotNull String branchName, @Nullable GitLineHandlerListener listener2) {
        if (repository2 == null) {
            GitImpl.$$$reportNull$$$0(52);
        }
        if (branchName == null) {
            GitImpl.$$$reportNull$$$0(53);
        }
        GitLineHandler h = new GitLineHandler(repository2.getProject(), repository2.getRoot(), GitCommand.CHECKOUT);
        h.setSilent(false);
        h.setStdoutSuppressed(false);
        h.addParameters("-b");
        h.addParameters(branchName);
        if (listener2 != null) {
            h.addLineListener(listener2);
        }
        GitCommandResult gitCommandResult = this.runCommand(h);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(54);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult createNewTag(@NotNull GitRepository repository2, @NotNull String tagName, @Nullable GitLineHandlerListener listener2, @NotNull String reference) {
        if (repository2 == null) {
            GitImpl.$$$reportNull$$$0(55);
        }
        if (tagName == null) {
            GitImpl.$$$reportNull$$$0(56);
        }
        if (reference == null) {
            GitImpl.$$$reportNull$$$0(57);
        }
        GitLineHandler h = new GitLineHandler(repository2.getProject(), repository2.getRoot(), GitCommand.TAG);
        h.setSilent(false);
        h.addParameters(tagName);
        if (!reference.isEmpty()) {
            h.addParameters(reference);
        }
        if (listener2 != null) {
            h.addLineListener(listener2);
        }
        GitCommandResult gitCommandResult = this.runCommand(h);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(58);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult deleteTag(@NotNull GitRepository repository2, @NotNull String tagName, GitLineHandlerListener ... listeners) {
        if (repository2 == null) {
            GitImpl.$$$reportNull$$$0(59);
        }
        if (tagName == null) {
            GitImpl.$$$reportNull$$$0(60);
        }
        if (listeners == null) {
            GitImpl.$$$reportNull$$$0(61);
        }
        GitLineHandler h = new GitLineHandler(repository2.getProject(), repository2.getRoot(), GitCommand.TAG);
        h.setSilent(false);
        h.addParameters("-d");
        h.addParameters(tagName);
        GitImpl.addListeners(h, listeners);
        GitCommandResult gitCommandResult = this.runCommand(h);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(62);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult branchDelete(@NotNull GitRepository repository2, @NotNull String branchName, boolean force, GitLineHandlerListener ... listeners) {
        if (repository2 == null) {
            GitImpl.$$$reportNull$$$0(63);
        }
        if (branchName == null) {
            GitImpl.$$$reportNull$$$0(64);
        }
        if (listeners == null) {
            GitImpl.$$$reportNull$$$0(65);
        }
        GitLineHandler h = new GitLineHandler(repository2.getProject(), repository2.getRoot(), GitCommand.BRANCH);
        h.setSilent(false);
        h.setStdoutSuppressed(false);
        h.addParameters(force ? "-D" : "-d");
        h.addParameters(branchName);
        GitImpl.addListeners(h, listeners);
        GitCommandResult gitCommandResult = this.runCommand(h);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(66);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult branchCreate(@NotNull GitRepository repository2, @NotNull String branchName, @NotNull String startPoint) {
        if (repository2 == null) {
            GitImpl.$$$reportNull$$$0(67);
        }
        if (branchName == null) {
            GitImpl.$$$reportNull$$$0(68);
        }
        if (startPoint == null) {
            GitImpl.$$$reportNull$$$0(69);
        }
        GitCommandResult gitCommandResult = this.branchCreate(repository2, branchName, startPoint, false);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(70);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult branchCreate(@NotNull GitRepository repository2, @NotNull String branchName, @NotNull String startPoint, boolean force) {
        if (repository2 == null) {
            GitImpl.$$$reportNull$$$0(71);
        }
        if (branchName == null) {
            GitImpl.$$$reportNull$$$0(72);
        }
        if (startPoint == null) {
            GitImpl.$$$reportNull$$$0(73);
        }
        GitLineHandler h = new GitLineHandler(repository2.getProject(), repository2.getRoot(), GitCommand.BRANCH);
        h.setSilent(false);
        h.setStdoutSuppressed(false);
        if (force) {
            h.addParameters("-f");
        }
        h.addParameters(branchName);
        h.addParameters(startPoint);
        GitCommandResult gitCommandResult = this.runCommand(h);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(74);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult setUpstream(@NotNull GitRepository repository2, @NotNull String upstreamBranchName, @NotNull String branchName) {
        if (repository2 == null) {
            GitImpl.$$$reportNull$$$0(75);
        }
        if (upstreamBranchName == null) {
            GitImpl.$$$reportNull$$$0(76);
        }
        if (branchName == null) {
            GitImpl.$$$reportNull$$$0(77);
        }
        GitLineHandler h = new GitLineHandler(repository2.getProject(), repository2.getRoot(), GitCommand.BRANCH);
        h.setSilent(false);
        h.setStdoutSuppressed(false);
        if (GitVersionSpecialty.KNOWS_SET_UPSTREAM_TO.existsIn(repository2)) {
            h.addParameters("--set-upstream-to", upstreamBranchName, branchName);
        } else {
            h.addParameters("--set-upstream", branchName, upstreamBranchName);
        }
        GitCommandResult gitCommandResult = this.runCommand(h);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(78);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult unsetUpstream(@NotNull GitRepository repository2, @NotNull String branchName) {
        if (repository2 == null) {
            GitImpl.$$$reportNull$$$0(79);
        }
        if (branchName == null) {
            GitImpl.$$$reportNull$$$0(80);
        }
        GitLineHandler h = new GitLineHandler(repository2.getProject(), repository2.getRoot(), GitCommand.BRANCH);
        h.setSilent(false);
        h.setStdoutSuppressed(false);
        h.addParameters("--unset-upstream", branchName);
        GitCommandResult gitCommandResult = this.runCommand(h);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(81);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult renameBranch(@NotNull GitRepository repository2, @NotNull String currentName, @NotNull String newName, GitLineHandlerListener ... listeners) {
        if (repository2 == null) {
            GitImpl.$$$reportNull$$$0(82);
        }
        if (currentName == null) {
            GitImpl.$$$reportNull$$$0(83);
        }
        if (newName == null) {
            GitImpl.$$$reportNull$$$0(84);
        }
        if (listeners == null) {
            GitImpl.$$$reportNull$$$0(85);
        }
        GitLineHandler h = new GitLineHandler(repository2.getProject(), repository2.getRoot(), GitCommand.BRANCH);
        h.setSilent(false);
        h.setStdoutSuppressed(false);
        h.addParameters("-m", currentName, newName);
        GitCommandResult gitCommandResult = this.runCommand(h);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(86);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult reset(@NotNull GitRepository repository2, @NotNull GitResetMode mode, @NotNull String target, @Nullable String reflogMessage, GitLineHandlerListener ... listeners) {
        if (repository2 == null) {
            GitImpl.$$$reportNull$$$0(87);
        }
        if (mode == null) {
            GitImpl.$$$reportNull$$$0(88);
        }
        if (target == null) {
            GitImpl.$$$reportNull$$$0(89);
        }
        if (listeners == null) {
            GitImpl.$$$reportNull$$$0(90);
        }
        return this.reset(repository2, mode.getArgument(), target, reflogMessage, listeners);
    }

    @Override
    @NotNull
    public GitCommandResult resetMerge(@NotNull GitRepository repository2, @Nullable String revision) {
        if (repository2 == null) {
            GitImpl.$$$reportNull$$$0(91);
        }
        return this.reset(repository2, "--merge", revision, null, new GitLineHandlerListener[0]);
    }

    @NotNull
    private GitCommandResult reset(@NotNull GitRepository repository2, @NotNull String argument, @Nullable String target, @Nullable String reflogMessage, GitLineHandlerListener ... listeners) {
        if (repository2 == null) {
            GitImpl.$$$reportNull$$$0(92);
        }
        if (argument == null) {
            GitImpl.$$$reportNull$$$0(93);
        }
        if (listeners == null) {
            GitImpl.$$$reportNull$$$0(94);
        }
        GitLineHandler handler = new GitLineHandler(repository2.getProject(), repository2.getRoot(), GitCommand.RESET);
        handler.addParameters(argument);
        if (target != null) {
            handler.addParameters(target);
        }
        if (reflogMessage != null) {
            handler.addCustomEnvironmentVariable("GIT_REFLOG_ACTION", reflogMessage);
        }
        GitImpl.addListeners(handler, listeners);
        GitCommandResult gitCommandResult = this.runCommand(handler);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(95);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult tip(@NotNull GitRepository repository2, @NotNull String branchName) {
        if (repository2 == null) {
            GitImpl.$$$reportNull$$$0(96);
        }
        if (branchName == null) {
            GitImpl.$$$reportNull$$$0(97);
        }
        GitLineHandler h = new GitLineHandler(repository2.getProject(), repository2.getRoot(), GitCommand.REV_LIST);
        h.addParameters("-1");
        h.addParameters(branchName);
        GitCommandResult gitCommandResult = this.runCommand(h);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(98);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult push(@NotNull GitRepository repository2, @NotNull String remote, @Nullable String url, @NotNull String spec, boolean updateTracking, GitLineHandlerListener ... listeners) {
        if (repository2 == null) {
            GitImpl.$$$reportNull$$$0(99);
        }
        if (remote == null) {
            GitImpl.$$$reportNull$$$0(100);
        }
        if (spec == null) {
            GitImpl.$$$reportNull$$$0(101);
        }
        if (listeners == null) {
            GitImpl.$$$reportNull$$$0(102);
        }
        return this.doPush(repository2, remote, Collections.singleton(url), spec, false, updateTracking, false, Collections.emptyList(), null, listeners);
    }

    @Override
    @NotNull
    public GitCommandResult push(@NotNull GitRepository repository2, @NotNull GitPushParams pushParams, GitLineHandlerListener ... listeners) {
        if (repository2 == null) {
            GitImpl.$$$reportNull$$$0(103);
        }
        if (pushParams == null) {
            GitImpl.$$$reportNull$$$0(104);
        }
        return this.doPush(repository2, pushParams.getRemote().getName(), pushParams.getRemote().getPushUrls(), pushParams.getSpec(), pushParams.isForce(), pushParams.shouldSetupTracking(), pushParams.shouldSkipHooks(), pushParams.getForceWithLease(), pushParams.getTagMode(), listeners);
    }

    @NotNull
    private GitCommandResult doPush(@NotNull GitRepository repository2, @NotNull String remoteName, @NotNull Collection<String> remoteUrls, @NotNull String spec, boolean force, boolean updateTracking, boolean skipHook, List<? extends GitPushParams.ForceWithLease> forceWithLease, @Nullable String tagMode, GitLineHandlerListener ... listeners) {
        if (repository2 == null) {
            GitImpl.$$$reportNull$$$0(105);
        }
        if (remoteName == null) {
            GitImpl.$$$reportNull$$$0(106);
        }
        if (remoteUrls == null) {
            GitImpl.$$$reportNull$$$0(107);
        }
        if (spec == null) {
            GitImpl.$$$reportNull$$$0(108);
        }
        if (listeners == null) {
            GitImpl.$$$reportNull$$$0(109);
        }
        GitCommandResult gitCommandResult = this.runCommand((Computable<? extends GitLineHandler>)((Computable)() -> {
            GitLineHandler h = new GitLineHandler(repository2.getProject(), repository2.getRoot(), GitCommand.PUSH);
            h.setUrls(remoteUrls);
            h.setSilent(false);
            h.setStdoutSuppressed(false);
            GitImpl.addListeners(h, listeners);
            if (GitVersionSpecialty.ABLE_TO_USE_PROGRESS_IN_REMOTE_COMMANDS.existsIn(repository2)) {
                h.addParameters("--progress");
            }
            h.addParameters("--porcelain");
            h.addParameters(remoteName);
            h.addParameters(spec);
            if (updateTracking) {
                h.addParameters("--set-upstream");
            }
            if (GitVersionSpecialty.SUPPORTS_FORCE_PUSH_WITH_LEASE.existsIn(repository2) && !forceWithLease.isEmpty()) {
                for (GitPushParams.ForceWithLease lease : forceWithLease) {
                    String parameter = lease.getParameter();
                    if (parameter != null) {
                        h.addParameters("--force-with-lease=" + parameter);
                        continue;
                    }
                    h.addParameters("--force-with-lease");
                }
            } else if (force) {
                h.addParameters("--force");
            }
            if (tagMode != null) {
                h.addParameters(tagMode);
            }
            if (skipHook) {
                h.addParameters("--no-verify");
            }
            return h;
        }));
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(110);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult show(@NotNull GitRepository repository2, String ... params) {
        if (repository2 == null) {
            GitImpl.$$$reportNull$$$0(111);
        }
        if (params == null) {
            GitImpl.$$$reportNull$$$0(112);
        }
        GitLineHandler handler = new GitLineHandler(repository2.getProject(), repository2.getRoot(), GitCommand.SHOW);
        handler.addParameters(params);
        GitCommandResult gitCommandResult = this.runCommand(handler);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(113);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult cherryPick(@NotNull GitRepository repository2, @NotNull String hash, boolean autoCommit, boolean addCherryPickedFromSuffix, GitLineHandlerListener ... listeners) {
        if (repository2 == null) {
            GitImpl.$$$reportNull$$$0(114);
        }
        if (hash == null) {
            GitImpl.$$$reportNull$$$0(115);
        }
        if (listeners == null) {
            GitImpl.$$$reportNull$$$0(116);
        }
        GitLineHandler handler = new GitLineHandler(repository2.getProject(), repository2.getRoot(), GitCommand.CHERRY_PICK);
        if (addCherryPickedFromSuffix) {
            handler.addParameters("-x");
        }
        if (!autoCommit) {
            handler.addParameters("-n");
        }
        handler.addParameters(hash);
        GitImpl.addListeners(handler, listeners);
        handler.setSilent(false);
        handler.setStdoutSuppressed(false);
        GitCommandResult gitCommandResult = this.runCommand(handler);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(117);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult getUnmergedFiles(@NotNull GitRepository repository2) {
        if (repository2 == null) {
            GitImpl.$$$reportNull$$$0(118);
        }
        GitLineHandler h = new GitLineHandler(repository2.getProject(), repository2.getRoot(), GitCommand.LS_FILES);
        h.addParameters("--unmerged");
        h.setSilent(true);
        GitCommandResult gitCommandResult = this.runCommand(h);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(119);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult getResolvedFiles(@NotNull GitRepository repository2) {
        if (repository2 == null) {
            GitImpl.$$$reportNull$$$0(120);
        }
        GitLineHandler h = new GitLineHandler(repository2.getProject(), repository2.getRoot(), GitCommand.LS_FILES);
        h.addParameters("--resolve-undo");
        h.setSilent(true);
        GitCommandResult gitCommandResult = this.runCommand(h);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(121);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult fetch(@NotNull GitRepository repository2, @NotNull GitRemote remote, @NotNull List<? extends GitLineHandlerListener> listeners, String ... params) {
        if (repository2 == null) {
            GitImpl.$$$reportNull$$$0(122);
        }
        if (remote == null) {
            GitImpl.$$$reportNull$$$0(123);
        }
        if (listeners == null) {
            GitImpl.$$$reportNull$$$0(124);
        }
        GitCommandResult gitCommandResult = this.fetch(repository2, remote, listeners, (AuthenticationGate)null, params);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(125);
        }
        return gitCommandResult;
    }

    @NotNull
    public GitCommandResult fetch(@NotNull GitRepository repository2, @NotNull GitRemote remote, @NotNull List<? extends GitLineHandlerListener> listeners, @Nullable AuthenticationGate authenticationGate, String ... params) {
        if (repository2 == null) {
            GitImpl.$$$reportNull$$$0(126);
        }
        if (remote == null) {
            GitImpl.$$$reportNull$$$0(127);
        }
        if (listeners == null) {
            GitImpl.$$$reportNull$$$0(128);
        }
        GitCommandResult gitCommandResult = this.runCommand((Computable<? extends GitLineHandler>)((Computable)() -> {
            GitLineHandler h = new GitLineHandler(repository2.getProject(), repository2.getRoot(), GitCommand.FETCH);
            if (authenticationGate != null) {
                h.setAuthenticationGate(authenticationGate);
            }
            h.setSilent(false);
            h.setStdoutSuppressed(false);
            h.setUrls(remote.getUrls());
            h.addParameters(remote.getName());
            h.addParameters(params);
            if (GitVersionSpecialty.ABLE_TO_USE_PROGRESS_IN_REMOTE_COMMANDS.existsIn(repository2)) {
                h.addParameters("--progress");
            }
            if (GitVersionSpecialty.SUPPORTS_FETCH_PRUNE.existsIn(repository2)) {
                h.addParameters("--prune");
            }
            GitImpl.addListeners(h, listeners);
            return h;
        }));
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(129);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult addRemote(@NotNull GitRepository repository2, @NotNull String name, @NotNull String url) {
        if (repository2 == null) {
            GitImpl.$$$reportNull$$$0(130);
        }
        if (name == null) {
            GitImpl.$$$reportNull$$$0(131);
        }
        if (url == null) {
            GitImpl.$$$reportNull$$$0(132);
        }
        GitLineHandler h = new GitLineHandler(repository2.getProject(), repository2.getRoot(), GitCommand.REMOTE);
        h.addParameters("add", name, url);
        GitCommandResult gitCommandResult = this.runCommand(h);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(133);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult removeRemote(@NotNull GitRepository repository2, @NotNull GitRemote remote) {
        if (repository2 == null) {
            GitImpl.$$$reportNull$$$0(134);
        }
        if (remote == null) {
            GitImpl.$$$reportNull$$$0(135);
        }
        GitLineHandler h = new GitLineHandler(repository2.getProject(), repository2.getRoot(), GitCommand.REMOTE);
        h.addParameters("remove", remote.getName());
        GitCommandResult gitCommandResult = this.runCommand(h);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(136);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult renameRemote(@NotNull GitRepository repository2, @NotNull String oldName, @NotNull String newName) {
        if (repository2 == null) {
            GitImpl.$$$reportNull$$$0(137);
        }
        if (oldName == null) {
            GitImpl.$$$reportNull$$$0(138);
        }
        if (newName == null) {
            GitImpl.$$$reportNull$$$0(139);
        }
        GitLineHandler h = new GitLineHandler(repository2.getProject(), repository2.getRoot(), GitCommand.REMOTE);
        h.addParameters("rename", oldName, newName);
        GitCommandResult gitCommandResult = this.runCommand(h);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(140);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult setRemoteUrl(@NotNull GitRepository repository2, @NotNull String remoteName, @NotNull String newUrl) {
        if (repository2 == null) {
            GitImpl.$$$reportNull$$$0(141);
        }
        if (remoteName == null) {
            GitImpl.$$$reportNull$$$0(142);
        }
        if (newUrl == null) {
            GitImpl.$$$reportNull$$$0(143);
        }
        GitLineHandler h = new GitLineHandler(repository2.getProject(), repository2.getRoot(), GitCommand.REMOTE);
        h.addParameters("set-url", remoteName, newUrl);
        GitCommandResult gitCommandResult = this.runCommand(h);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(144);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult lsRemote(@NotNull Project project, @NotNull File workingDir, @NotNull String url) {
        if (project == null) {
            GitImpl.$$$reportNull$$$0(145);
        }
        if (workingDir == null) {
            GitImpl.$$$reportNull$$$0(146);
        }
        if (url == null) {
            GitImpl.$$$reportNull$$$0(147);
        }
        return this.doLsRemote(project, workingDir, url, Collections.singleton(url), Collections.emptyList(), new String[0]);
    }

    @Override
    @NotNull
    public GitCommandResult lsRemote(@NotNull Project project, @NotNull VirtualFile workingDir, @NotNull GitRemote remote, String ... additionalParameters) {
        if (project == null) {
            GitImpl.$$$reportNull$$$0(148);
        }
        if (workingDir == null) {
            GitImpl.$$$reportNull$$$0(149);
        }
        if (remote == null) {
            GitImpl.$$$reportNull$$$0(150);
        }
        GitCommandResult gitCommandResult = this.lsRemoteRefs(project, workingDir, remote, Collections.emptyList(), additionalParameters);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(151);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult lsRemoteRefs(@NotNull Project project, @NotNull VirtualFile workingDir, @NotNull GitRemote remote, @NotNull List<String> refs, String ... additionalParameters) {
        if (project == null) {
            GitImpl.$$$reportNull$$$0(152);
        }
        if (workingDir == null) {
            GitImpl.$$$reportNull$$$0(153);
        }
        if (remote == null) {
            GitImpl.$$$reportNull$$$0(154);
        }
        if (refs == null) {
            GitImpl.$$$reportNull$$$0(155);
        }
        return this.doLsRemote(project, VfsUtilCore.virtualToIoFile((VirtualFile)workingDir), remote.getName(), remote.getUrls(), refs, additionalParameters);
    }

    @Override
    @NotNull
    public GitCommandResult remotePrune(@NotNull GitRepository repository2, @NotNull GitRemote remote) {
        if (repository2 == null) {
            GitImpl.$$$reportNull$$$0(156);
        }
        if (remote == null) {
            GitImpl.$$$reportNull$$$0(157);
        }
        GitCommandResult gitCommandResult = this.runCommand((Computable<? extends GitLineHandler>)((Computable)() -> {
            GitLineHandler h = new GitLineHandler(repository2.getProject(), repository2.getRoot(), GitCommand.REMOTE.writeLockingCommand());
            h.setStdoutSuppressed(false);
            h.addParameters("prune");
            h.addParameters(remote.getName());
            h.setUrls(remote.getUrls());
            return h;
        }));
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(158);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitRebaseCommandResult rebase(@NotNull GitRepository repository2, @NotNull GitRebaseParams parameters, GitLineHandlerListener ... listeners) {
        if (repository2 == null) {
            GitImpl.$$$reportNull$$$0(159);
        }
        if (parameters == null) {
            GitImpl.$$$reportNull$$$0(160);
        }
        if (listeners == null) {
            GitImpl.$$$reportNull$$$0(161);
        }
        Project project = repository2.getProject();
        VirtualFile root = repository2.getRoot();
        GitLineHandler handler = new GitLineHandler(project, root, GitCommand.REBASE, REBASE_CONFIG_PARAMS);
        handler.addParameters(parameters.asCommandLineArguments());
        GitImpl.addListeners(handler, listeners);
        if (parameters.isInteractive()) {
            GitRebaseEditorHandler editorHandler = parameters.getEditorHandler();
            if (editorHandler == null) {
                editorHandler = this.createRebaseEditor(project, root, handler, true);
            }
            return this.runWithEditor(handler, editorHandler);
        }
        return new GitRebaseCommandResult(this.runCommand(handler));
    }

    @Override
    @NotNull
    public GitRebaseCommandResult rebaseAbort(@NotNull GitRepository repository2, GitLineHandlerListener ... listeners) {
        if (repository2 == null) {
            GitImpl.$$$reportNull$$$0(162);
        }
        if (listeners == null) {
            GitImpl.$$$reportNull$$$0(163);
        }
        GitLineHandler handler = new GitLineHandler(repository2.getProject(), repository2.getRoot(), GitCommand.REBASE);
        handler.addParameters("--abort");
        GitImpl.addListeners(handler, listeners);
        return new GitRebaseCommandResult(this.runCommand(handler));
    }

    @Override
    @NotNull
    public GitRebaseCommandResult rebaseContinue(@NotNull GitRepository repository2, GitLineHandlerListener ... listeners) {
        if (repository2 == null) {
            GitImpl.$$$reportNull$$$0(164);
        }
        if (listeners == null) {
            GitImpl.$$$reportNull$$$0(165);
        }
        return this.rebaseResume(repository2, GitRebaseResumeMode.CONTINUE, listeners);
    }

    @Override
    @NotNull
    public GitRebaseCommandResult rebaseSkip(@NotNull GitRepository repository2, GitLineHandlerListener ... listeners) {
        if (repository2 == null) {
            GitImpl.$$$reportNull$$$0(166);
        }
        if (listeners == null) {
            GitImpl.$$$reportNull$$$0(167);
        }
        return this.rebaseResume(repository2, GitRebaseResumeMode.SKIP, listeners);
    }

    @NotNull
    private GitRebaseCommandResult rebaseResume(@NotNull GitRepository repository2, @NotNull GitRebaseResumeMode rebaseMode, GitLineHandlerListener @NotNull [] listeners) {
        if (repository2 == null) {
            GitImpl.$$$reportNull$$$0(168);
        }
        if (rebaseMode == null) {
            GitImpl.$$$reportNull$$$0(169);
        }
        if (listeners == null) {
            GitImpl.$$$reportNull$$$0(170);
        }
        Project project = repository2.getProject();
        VirtualFile root = repository2.getRoot();
        GitLineHandler handler = new GitLineHandler(project, root, GitCommand.REBASE, REBASE_CONFIG_PARAMS);
        handler.addParameters(rebaseMode.asCommandLineArgument());
        GitImpl.addListeners(handler, listeners);
        return this.runWithEditor(handler, this.createRebaseEditor(project, root, handler, false));
    }

    @NotNull
    private GitRebaseCommandResult runWithEditor(@NotNull GitLineHandler handler, @NotNull GitRebaseEditorHandler editorHandler) {
        if (handler == null) {
            GitImpl.$$$reportNull$$$0(171);
        }
        if (editorHandler == null) {
            GitImpl.$$$reportNull$$$0(172);
        }
        GitHandlerRebaseEditorManager ignored = GitHandlerRebaseEditorManager.prepareEditor(handler, editorHandler);
        GitCommandResult result2 = this.runCommand(handler);
        GitRebaseCommandResult gitRebaseCommandResult = new GitRebaseCommandResult(result2, editorHandler.getEditingResult());
        GitRebaseCommandResult gitRebaseCommandResult2 = gitRebaseCommandResult;
        if (gitRebaseCommandResult2 == null) {
            GitImpl.$$$reportNull$$$0(173);
        }
        return gitRebaseCommandResult2;
        finally {
            if (ignored != null) {
                ignored.close();
            }
        }
    }

    @VisibleForTesting
    @NotNull
    protected GitRebaseEditorHandler createRebaseEditor(@NotNull Project project, @NotNull VirtualFile root, @NotNull GitLineHandler handler, boolean commitListAware) {
        if (project == null) {
            GitImpl.$$$reportNull$$$0(174);
        }
        if (root == null) {
            GitImpl.$$$reportNull$$$0(175);
        }
        if (handler == null) {
            GitImpl.$$$reportNull$$$0(176);
        }
        GitRebaseEditorHandler gitRebaseEditorHandler = GitRebaseUtils.createRebaseEditor(project, root, commitListAware);
        if (gitRebaseEditorHandler == null) {
            GitImpl.$$$reportNull$$$0(177);
        }
        return gitRebaseEditorHandler;
    }

    @Override
    @NotNull
    public GitCommandResult revert(@NotNull GitRepository repository2, @NotNull String commit, boolean autoCommit, GitLineHandlerListener ... listeners) {
        if (repository2 == null) {
            GitImpl.$$$reportNull$$$0(178);
        }
        if (commit == null) {
            GitImpl.$$$reportNull$$$0(179);
        }
        if (listeners == null) {
            GitImpl.$$$reportNull$$$0(180);
        }
        GitLineHandler handler = new GitLineHandler(repository2.getProject(), repository2.getRoot(), GitCommand.REVERT);
        handler.addParameters(commit);
        if (!autoCommit) {
            handler.addParameters("--no-commit");
        }
        GitImpl.addListeners(handler, listeners);
        GitCommandResult gitCommandResult = this.runCommand(handler);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(181);
        }
        return gitCommandResult;
    }

    @Override
    @Nullable
    public Hash resolveReference(@NotNull GitRepository repository2, @NotNull String ref) {
        if (repository2 == null) {
            GitImpl.$$$reportNull$$$0(182);
        }
        if (ref == null) {
            GitImpl.$$$reportNull$$$0(183);
        }
        VirtualFile root = repository2.getRoot();
        GitLineHandler handler = new GitLineHandler(repository2.getProject(), root, GitCommand.REV_PARSE);
        handler.addParameters("--verify");
        handler.addParameters(ref + "^{commit}");
        GitCommandResult result2 = Git.getInstance().runCommand(handler);
        String output2 = result2.getOutputAsJoinedString();
        if (result2.success()) {
            if (GitUtil.isHashString(output2, false)) {
                return HashImpl.build((String)output2);
            }
            LOG.error("Invalid output for git rev-parse " + ref + " in " + String.valueOf(root) + ": " + output2);
            return null;
        }
        LOG.debug("Reference [" + ref + "] is unknown to Git in " + String.valueOf(root));
        return null;
    }

    @Override
    @NotNull
    public GitCommandResult updateReference(@NotNull GitRepository repository2, @NotNull String reference, @NotNull Hash newObjectId, @Nullable String reflogMessage) {
        if (repository2 == null) {
            GitImpl.$$$reportNull$$$0(184);
        }
        if (reference == null) {
            GitImpl.$$$reportNull$$$0(185);
        }
        if (newObjectId == null) {
            GitImpl.$$$reportNull$$$0(186);
        }
        GitLineHandler h = new GitLineHandler(repository2.getProject(), repository2.getRoot(), GitCommand.UPDATE_REF);
        h.addParameters(reference, newObjectId.asString());
        if (reflogMessage != null) {
            h.addParameters("-m", reflogMessage);
        }
        GitCommandResult gitCommandResult = this.runCommand(h);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(187);
        }
        return gitCommandResult;
    }

    @NotNull
    private GitCommandResult doLsRemote(@NotNull Project project, @NotNull File workingDir, @NotNull String remoteId, @NotNull Collection<String> authenticationUrls, @NotNull List<String> refs, String ... additionalParameters) {
        if (project == null) {
            GitImpl.$$$reportNull$$$0(188);
        }
        if (workingDir == null) {
            GitImpl.$$$reportNull$$$0(189);
        }
        if (remoteId == null) {
            GitImpl.$$$reportNull$$$0(190);
        }
        if (authenticationUrls == null) {
            GitImpl.$$$reportNull$$$0(191);
        }
        if (refs == null) {
            GitImpl.$$$reportNull$$$0(192);
        }
        GitCommandResult gitCommandResult = this.runCommand((Computable<? extends GitLineHandler>)((Computable)() -> {
            GitLineHandler h = new GitLineHandler(project, workingDir, GitCommand.LS_REMOTE);
            h.addParameters(additionalParameters);
            h.addParameters(remoteId);
            h.addParameters(refs);
            h.setUrls(authenticationUrls);
            return h;
        }));
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(193);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult getObjectType(@NotNull GitRepository repository2, @NotNull String object) {
        if (repository2 == null) {
            GitImpl.$$$reportNull$$$0(194);
        }
        if (object == null) {
            GitImpl.$$$reportNull$$$0(195);
        }
        GitLineHandler h = new GitLineHandler(repository2.getProject(), repository2.getRoot(), GitCommand.CAT_FILE);
        h.setSilent(true);
        h.addParameters("-t", object);
        GitCommandResult gitCommandResult = this.runCommand(h);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(196);
        }
        return gitCommandResult;
    }

    @Override
    @Nullable
    public GitObjectType getObjectTypeEnum(@NotNull GitRepository repository2, @NotNull String object) {
        GitCommandResult result2;
        if (repository2 == null) {
            GitImpl.$$$reportNull$$$0(197);
        }
        if (object == null) {
            GitImpl.$$$reportNull$$$0(198);
        }
        if (!(result2 = this.getObjectType(repository2, object)).success()) {
            return null;
        }
        String string = result2.getOutputAsJoinedString();
        try {
            return GitObjectType.valueOf(StringUtil.toUpperCase((String)string));
        }
        catch (IllegalArgumentException e) {
            LOG.warn((Throwable)e);
            return null;
        }
    }

    private static void addListeners(@NotNull GitLineHandler handler, GitLineHandlerListener ... listeners) {
        if (handler == null) {
            GitImpl.$$$reportNull$$$0(199);
        }
        if (listeners == null) {
            GitImpl.$$$reportNull$$$0(200);
        }
        GitImpl.addListeners(handler, Arrays.asList(listeners));
    }

    private static void addListeners(@NotNull GitLineHandler handler, @NotNull List<? extends GitLineHandlerListener> listeners) {
        if (handler == null) {
            GitImpl.$$$reportNull$$$0(201);
        }
        if (listeners == null) {
            GitImpl.$$$reportNull$$$0(202);
        }
        for (GitLineHandlerListener gitLineHandlerListener : listeners) {
            handler.addLineListener(gitLineHandlerListener);
        }
    }

    @NotNull
    public static String runBundledCommand(@Nullable Project project, String ... args) throws VcsException {
        String string;
        if (project != null && !TrustedProjects.isProjectTrusted((Project)project)) {
            throw new IllegalStateException("Shouldn't be possible to run a Git command in the safe mode");
        }
        try {
            GitExecutable gitExecutable = GitExecutableManager.getInstance().getExecutable(project);
            GeneralCommandLine command = gitExecutable.createBundledCommandLine(project, args);
            command.setCharset(StandardCharsets.UTF_8);
            final StringBuilder output2 = new StringBuilder();
            OSProcessHandler handler = new OSProcessHandler(command);
            handler.addProcessListener(new ProcessListener(){

                public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (outputType == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (outputType == ProcessOutputTypes.STDOUT) {
                        output2.append(event.getText());
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "event";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "outputType";
                            break;
                        }
                    }
                    objectArray[1] = "git4idea/commands/GitImpl$1";
                    objectArray[2] = "onTextAvailable";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            handler.startNotify();
            handler.waitFor();
            string = output2.toString();
        }
        catch (ExecutionException e) {
            throw new VcsException((Throwable)e);
        }
        if (string == null) {
            GitImpl.$$$reportNull$$$0(203);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 10, 11, 14, 23, 25, 29, 33, 36, 39, 43, 47, 51, 54, 58, 62, 66, 70, 74, 78, 81, 86, 95, 98, 110, 113, 117, 119, 121, 125, 129, 133, 136, 140, 144, 151, 158, 173, 177, 181, 187, 193, 196, 203 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 8: 
            case 13: 
            case 16: 
            case 18: 
            case 175: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: 
            case 22: 
            case 38: 
            case 42: 
            case 46: 
            case 50: 
            case 61: 
            case 65: 
            case 85: 
            case 90: 
            case 94: 
            case 102: 
            case 109: 
            case 116: 
            case 124: 
            case 128: 
            case 161: 
            case 163: 
            case 165: 
            case 167: 
            case 170: 
            case 180: 
            case 200: 
            case 202: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listeners";
                break;
            }
            case 3: 
            case 10: 
            case 11: 
            case 14: 
            case 23: 
            case 25: 
            case 29: 
            case 33: 
            case 36: 
            case 39: 
            case 43: 
            case 47: 
            case 51: 
            case 54: 
            case 58: 
            case 62: 
            case 66: 
            case 70: 
            case 74: 
            case 78: 
            case 81: 
            case 86: 
            case 95: 
            case 98: 
            case 110: 
            case 113: 
            case 117: 
            case 119: 
            case 121: 
            case 125: 
            case 129: 
            case 133: 
            case 136: 
            case 140: 
            case 144: 
            case 151: 
            case 158: 
            case 173: 
            case 177: 
            case 181: 
            case 187: 
            case 193: 
            case 196: 
            case 203: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/commands/GitImpl";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileStatusPrefix";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDirectory";
                break;
            }
            case 20: 
            case 132: 
            case 147: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clonedDirectoryName";
                break;
            }
            case 24: 
            case 26: 
            case 30: 
            case 34: 
            case 37: 
            case 40: 
            case 44: 
            case 48: 
            case 52: 
            case 55: 
            case 59: 
            case 63: 
            case 67: 
            case 71: 
            case 75: 
            case 79: 
            case 82: 
            case 87: 
            case 91: 
            case 92: 
            case 96: 
            case 99: 
            case 103: 
            case 105: 
            case 111: 
            case 114: 
            case 118: 
            case 120: 
            case 122: 
            case 126: 
            case 130: 
            case 134: 
            case 137: 
            case 141: 
            case 156: 
            case 159: 
            case 162: 
            case 164: 
            case 166: 
            case 168: 
            case 178: 
            case 182: 
            case 184: 
            case 194: 
            case 197: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 27: 
            case 160: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchToMerge";
                break;
            }
            case 45: 
            case 49: 
            case 57: 
            case 185: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 53: 
            case 64: 
            case 68: 
            case 72: 
            case 77: 
            case 80: 
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchName";
                break;
            }
            case 56: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagName";
                break;
            }
            case 69: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startPoint";
                break;
            }
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "upstreamBranchName";
                break;
            }
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentName";
                break;
            }
            case 84: 
            case 139: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
            case 100: 
            case 123: 
            case 127: 
            case 135: 
            case 150: 
            case 154: 
            case 157: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remote";
                break;
            }
            case 101: 
            case 108: {
                objectArray2 = objectArray3;
                objectArray3[0] = "spec";
                break;
            }
            case 104: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pushParams";
                break;
            }
            case 106: 
            case 142: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteName";
                break;
            }
            case 107: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteUrls";
                break;
            }
            case 112: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 115: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hash";
                break;
            }
            case 131: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 138: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldName";
                break;
            }
            case 143: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newUrl";
                break;
            }
            case 146: 
            case 149: 
            case 153: 
            case 189: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDir";
                break;
            }
            case 155: 
            case 192: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refs";
                break;
            }
            case 169: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rebaseMode";
                break;
            }
            case 171: 
            case 176: 
            case 199: 
            case 201: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 172: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorHandler";
                break;
            }
            case 179: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commit";
                break;
            }
            case 183: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 186: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newObjectId";
                break;
            }
            case 190: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteId";
                break;
            }
            case 191: {
                objectArray2 = objectArray3;
                objectArray3[0] = "authenticationUrls";
                break;
            }
            case 195: 
            case 198: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/commands/GitImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "init";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "parseFiles";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "untrackedFiles";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "clone";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "config";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "diff";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "checkAttr";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "stashSave";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "stashPop";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "merge";
                break;
            }
            case 47: 
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "checkout";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "checkoutNewBranch";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "createNewTag";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "deleteTag";
                break;
            }
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "branchDelete";
                break;
            }
            case 70: 
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "branchCreate";
                break;
            }
            case 78: {
                objectArray = objectArray2;
                objectArray2[1] = "setUpstream";
                break;
            }
            case 81: {
                objectArray = objectArray2;
                objectArray2[1] = "unsetUpstream";
                break;
            }
            case 86: {
                objectArray = objectArray2;
                objectArray2[1] = "renameBranch";
                break;
            }
            case 95: {
                objectArray = objectArray2;
                objectArray2[1] = "reset";
                break;
            }
            case 98: {
                objectArray = objectArray2;
                objectArray2[1] = "tip";
                break;
            }
            case 110: {
                objectArray = objectArray2;
                objectArray2[1] = "doPush";
                break;
            }
            case 113: {
                objectArray = objectArray2;
                objectArray2[1] = "show";
                break;
            }
            case 117: {
                objectArray = objectArray2;
                objectArray2[1] = "cherryPick";
                break;
            }
            case 119: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnmergedFiles";
                break;
            }
            case 121: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolvedFiles";
                break;
            }
            case 125: 
            case 129: {
                objectArray = objectArray2;
                objectArray2[1] = "fetch";
                break;
            }
            case 133: {
                objectArray = objectArray2;
                objectArray2[1] = "addRemote";
                break;
            }
            case 136: {
                objectArray = objectArray2;
                objectArray2[1] = "removeRemote";
                break;
            }
            case 140: {
                objectArray = objectArray2;
                objectArray2[1] = "renameRemote";
                break;
            }
            case 144: {
                objectArray = objectArray2;
                objectArray2[1] = "setRemoteUrl";
                break;
            }
            case 151: {
                objectArray = objectArray2;
                objectArray2[1] = "lsRemote";
                break;
            }
            case 158: {
                objectArray = objectArray2;
                objectArray2[1] = "remotePrune";
                break;
            }
            case 173: {
                objectArray = objectArray2;
                objectArray2[1] = "runWithEditor";
                break;
            }
            case 177: {
                objectArray = objectArray2;
                objectArray2[1] = "createRebaseEditor";
                break;
            }
            case 181: {
                objectArray = objectArray2;
                objectArray2[1] = "revert";
                break;
            }
            case 187: {
                objectArray = objectArray2;
                objectArray2[1] = "updateReference";
                break;
            }
            case 193: {
                objectArray = objectArray2;
                objectArray2[1] = "doLsRemote";
                break;
            }
            case 196: {
                objectArray = objectArray2;
                objectArray2[1] = "getObjectType";
                break;
            }
            case 203: {
                objectArray = objectArray2;
                objectArray2[1] = "runBundledCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 3: 
            case 10: 
            case 11: 
            case 14: 
            case 23: 
            case 25: 
            case 29: 
            case 33: 
            case 36: 
            case 39: 
            case 43: 
            case 47: 
            case 51: 
            case 54: 
            case 58: 
            case 62: 
            case 66: 
            case 70: 
            case 74: 
            case 78: 
            case 81: 
            case 86: 
            case 95: 
            case 98: 
            case 110: 
            case 113: 
            case 117: 
            case 119: 
            case 121: 
            case 125: 
            case 129: 
            case 133: 
            case 136: 
            case 140: 
            case 144: 
            case 151: 
            case 158: 
            case 173: 
            case 177: 
            case 181: 
            case 187: 
            case 193: 
            case 196: 
            case 203: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "ignoredFilePaths";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "ignoredFilePathsNoChunk";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "parseFiles";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "untrackedFiles";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "untrackedFilePaths";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "untrackedFilePathsNoChunk";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "clone";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "config";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "diff";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "checkAttr";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "stashSave";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "stashPop";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "merge";
                break;
            }
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "checkout";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "checkoutNewBranch";
                break;
            }
            case 55: 
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "createNewTag";
                break;
            }
            case 59: 
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "deleteTag";
                break;
            }
            case 63: 
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "branchDelete";
                break;
            }
            case 67: 
            case 68: 
            case 69: 
            case 71: 
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "branchCreate";
                break;
            }
            case 75: 
            case 76: 
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "setUpstream";
                break;
            }
            case 79: 
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "unsetUpstream";
                break;
            }
            case 82: 
            case 83: 
            case 84: 
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "renameBranch";
                break;
            }
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 92: 
            case 93: 
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "resetMerge";
                break;
            }
            case 96: 
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "tip";
                break;
            }
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "push";
                break;
            }
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "doPush";
                break;
            }
            case 111: 
            case 112: {
                objectArray = objectArray;
                objectArray[2] = "show";
                break;
            }
            case 114: 
            case 115: 
            case 116: {
                objectArray = objectArray;
                objectArray[2] = "cherryPick";
                break;
            }
            case 118: {
                objectArray = objectArray;
                objectArray[2] = "getUnmergedFiles";
                break;
            }
            case 120: {
                objectArray = objectArray;
                objectArray[2] = "getResolvedFiles";
                break;
            }
            case 122: 
            case 123: 
            case 124: 
            case 126: 
            case 127: 
            case 128: {
                objectArray = objectArray;
                objectArray[2] = "fetch";
                break;
            }
            case 130: 
            case 131: 
            case 132: {
                objectArray = objectArray;
                objectArray[2] = "addRemote";
                break;
            }
            case 134: 
            case 135: {
                objectArray = objectArray;
                objectArray[2] = "removeRemote";
                break;
            }
            case 137: 
            case 138: 
            case 139: {
                objectArray = objectArray;
                objectArray[2] = "renameRemote";
                break;
            }
            case 141: 
            case 142: 
            case 143: {
                objectArray = objectArray;
                objectArray[2] = "setRemoteUrl";
                break;
            }
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: {
                objectArray = objectArray;
                objectArray[2] = "lsRemote";
                break;
            }
            case 152: 
            case 153: 
            case 154: 
            case 155: {
                objectArray = objectArray;
                objectArray[2] = "lsRemoteRefs";
                break;
            }
            case 156: 
            case 157: {
                objectArray = objectArray;
                objectArray[2] = "remotePrune";
                break;
            }
            case 159: 
            case 160: 
            case 161: {
                objectArray = objectArray;
                objectArray[2] = "rebase";
                break;
            }
            case 162: 
            case 163: {
                objectArray = objectArray;
                objectArray[2] = "rebaseAbort";
                break;
            }
            case 164: 
            case 165: {
                objectArray = objectArray;
                objectArray[2] = "rebaseContinue";
                break;
            }
            case 166: 
            case 167: {
                objectArray = objectArray;
                objectArray[2] = "rebaseSkip";
                break;
            }
            case 168: 
            case 169: 
            case 170: {
                objectArray = objectArray;
                objectArray[2] = "rebaseResume";
                break;
            }
            case 171: 
            case 172: {
                objectArray = objectArray;
                objectArray[2] = "runWithEditor";
                break;
            }
            case 174: 
            case 175: 
            case 176: {
                objectArray = objectArray;
                objectArray[2] = "createRebaseEditor";
                break;
            }
            case 178: 
            case 179: 
            case 180: {
                objectArray = objectArray;
                objectArray[2] = "revert";
                break;
            }
            case 182: 
            case 183: {
                objectArray = objectArray;
                objectArray[2] = "resolveReference";
                break;
            }
            case 184: 
            case 185: 
            case 186: {
                objectArray = objectArray;
                objectArray[2] = "updateReference";
                break;
            }
            case 188: 
            case 189: 
            case 190: 
            case 191: 
            case 192: {
                objectArray = objectArray;
                objectArray[2] = "doLsRemote";
                break;
            }
            case 194: 
            case 195: {
                objectArray = objectArray;
                objectArray[2] = "getObjectType";
                break;
            }
            case 197: 
            case 198: {
                objectArray = objectArray;
                objectArray[2] = "getObjectTypeEnum";
                break;
            }
            case 199: 
            case 200: 
            case 201: 
            case 202: {
                objectArray = objectArray;
                objectArray[2] = "addListeners";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 10, 11, 14, 23, 25, 29, 33, 36, 39, 43, 47, 51, 54, 58, 62, 66, 70, 74, 78, 81, 86, 95, 98, 110, 113, 117, 119, 121, 125, 129, 133, 136, 140, 144, 151, 158, 173, 177, 181, 187, 193, 196, 203 -> new IllegalStateException(string);
        };
    }
}

