/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.ru;

import ai.grazie.nlp.langs.Language;
import ai.grazie.rules.Example;
import ai.grazie.rules.Rule;
import ai.grazie.rules.common.AsciiApproximations;
import ai.grazie.rules.common.CommonPatterns;
import ai.grazie.rules.common.FormattingIssues;
import ai.grazie.rules.ru.PunctuationRules;
import ai.grazie.rules.tree.NodeCorrector;
import ai.grazie.rules.tree.NodePattern;
import ai.grazie.rules.tree.TextRange;
import ai.grazie.rules.tree.TreeSupport;
import java.util.List;
import java.util.Locale;

public class TypographyRules {
    private static final String accentableVowels = "\u0430\u0435\u0438\u043e\u0443\u044d\u044e\u044f";
    static final String vowels = "\u0430\u0435\u0438\u043e\u0443\u044d\u044e\u044f\u0451";
    private static final String STRESS_SIGN_MESSAGE = "\u041f\u043e\u0441\u0442\u0430\u0432\u0438\u0442\u044c \u0437\u043d\u0430\u043a \u0443\u0434\u0430\u0440\u0435\u043d\u0438\u044f?";
    private static final String NBSP_IBAN = "\u0414\u043b\u044f \u043b\u0443\u0447\u0448\u0435\u0439 \u0447\u0438\u0442\u0430\u0435\u043c\u043e\u0441\u0442\u0438 \u0440\u0430\u0437\u0434\u0435\u043b\u0438\u0442\u0435 IBAN \u043d\u0435\u0440\u0430\u0437\u0440\u044b\u0432\u043d\u044b\u043c\u0438 \u043f\u0440\u043e\u0431\u0435\u043b\u0430\u043c\u0438 \u043f\u043e\u0441\u043b\u0435 \u043a\u0430\u0436\u0434\u043e\u0433\u043e \u0447\u0435\u0442\u0432\u0435\u0440\u0442\u043e\u0433\u043e \u0441\u0438\u043c\u0432\u043e\u043b\u0430";

    static List<Rule> rules() {
        return List.of(new Rule.PatternRule("Typography.ACCENT_MARK", "\u0417\u043d\u0430\u043a \u0443\u0434\u0430\u0440\u0435\u043d\u0438\u044f", "\u0417\u0430\u043c\u0435\u043d\u0438\u0442\u044c \u0431\u043e\u043b\u044c\u0448\u0443\u044e \u0433\u043b\u0430\u0441\u043d\u0443\u044e \u0431\u0443\u043a\u0432\u0443 \u043d\u0430 \u0437\u043d\u0430\u043a \u0443\u0434\u0430\u0440\u0435\u043d\u0438\u044f Unicode.", "https://ru.wikipedia.org/wiki/\u0417\u043d\u0430\u043a_\u0443\u0434\u0430\u0440\u0435\u043d\u0438\u044f", () -> TypographyRules.accentMark(), new Example("\u042d\u0442\u043e \u0436\u0435 \u0437\u0430<b>\u043c\u041e\u043a</b>", "\u042d\u0442\u043e \u0436\u0435 \u0437\u0430<b>\u043c\u043e\u0301\u043a</b>")).enableInFlatTrees().honorCrazyParses(), new AsciiApproximations(Language.RUSSIAN, "\u0417\u0430\u043c\u0435\u043d\u044f\u0442\u044c \u0442\u0438\u043f\u043e\u0433\u0440\u0430\u0444\u0441\u043a\u0438\u0435 \u0430\u043f\u043f\u0440\u043e\u043a\u0441\u0438\u043c\u0430\u0446\u0438\u0438 \u0441\u0438\u043c\u0432\u043e\u043b\u0430\u043c\u0438 Unicode", "\u041d\u0435\u043a\u043e\u0442\u043e\u0440\u044b\u0435 \u0441\u0438\u043c\u0432\u043e\u043b\u044b Unicode \u0442\u0440\u0443\u0434\u043d\u043e \u0432\u0432\u0435\u0441\u0442\u0438 \u043d\u0430 \u0431\u043e\u043b\u044c\u0448\u0438\u043d\u0441\u0442\u0432\u0435 \u043a\u043b\u0430\u0432\u0438\u0430\u0442\u0443\u0440,\n\u0438 \u043b\u044e\u0434\u0438 \u0447\u0430\u0441\u0442\u043e \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u044e\u0442 \u043f\u043e\u0441\u043b\u0435\u0434\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438 \u043e\u0431\u044b\u0447\u043d\u044b\u0445 \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432 \u0432\u043c\u0435\u0441\u0442\u043e \u043d\u0438\u0445.\n", null, "\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u0441\u0438\u043c\u0432\u043e\u043b \u00ab%s\u00bb?"), new Rule.PatternRule("Typography.IBAN_FORMATTING", "\u0413\u0440\u0443\u043f\u043f\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0441\u0438\u043c\u0432\u043e\u043b\u044b \u0432 IBAN", "\u041d\u043e\u043c\u0435\u0440\u0430 IBAN \u0442\u0440\u0430\u0434\u0438\u0446\u0438\u043e\u043d\u043d\u043e \u0437\u0430\u043f\u0438\u0441\u044b\u0432\u0430\u044e\u0442\u0441\u044f \u0433\u0440\u0443\u043f\u043f\u0430\u043c\u0438 \u043f\u043e \u0447\u0435\u0442\u044b\u0440\u0435 \u0441\u0438\u043c\u0432\u043e\u043b\u0430, \u0440\u0430\u0437\u0434\u0435\u043b\u0435\u043d\u043d\u044b\u0445 \u043f\u0440\u043e\u0431\u0435\u043b\u0430\u043c\u0438.", "https://en.wikipedia.org/wiki/International_Bank_Account_Number", () -> FormattingIssues.ibanFormatting(NBSP_IBAN), new Example("\u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430, \u043f\u0440\u0438\u0448\u043b\u0438 \u043a\u0430\u043a \u043c\u043e\u0436\u043d\u043e \u0431\u043e\u043b\u044c\u0448\u0435 \u0434\u0435\u043d\u0435\u0433 \u043d\u0430 IBAN <b>DE89123447624758123400</b>, \u0431\u043e\u043b\u044c\u0448\u043e\u0435 \u0441\u043f\u0430\u0441\u0438\u0431\u043e!!!", "\u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430, \u043f\u0440\u0438\u0448\u043b\u0438 \u043a\u0430\u043a \u043c\u043e\u0436\u043d\u043e \u0431\u043e\u043b\u044c\u0448\u0435 \u0434\u0435\u043d\u0435\u0433 \u043d\u0430 IBAN <b>DE89\u00a01234\u00a04762\u00a04758\u00a01234\u00a000</b>, \u0431\u043e\u043b\u044c\u0448\u043e\u0435 \u0441\u043f\u0430\u0441\u0438\u0431\u043e!!!")), PunctuationRules.hyphenToDashRule());
    }

    private static NodePattern accentMark() {
        return NodePattern.or(NodePattern.N.formCaseSensitive("[\u0410-\u042f]?[\u0430-\u044f]+[" + accentableVowels.toUpperCase(Locale.ROOT) + "][\u0430-\u044f]*"), CommonPatterns.firstWord.formCaseSensitive("[\u0410-\u042f\u0430-\u044f][\u0430-\u044f]*[" + accentableVowels.toUpperCase(Locale.ROOT) + "][\u0430-\u044f]*")).and((node, match) -> {
            String word = node.form();
            if (word.length() < 3) {
                return null;
            }
            int upperIndex = (int)word.chars().skip(1L).takeWhile(c -> !Character.isUpperCase(c)).count() + 1;
            if (TypographyRules.seemsCamelHumpAbbreviation(word, upperIndex, node.tree().treeSupport())) {
                return null;
            }
            if (TypographyRules.couldBeJoinedWords(word, upperIndex, node.tree().treeSupport())) {
                return null;
            }
            if (upperIndex == 1 && Character.isUpperCase(word.charAt(0))) {
                match = match.withCorrector(NodeCorrector.replace(node, word.charAt(0) + word.substring(1).toLowerCase(Locale.ROOT)));
            }
            String sug = word.substring(0, upperIndex) + Character.toLowerCase(word.charAt(upperIndex)) + "\u0301" + word.substring(upperIndex + 1);
            TextRange rangeInWord = new TextRange(upperIndex - 1, Math.min(upperIndex + 2, word.length()));
            return match.withCorrector(NodeCorrector.replace(node, sug)).withReportedRange(rangeInWord.shiftRight(node.startOffset()), node.tree());
        }).message(STRESS_SIGN_MESSAGE);
    }

    private static boolean couldBeJoinedWords(String word, int upperIndex, TreeSupport support) {
        return support.tagToken(word.toLowerCase(Locale.ROOT)).posReadings().isEmpty() && !support.tagToken(word.substring(0, upperIndex)).posReadings().isEmpty() && !support.tagToken(word.substring(upperIndex)).posReadings().isEmpty();
    }

    private static boolean seemsCamelHumpAbbreviation(String word, int upperIndex, TreeSupport support) {
        if (upperIndex == word.length() - 1) {
            return false;
        }
        return !support.tagToken(word.toLowerCase(Locale.ROOT)).hasPos(".*");
    }
}

