/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.types;

import com.google.common.collect.ImmutableSet;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.ui.IconManager;
import com.intellij.ui.PlatformIcons;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyCallSiteExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyQualifiedNameOwner;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.resolve.CompletionVariantsProcessor;
import com.jetbrains.python.psi.types.PyCallableParameter;
import com.jetbrains.python.psi.types.PyCallableParameterImpl;
import com.jetbrains.python.psi.types.PyCallableType;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyTupleType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeVisitor;
import com.jetbrains.python.psi.types.PyTypeVisitorExt;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyNamedTupleType
extends PyTupleType
implements PyCallableType {
    private static final ImmutableSet<String> PYTHON_2_ATTRIBUTES = ImmutableSet.of((Object)"_make", (Object)"_asdict", (Object)"_replace", (Object)"_fields", (Object)"_field_defaults", (Object)"_field_types", (Object[])new String[0]);
    private static final ImmutableSet<String> PYTHON_3_ATTRIBUTES = ImmutableSet.of((Object)"_make", (Object)"_asdict", (Object)"_replace", (Object)"_fields", (Object)"_field_defaults");
    @NotNull
    private final String myName;
    @NotNull
    private final LinkedHashMap<String, FieldTypeAndDefaultValue> myFields;
    private final boolean myTyped;
    @Nullable
    private final PyQualifiedNameOwner myDeclaration;

    @NotNull
    public static Set<String> getSpecialAttributes(LanguageLevel level) {
        if (level.isPy3K()) {
            ImmutableSet<String> immutableSet = PYTHON_3_ATTRIBUTES;
            if (immutableSet == null) {
                PyNamedTupleType.$$$reportNull$$$0(0);
            }
            return immutableSet;
        }
        ImmutableSet<String> immutableSet = PYTHON_2_ATTRIBUTES;
        if (immutableSet == null) {
            PyNamedTupleType.$$$reportNull$$$0(1);
        }
        return immutableSet;
    }

    public PyNamedTupleType(@NotNull PyClass tupleClass, @NotNull String name, @NotNull LinkedHashMap<String, FieldTypeAndDefaultValue> fields, boolean isDefinition, boolean typed, @Nullable PyQualifiedNameOwner declaration) {
        if (tupleClass == null) {
            PyNamedTupleType.$$$reportNull$$$0(2);
        }
        if (name == null) {
            PyNamedTupleType.$$$reportNull$$$0(3);
        }
        if (fields == null) {
            PyNamedTupleType.$$$reportNull$$$0(4);
        }
        super(tupleClass, ContainerUtil.map(fields.values(), typeAndValue -> typeAndValue.getType()), false, isDefinition);
        this.myFields = new LinkedHashMap<String, FieldTypeAndDefaultValue>(fields);
        this.myName = name;
        this.myTyped = typed;
        this.myDeclaration = declaration;
    }

    @Override
    @NotNull
    public PyQualifiedNameOwner getDeclarationElement() {
        PyQualifiedNameOwner pyQualifiedNameOwner = (PyQualifiedNameOwner)ObjectUtils.notNull((Object)this.myDeclaration, () -> super.getDeclarationElement());
        if (pyQualifiedNameOwner == null) {
            PyNamedTupleType.$$$reportNull$$$0(5);
        }
        return pyQualifiedNameOwner;
    }

    @Override
    public Object @NotNull [] getCompletionVariants(String completionPrefix, PsiElement location, @NotNull ProcessingContext context) {
        if (context == null) {
            PyNamedTupleType.$$$reportNull$$$0(6);
        }
        ArrayList<Object> result = new ArrayList<Object>();
        Collections.addAll(result, super.getCompletionVariants(completionPrefix, location, context));
        for (String field : this.myFields.keySet()) {
            result.add(LookupElementBuilder.create((String)field).withIcon(IconManager.getInstance().getPlatformIcon(PlatformIcons.Field)));
        }
        if (completionPrefix == null) {
            Condition nameFilter = PyNamedTupleType.getSpecialAttributes(LanguageLevel.forElement((PsiElement)location))::contains;
            CompletionVariantsProcessor processor2 = new CompletionVariantsProcessor(location, null, (Condition<String>)nameFilter, false, context.get(CTX_SUPPRESS_PARENTHESES) != null);
            this.myClass.processClassLevelDeclarations((PsiScopeProcessor)processor2);
            result.addAll(processor2.getResultList());
        }
        Object[] objectArray = ArrayUtil.toObjectArray(result);
        if (objectArray == null) {
            PyNamedTupleType.$$$reportNull$$$0(7);
        }
        return objectArray;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            PyNamedTupleType.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Override
    public boolean isBuiltin() {
        return false;
    }

    @Nullable
    public PyNamedTupleType getCallType(@NotNull TypeEvalContext context, @NotNull PyCallSiteExpression callSite) {
        if (context == null) {
            PyNamedTupleType.$$$reportNull$$$0(9);
        }
        if (callSite == null) {
            PyNamedTupleType.$$$reportNull$$$0(10);
        }
        if (this.isDefinition()) {
            return this.getCallDefinitionType(callSite, context);
        }
        return null;
    }

    @Override
    @NotNull
    public PyNamedTupleType toInstance() {
        PyNamedTupleType pyNamedTupleType = this.isDefinition() ? new PyNamedTupleType(this.myClass, this.myName, this.myFields, false, this.myTyped, this.myDeclaration) : this;
        if (pyNamedTupleType == null) {
            PyNamedTupleType.$$$reportNull$$$0(11);
        }
        return pyNamedTupleType;
    }

    @NotNull
    public PyNamedTupleType toClass() {
        PyNamedTupleType pyNamedTupleType = !this.isDefinition() ? new PyNamedTupleType(this.myClass, this.myName, this.myFields, true, this.myTyped, this.myDeclaration) : this;
        if (pyNamedTupleType == null) {
            PyNamedTupleType.$$$reportNull$$$0(12);
        }
        return pyNamedTupleType;
    }

    @Override
    public String toString() {
        return "PyNamedTupleType: " + this.myName;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PyNamedTupleType type = (PyNamedTupleType)o;
        return Objects.equals(this.myName, type.myName) && Objects.equals(this.myFields.keySet(), type.myFields.keySet());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.myName, this.myFields.keySet());
    }

    @Override
    @NotNull
    public Set<String> getMemberNames(boolean inherited, @NotNull TypeEvalContext context) {
        if (context == null) {
            PyNamedTupleType.$$$reportNull$$$0(13);
        }
        Set<String> result = super.getMemberNames(inherited, context);
        result.addAll(this.myFields.keySet());
        Set<String> set = result;
        if (set == null) {
            PyNamedTupleType.$$$reportNull$$$0(14);
        }
        return set;
    }

    @NotNull
    public Map<String, FieldTypeAndDefaultValue> getFields() {
        Map<String, FieldTypeAndDefaultValue> map = Collections.unmodifiableMap(this.myFields);
        if (map == null) {
            PyNamedTupleType.$$$reportNull$$$0(15);
        }
        return map;
    }

    @Override
    public boolean isCallable() {
        return this.isDefinition();
    }

    @Override
    @Nullable
    public List<PyCallableParameter> getParameters(@NotNull TypeEvalContext context) {
        if (context == null) {
            PyNamedTupleType.$$$reportNull$$$0(16);
        }
        return this.isCallable() ? ContainerUtil.map(this.myFields.entrySet(), field -> PyNamedTupleType.fieldToCallableParameter((String)field.getKey(), (FieldTypeAndDefaultValue)field.getValue())) : null;
    }

    public boolean isTyped() {
        return this.myTyped;
    }

    @NotNull
    public PyNamedTupleType clarifyFields(@NotNull Map<String, PyType> fieldNameToType) {
        if (fieldNameToType == null) {
            PyNamedTupleType.$$$reportNull$$$0(17);
        }
        if (!this.myTyped) {
            LinkedHashMap<String, FieldTypeAndDefaultValue> newFields = new LinkedHashMap<String, FieldTypeAndDefaultValue>(this.myFields);
            for (Map.Entry<String, PyType> entry : fieldNameToType.entrySet()) {
                String fieldName = entry.getKey();
                if (!newFields.containsKey(fieldName)) continue;
                newFields.put(fieldName, new FieldTypeAndDefaultValue(entry.getValue(), null));
            }
            return new PyNamedTupleType(this.myClass, this.myName, newFields, this.isDefinition(), false, this.myDeclaration);
        }
        PyNamedTupleType pyNamedTupleType = this;
        if (pyNamedTupleType == null) {
            PyNamedTupleType.$$$reportNull$$$0(18);
        }
        return pyNamedTupleType;
    }

    @NotNull
    private PyNamedTupleType getCallDefinitionType(@NotNull PyCallSiteExpression callSite, @NotNull TypeEvalContext context) {
        List arguments;
        if (callSite == null) {
            PyNamedTupleType.$$$reportNull$$$0(19);
        }
        if (context == null) {
            PyNamedTupleType.$$$reportNull$$$0(20);
        }
        if (!this.myTyped && (arguments = callSite.getArguments(null)).size() == this.myFields.size()) {
            HashMap<String, PyType> result = new HashMap<String, PyType>();
            for (Map.Entry entry : StreamEx.ofKeys(this.myFields).zipWith((Stream)StreamEx.of((Collection)arguments))) {
                String name = (String)entry.getKey();
                PyType type = context.getType((PyTypedElement)entry.getValue());
                result.put(name, type);
            }
            PyNamedTupleType pyNamedTupleType = this.toInstance().clarifyFields(result);
            if (pyNamedTupleType == null) {
                PyNamedTupleType.$$$reportNull$$$0(21);
            }
            return pyNamedTupleType;
        }
        PyNamedTupleType pyNamedTupleType = this.toInstance();
        if (pyNamedTupleType == null) {
            PyNamedTupleType.$$$reportNull$$$0(22);
        }
        return pyNamedTupleType;
    }

    @NotNull
    private static PyCallableParameter fieldToCallableParameter(@NotNull String name, @NotNull FieldTypeAndDefaultValue typeAndDefaultValue) {
        if (name == null) {
            PyNamedTupleType.$$$reportNull$$$0(23);
        }
        if (typeAndDefaultValue == null) {
            PyNamedTupleType.$$$reportNull$$$0(24);
        }
        PyCallableParameter pyCallableParameter = PyCallableParameterImpl.nonPsi(name, typeAndDefaultValue.getType(), typeAndDefaultValue.getDefaultValue());
        if (pyCallableParameter == null) {
            PyNamedTupleType.$$$reportNull$$$0(25);
        }
        return pyCallableParameter;
    }

    @Override
    public <T> T acceptTypeVisitor(@NotNull PyTypeVisitor<T> visitor) {
        if (visitor == null) {
            PyNamedTupleType.$$$reportNull$$$0(26);
        }
        if (visitor instanceof PyTypeVisitorExt) {
            PyTypeVisitorExt visitorExt = (PyTypeVisitorExt)visitor;
            return visitorExt.visitPyNamedTupleType(this);
        }
        return (T)visitor.visitPyClassType((PyClassType)this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 6, 9, 10, 13, 16, 17, 19, 20, 23, 24, 26 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/types/PyNamedTupleType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tupleClass";
                break;
            }
            case 3: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fields";
                break;
            }
            case 6: 
            case 9: 
            case 13: 
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 10: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callSite";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldNameToType";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeAndDefaultValue";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSpecialAttributes";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 10: 
            case 13: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/types/PyNamedTupleType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclarationElement";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompletionVariants";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "toInstance";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "toClass";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getMemberNames";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getFields";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "clarifyFields";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getCallDefinitionType";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "fieldToCallableParameter";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getCompletionVariants";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getCallType";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getMemberNames";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getParameters";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "clarifyFields";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getCallDefinitionType";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "fieldToCallableParameter";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "acceptTypeVisitor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 6, 9, 10, 13, 16, 17, 19, 20, 23, 24, 26 -> new IllegalArgumentException(string);
        };
    }

    public static class FieldTypeAndDefaultValue {
        @Nullable
        private final PyType myType;
        @Nullable
        private final PyExpression myDefaultValue;

        public FieldTypeAndDefaultValue(@Nullable PyType type, @Nullable PyExpression defaultValue) {
            this.myType = type;
            this.myDefaultValue = defaultValue;
        }

        @Nullable
        public PyType getType() {
            return this.myType;
        }

        @Nullable
        public PyExpression getDefaultValue() {
            return this.myDefaultValue;
        }
    }
}

